/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.RationalFormulaManager;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class OptimizationIntReal {
    private static final Rational EPSILON = Rational.ofString((String)"1/1000");

    private OptimizationIntReal() {
    }

    public static void main(String ... args) throws InvalidConfigurationException, SolverException, InterruptedException {
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = BasicLogManager.create((Configuration)config);
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        SolverContextFactory.Solvers solver = SolverContextFactory.Solvers.Z3;
        OptimizationIntReal.optimizeWithIntegers(config, logger, notifier, solver);
        OptimizationIntReal.optimizeWithRationals(config, logger, notifier, solver);
    }

    private static void optimizeWithIntegers(Configuration config, LogManager logger, ShutdownNotifier notifier, SolverContextFactory.Solvers solver) throws InterruptedException, SolverException, InvalidConfigurationException {
        try (SolverContext context = SolverContextFactory.createSolverContext(config, logger, notifier, solver);
             OptimizationProverEnvironment prover = context.newOptimizationProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            BooleanFormulaManager bmgr = context.getFormulaManager().getBooleanFormulaManager();
            IntegerFormulaManager nmgr = context.getFormulaManager().getIntegerFormulaManager();
            NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)nmgr.makeVariable("x");
            prover.addConstraint(bmgr.and(nmgr.greaterOrEquals(x, (NumeralFormula.IntegerFormula)nmgr.makeNumber(0L)), nmgr.lessThan(x, (NumeralFormula.IntegerFormula)nmgr.makeNumber(10L))));
            logger.log(Level.INFO, new Object[]{"optimizing with integer logic"});
            OptimizationIntReal.printUpperAndLowerBound(prover, x, logger);
        }
    }

    private static void optimizeWithRationals(Configuration config, LogManager logger, ShutdownNotifier notifier, SolverContextFactory.Solvers solver) throws InterruptedException, SolverException, InvalidConfigurationException {
        try (SolverContext context = SolverContextFactory.createSolverContext(config, logger, notifier, solver);
             OptimizationProverEnvironment prover = context.newOptimizationProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            BooleanFormulaManager bmgr = context.getFormulaManager().getBooleanFormulaManager();
            RationalFormulaManager nmgr = context.getFormulaManager().getRationalFormulaManager();
            NumeralFormula.RationalFormula x = (NumeralFormula.RationalFormula)nmgr.makeVariable("x");
            prover.addConstraint(bmgr.and(nmgr.greaterOrEquals(x, nmgr.makeNumber(0L)), nmgr.lessThan(x, nmgr.makeNumber(10L))));
            logger.log(Level.INFO, new Object[]{"optimizing with rational logic"});
            OptimizationIntReal.printUpperAndLowerBound(prover, x, logger);
        }
    }

    private static void printUpperAndLowerBound(OptimizationProverEnvironment prover, NumeralFormula x, LogManager logger) throws InterruptedException, SolverException {
        prover.push();
        int handleX = prover.minimize(x);
        OptimizationProverEnvironment.OptStatus status = prover.check();
        assert (status == OptimizationProverEnvironment.OptStatus.OPT);
        Optional<Rational> lower = prover.lower(handleX, EPSILON);
        logger.log(Level.INFO, new Object[]{"lower bound:", lower.get(), "with model:", prover.getModel()});
        prover.pop();
        prover.push();
        handleX = prover.maximize(x);
        status = prover.check();
        assert (status == OptimizationProverEnvironment.OptStatus.OPT);
        Optional<Rational> upper = prover.upper(handleX, EPSILON);
        logger.log(Level.INFO, new Object[]{"upper bound:", upper.get(), "with model:", prover.getModel()});
        prover.pop();
    }
}

