/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import com.google.common.truth.TruthJUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.example.FormulaClassifier;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class FormulaClassifierTest
extends SolverBasedTest0 {
    private FormulaClassifier classifier;
    private static final String VARS = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)";
    private static final String BVS = "(declare-fun bv () (_ BitVec 4))(declare-fun bv2 () (_ BitVec 4))";
    @Parameterized.Parameter
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Before
    public void init() {
        this.classifier = new FormulaClassifier(this.context);
    }

    @Test
    public void test_AUFLIA() {
        this.requireQuantifiers();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (exists ((z Int)) (= (select arr x) (foo z))))";
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"AUFLIA", (Object)this.classifier.toString());
    }

    @Test
    public void test_QF_AUFLIA() {
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (= (select arr x) (foo 0)))";
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"QF_AUFLIA", (Object)this.classifier.toString());
    }

    @Test
    public void test_QF_AUFLIRA() {
        this.requireRationals();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (= (select arr x) (bar (/ 1 2))))";
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"QF_AUFLIRA", (Object)this.classifier.toString());
    }

    @Test
    public void test_QF_AUFNIRA() {
        this.requireRationals();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (= (select arr (* x x)) (bar (/ 1 2))))";
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"QF_AUFNIRA", (Object)this.classifier.toString());
    }

    @Test
    public void test_LIA() {
        this.requireQuantifiers();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (exists ((z Int)) (= (+ x 1) 0)))";
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"LIA", (Object)this.classifier.toString());
    }

    @Test
    public void test_LRA() {
        this.requireQuantifiers();
        this.requireRationals();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (exists ((zz Real)) (= (+ y y) zz)))";
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"LRA", (Object)this.classifier.toString());
    }

    @Test
    public void test_ABV() {
        this.requireQuantifiers();
        this.requireBitvectors();
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(declare-fun bv () (_ BitVec 4))(declare-fun bv2 () (_ BitVec 4))(assert (and (exists ((bv2 (_ BitVec 4))) (= bv bv2)) (= arr arr2)))";
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"ABV", (Object)this.classifier.toString());
    }

    @Test
    public void test_QF_AUFBV() {
        this.requireBitvectors();
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(declare-fun bv () (_ BitVec 4))(declare-fun bv2 () (_ BitVec 4))(assert (and (= bv bv2) (= arr arr2) (= (foo x) x)))";
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"QF_AUFBV", (Object)this.classifier.toString());
    }

    @Test
    public void test_QF_BV() {
        this.requireBitvectors();
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        String query = "(declare-fun bv () (_ BitVec 4))(declare-fun bv2 () (_ BitVec 4))(assert (bvult bv (bvadd bv #x1)))";
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"QF_BV", (Object)this.classifier.toString());
    }

    @Test
    public void test_QF_LIA() {
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (< xx (* x 2)))";
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"QF_LIA", (Object)this.classifier.toString());
    }

    @Test
    public void test_QF_LRA() {
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (< yy y))";
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"QF_LRA", (Object)this.classifier.toString());
    }

    @Test
    public void test_QF_NIA() {
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (< xx (* x x)))";
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"QF_NIA", (Object)this.classifier.toString());
    }

    @Test
    public void test_QF_NRA() {
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (< yy (* y y)))";
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"QF_NRA", (Object)this.classifier.toString());
    }

    @Test
    public void test_QF_UF() {
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (= (foo x) x))";
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"QF_UF", (Object)this.classifier.toString());
    }

    @Test
    public void test_QF_UFBV() {
        this.requireBitvectors();
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(declare-fun bv () (_ BitVec 4))(declare-fun bv2 () (_ BitVec 4))(assert (and (= bv bv2) (= (foo x) x)))";
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"QF_UFBV", (Object)this.classifier.toString());
    }

    @Test
    public void test_QF_UFLIA() {
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (< xx (+ x (foo x))))";
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"QF_UFLIA", (Object)this.classifier.toString());
    }

    @Test
    public void test_QF_UFLRA() {
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (< yy (bar y)))";
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"QF_UFLRA", (Object)this.classifier.toString());
    }

    @Test
    public void test_QF_UFNRA() {
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (< (* y yy) (bar y)))";
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"QF_UFNRA", (Object)this.classifier.toString());
    }

    @Test
    public void test_UFLRA() {
        this.requireQuantifiers();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (exists ((zz Real)) (< (+ y yy) (bar y))))";
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"UFLRA", (Object)this.classifier.toString());
    }

    @Test
    public void test_UFNRA() {
        this.requireQuantifiers();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (exists ((zz Real)) (< (* y yy) (bar y))))";
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.classifier.visit(this.mgr.parse(query));
        Assert.assertEquals((Object)"UFNRA", (Object)this.classifier.toString());
    }
}

