/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl.withAssumptionsWrapper;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverException;

public class BasicProverWithAssumptionsWrapper<T, P extends BasicProverEnvironment<T>>
implements BasicProverEnvironment<T> {
    protected final P delegate;
    protected final List<BooleanFormula> solverAssumptionsAsFormula = new ArrayList<BooleanFormula>();

    BasicProverWithAssumptionsWrapper(P pDelegate) {
        this.delegate = pDelegate;
    }

    protected void clearAssumptions() {
        for (int i = 0; i < this.solverAssumptionsAsFormula.size(); ++i) {
            this.delegate.pop();
        }
        this.solverAssumptionsAsFormula.clear();
    }

    @Override
    public void pop() {
        this.clearAssumptions();
        this.delegate.pop();
    }

    @Override
    public T addConstraint(BooleanFormula constraint) throws InterruptedException {
        this.clearAssumptions();
        return this.delegate.addConstraint(constraint);
    }

    @Override
    public void push() {
        this.clearAssumptions();
        this.delegate.push();
    }

    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        this.clearAssumptions();
        return this.delegate.isUnsat();
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        this.clearAssumptions();
        this.solverAssumptionsAsFormula.addAll(assumptions);
        for (BooleanFormula formula : assumptions) {
            this.registerPushedFormula(this.delegate.push(formula));
        }
        return this.delegate.isUnsat();
    }

    protected void registerPushedFormula(T pPushResult) {
    }

    @Override
    public Model getModel() throws SolverException {
        return this.delegate.getModel();
    }

    @Override
    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        return this.delegate.getModelAssignments();
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        return this.delegate.getUnsatCore();
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        this.clearAssumptions();
        return this.delegate.unsatCoreOverAssumptions(pAssumptions);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> pCallback, List<BooleanFormula> pImportant) throws InterruptedException, SolverException {
        this.clearAssumptions();
        return this.delegate.allSat(pCallback, pImportant);
    }
}

