/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class Interpolation {
    private Interpolation() {
    }

    public static void main(String ... args) throws InvalidConfigurationException, SolverException, InterruptedException {
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = BasicLogManager.create((Configuration)config);
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        SolverContextFactory.Solvers solver = SolverContextFactory.Solvers.SMTINTERPOL;
        try (SolverContext context = SolverContextFactory.createSolverContext(config, logger, notifier, solver);
             InterpolatingProverEnvironment<?> prover = context.newProverEnvironmentWithInterpolation(new SolverContext.ProverOptions[0]);){
            IntegerFormulaManager imgr = context.getFormulaManager().getIntegerFormulaManager();
            prover.push();
            Interpolation.interpolateExample(prover, imgr, logger);
            prover.pop();
            prover.push();
            Interpolation.interpolateProgramTrace(prover, imgr, logger);
            prover.pop();
        }
    }

    private static <T> void interpolateExample(InterpolatingProverEnvironment<T> prover, IntegerFormulaManager imgr, LogManager logger) throws InterruptedException, SolverException {
        NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)imgr.makeVariable("x");
        NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)imgr.makeVariable("y");
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)imgr.makeNumber(0L);
        Object ip0 = prover.addConstraint(imgr.greaterThan(x, y));
        Object ip1 = prover.addConstraint(imgr.equal(x, zero));
        Object ip2 = prover.addConstraint(imgr.greaterThan(y, zero));
        boolean unsat = prover.isUnsat();
        Preconditions.checkState((boolean)unsat, (Object)"the example for interpolation should be UNSAT");
        List<BooleanFormula> itps = prover.getSeqInterpolants0(Lists.newArrayList((Object[])new Object[]{ip0, ip1, ip2}));
        logger.log(Level.INFO, new Object[]{"1a :: Interpolants for [{ip0},{ip1},{ip2}] are:", itps});
        Set partition0 = Collections.singleton(ip0);
        Set partition1 = Collections.singleton(ip1);
        Set partition2 = Collections.singleton(ip2);
        itps = prover.getSeqInterpolants(Lists.newArrayList((Object[])new Set[]{partition0, partition1, partition2}));
        logger.log(Level.INFO, new Object[]{"1b :: Interpolants for [{ip0},{ip1},{ip2}] are:", itps});
        Set partition3 = Collections.singleton(ip0);
        HashSet partition4 = new HashSet();
        partition4.add(ip1);
        partition4.add(ip2);
        itps = prover.getSeqInterpolants(Lists.newArrayList((Object[])new Set[]{partition3, partition4}));
        logger.log(Level.INFO, new Object[]{"2a :: Interpolants for [{ip0},{ip1,ip2}] are:", itps});
        BooleanFormula itp = prover.getInterpolant(Lists.newArrayList((Object[])new Object[]{ip0}));
        logger.log(Level.INFO, new Object[]{"2b :: Interpolants for [{ip0},{ip1,ip2}] are:", itp});
    }

    private static <T> void interpolateProgramTrace(InterpolatingProverEnvironment<T> prover, IntegerFormulaManager imgr, LogManager logger) throws InterruptedException, SolverException {
        NumeralFormula.IntegerFormula i = (NumeralFormula.IntegerFormula)imgr.makeVariable("i");
        NumeralFormula.IntegerFormula i1 = (NumeralFormula.IntegerFormula)imgr.makeVariable("i'");
        NumeralFormula.IntegerFormula j = (NumeralFormula.IntegerFormula)imgr.makeVariable("j");
        NumeralFormula.IntegerFormula k = (NumeralFormula.IntegerFormula)imgr.makeVariable("k");
        NumeralFormula.IntegerFormula k1 = (NumeralFormula.IntegerFormula)imgr.makeVariable("k'");
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula fifty = (NumeralFormula.IntegerFormula)imgr.makeNumber(50L);
        ArrayList programTrace = Lists.newArrayList((Object[])new BooleanFormula[]{imgr.equal(i, zero), imgr.equal(k, j), imgr.lessThan(i, fifty), imgr.equal(i1, (NumeralFormula.IntegerFormula)imgr.add(i, one)), imgr.equal(k1, (NumeralFormula.IntegerFormula)imgr.add(k, one)), imgr.greaterOrEquals(i1, fifty), imgr.equal(j, zero), imgr.lessThan(k1, fifty)});
        ArrayList handles = Lists.newArrayList();
        for (BooleanFormula step : programTrace) {
            handles.add(prover.addConstraint(step));
        }
        boolean unsat = prover.isUnsat();
        Preconditions.checkState((boolean)unsat, (Object)"the example for interpolation should be UNSAT");
        List<BooleanFormula> itps = prover.getSeqInterpolants0(handles);
        logger.log(Level.INFO, new Object[]{"Interpolants for the program trace are:", itps});
    }
}

