/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.junit.AssumptionViolatedException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.visitors.DefaultBooleanFormulaVisitor;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
@SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
public class VariableNamesTest
extends SolverBasedTest0 {
    private static final ImmutableList<String> NAMES = ImmutableList.of((Object)"as", (Object)"exists", (Object)"forall", (Object)"par", (Object)"let", (Object)"BINARY", (Object)"DECIMAL", (Object)"HEXADECIAML", (Object)"NUMERAL", (Object)"STRING", (Object)"define-fun", (Object)"declare", (Object[])new String[]{"get-model", "exit", "(exit)", "!=", "~", "!", ",", ".", ":", " ", "  ", "(", ")", "[", "]", "{", "}", "[]", "\"", "''", "\n", "\t", "\u0000", "\u0001", "\u1234", "\u2e80", " this is a quoted symbol ", " so is \n  this one ", " \" can occur too ", " af klj ^*0 asfe2 (&*)&(#^ $ > > >?\" \u2019]]984"});
    private static final ImmutableSet<String> POSSIBLY_UNSUPPORTED_NAMES = ImmutableSet.of((Object)"true", (Object)"false", (Object)"and", (Object)"or", (Object)"+", (Object)"-", (Object[])new String[]{"*", "=", "<", "<=", ">", ">=", "select", "store", "|", "||", "|||", "|test", "|test|", "t|e|s|t", "\"\"", "\\", "| this is a quoted symbol |", "| so is \n  this one |", "| \" can occur too |", "| af klj ^*0 asfe2 (&*)&(#^ $ > > >?\" \u2019]]984|"});
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;
    @Parameterized.Parameter(value=1)
    public String varname;

    @Parameterized.Parameters(name="{0} with varname {1}")
    public static List<Object[]> getAllCombinations() {
        ImmutableList allNames = FluentIterable.from(NAMES).append(POSSIBLY_UNSUPPORTED_NAMES).toList();
        return Lists.transform((List)Lists.cartesianProduct((List[])new List[]{Arrays.asList(SolverContextFactory.Solvers.values()), allNames}), List::toArray);
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @CanIgnoreReturnValue
    private <T extends Formula> T createVariableWith(Function<String, T> creator) {
        try {
            return (T)((Formula)creator.apply(this.varname));
        }
        catch (RuntimeException e) {
            if (POSSIBLY_UNSUPPORTED_NAMES.contains((Object)this.varname)) {
                throw new AssumptionViolatedException("unsupported variable name", (Throwable)e);
            }
            throw e;
        }
    }

    @Test
    public void testBoolVariable() {
        this.createVariableWith(this.bmgr::makeVariable);
    }

    @Test
    public void testBoolVariableEscaping() throws SolverException, InterruptedException {
        BooleanFormula var = this.createVariableWith(this.bmgr::makeVariable);
        if (this.varname.equals(var.toString())) {
            BooleanFormula varFromString = this.bmgr.makeVariable(var.toString());
            this.assertThatFormula(var).isEquivalentTo(varFromString);
        } else {
            Truth.assertThat((String)var.toString()).startsWith("|");
            Truth.assertThat((String)var.toString()).endsWith("|");
            TruthJUnit.assume().that((Comparable)((Object)this.solver)).isNotEqualTo((Object)SolverContextFactory.Solvers.SMTINTERPOL);
            BooleanFormula varFromString = this.bmgr.makeVariable(var.toString());
            this.assertThatFormula(this.bmgr.xor(var, varFromString)).isSatisfiable();
            Truth.assert_().withMessage("name is escaped once, then the second call should escape it twice").that(varFromString.toString()).isNotEqualTo((Object)this.varname);
            Truth.assert_().withMessage("name is escaped once, then the second call should escape it twice").that(this.mgr.dumpFormula(varFromString).toString()).isNotEqualTo((Object)this.mgr.dumpFormula(var).toString());
        }
    }

    @Test
    public void testBoolVariableNameInVisitor() {
        BooleanFormula var = this.createVariableWith(this.bmgr::makeVariable);
        this.bmgr.visit(var, new DefaultBooleanFormulaVisitor<Void>(){

            @Override
            protected Void visitDefault() {
                throw new AssertionError((Object)"unexpected case");
            }

            @Override
            public Void visitAtom(BooleanFormula pAtom, FunctionDeclaration<BooleanFormula> pDecl) {
                Truth.assertThat((String)pDecl.getName()).isEqualTo((Object)VariableNamesTest.this.varname);
                return null;
            }
        });
    }

    @Test
    public void testBoolVariableDump() {
        BooleanFormula var = this.createVariableWith(this.bmgr::makeVariable);
        String dump = this.mgr.dumpFormula(var).toString();
    }

    @Test
    public void testIntVariable() {
        this.createVariableWith(this.imgr::makeVariable);
    }

    @Test
    public void testInvalidRatVariable() {
        this.requireRationals();
        this.createVariableWith(this.rmgr::makeVariable);
    }

    @Test
    public void testBVVariable() {
        this.requireBitvectors();
        this.createVariableWith(v -> this.bvmgr.makeVariable(4, (String)v));
    }

    @Test
    public void testInvalidFloatVariable() {
        this.requireFloats();
        this.createVariableWith(v -> this.fpmgr.makeVariable((String)v, FormulaType.getSinglePrecisionFloatingPointType()));
    }

    @Test
    public void testArrayVariable() {
        this.requireArrays();
        this.createVariableWith(v -> this.amgr.makeArray((String)v, FormulaType.IntegerType, FormulaType.IntegerType));
    }
}

