/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverException;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class ProverEnvironmentSubject
extends Subject<ProverEnvironmentSubject, BasicProverEnvironment<?>> {
    private ProverEnvironmentSubject(FailureMetadata pMetadata, BasicProverEnvironment<?> pStack) {
        super(pMetadata, pStack);
    }

    public static Subject.Factory<ProverEnvironmentSubject, BasicProverEnvironment<?>> proverEnvironments() {
        return (metadata, formula) -> new ProverEnvironmentSubject(metadata, (BasicProverEnvironment<?>)formula);
    }

    public static final ProverEnvironmentSubject assertThat(BasicProverEnvironment<?> prover) {
        return (ProverEnvironmentSubject)Truth.assert_().about(ProverEnvironmentSubject.proverEnvironments()).that(prover);
    }

    public void isUnsatisfiable() throws SolverException, InterruptedException {
        if (((BasicProverEnvironment)this.actual()).isUnsat()) {
            return;
        }
        try (Model model = ((BasicProverEnvironment)this.actual()).getModel();){
            this.failWithBadResults("is", "unsatisfiable", "has counterexample", model);
        }
    }

    public void isSatisfiable() throws SolverException, InterruptedException {
        if (!((BasicProverEnvironment)this.actual()).isUnsat()) {
            return;
        }
        if (this.actual() instanceof ProverEnvironment) {
            try {
                List<BooleanFormula> unsatCore = ((ProverEnvironment)this.actual()).getUnsatCore();
                if (!unsatCore.isEmpty()) {
                    this.failWithBadResults("is", "satisfiable", "has unsat core", unsatCore);
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.fail("is", "satisfiable");
    }
}

