/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.ProverEnvironmentSubject;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class ModelTest
extends SolverBasedTest0 {
    private static final ImmutableList<SolverContextFactory.Solvers> SOLVERS_WITH_PARTIAL_MODEL = ImmutableList.of((Object)((Object)SolverContextFactory.Solvers.Z3), (Object)((Object)SolverContextFactory.Solvers.PRINCESS));
    @Parameterized.Parameter
    public SolverContextFactory.Solvers solver;
    static final String SMALL_ARRAY_QUERY = "(declare-fun A1 () (Array Int Int))(declare-fun A2 () (Array Int Int))(declare-fun X () Int)(declare-fun Y () Int)(assert (= A1 (store A2 X Y)))";
    static final String BIG_ARRAY_QUERY = "(declare-fun |V#2@| () Int)(declare-fun z3name!115 () Int)(declare-fun P42 () Bool)(declare-fun M@3 () Int)(declare-fun P43 () Bool)(declare-fun |V#1@| () Int)(declare-fun z3name!114 () Int)(declare-fun P44 () Bool)(declare-fun M@2 () Int)(declare-fun P45 () Bool)(declare-fun |It15@5| () Int)(declare-fun |It13@5| () Int)(declare-fun |H@12| () (Array Int Int))(declare-fun |H@13| () (Array Int Int))(declare-fun |It14@5| () Int)(declare-fun |IN@5| () Int)(declare-fun |It12@5| () Int)(declare-fun |It11@5| () Int)(declare-fun |It9@5| () Int)(declare-fun |H@11| () (Array Int Int))(declare-fun |It10@5| () Int)(declare-fun |It8@5| () Int)(declare-fun |Anew@3| () Int)(declare-fun |Aprev@3| () Int)(declare-fun |H@10| () (Array Int Int))(declare-fun |At7@5| () Int)(declare-fun |H@9| () (Array Int Int))(declare-fun |At6@5| () Int)(declare-fun |Anext@3| () Int)(declare-fun |H@8| () (Array Int Int))(declare-fun |At5@5| () Int)(declare-fun |H@7| () (Array Int Int))(declare-fun |At4@5| () Int)(declare-fun |at3@5| () Int)(declare-fun |ahead@3| () Int)(declare-fun |anew@3| () Int)(declare-fun gl@ () Int)(declare-fun |It7@5| () Int)(declare-fun |It6@5| () Int)(declare-fun |It5@5| () Int)(declare-fun |Ivalue@3| () Int)(declare-fun i@2 () (Array Int Int))(declare-fun i@3 () (Array Int Int))(declare-fun P46 () Bool)(declare-fun |It4@5| () Int)(declare-fun |It4@3| () Int)(declare-fun |IT@5| () Int)(declare-fun |gl_read::T@4| () Int)(declare-fun __VERIFIER_nondet_int@4 () Int)(declare-fun |It15@3| () Int)(declare-fun |It13@3| () Int)(declare-fun |H@6| () (Array Int Int))(declare-fun |It14@3| () Int)(declare-fun |IN@3| () Int)(declare-fun |It12@3| () Int)(declare-fun |It11@3| () Int)(declare-fun |It9@3| () Int)(declare-fun |H@5| () (Array Int Int))(declare-fun |It10@3| () Int)(declare-fun |It8@3| () Int)(declare-fun |Anew@2| () Int)(declare-fun |Aprev@2| () Int)(declare-fun |H@4| () (Array Int Int))(declare-fun |At7@3| () Int)(declare-fun |H@3| () (Array Int Int))(declare-fun |At6@3| () Int)(declare-fun |Anext@2| () Int)(declare-fun |H@2| () (Array Int Int))(declare-fun |At5@3| () Int)(declare-fun |H@1| () (Array Int Int))(declare-fun |At4@3| () Int)(declare-fun |at3@3| () Int)(declare-fun |ahead@2| () Int)(declare-fun |anew@2| () Int)(declare-fun |It7@3| () Int)(declare-fun |It6@3| () Int)(declare-fun |It5@3| () Int)(declare-fun |Ivalue@2| () Int)(declare-fun i@1 () (Array Int Int))(declare-fun P47 () Bool)(declare-fun |IT@3| () Int)(declare-fun |gl_read::T@3| () Int)(declare-fun __VERIFIER_nondet_int@2 () Int)(assert   (and (not (<= gl@ 0))       (not (<= gl@ (- 64)))       (= |gl_read::T@3| __VERIFIER_nondet_int@2)       (= |Ivalue@2| |gl_read::T@3|)       (= |It4@3| 20)       (= |IT@3| z3name!114)       (not (<= |V#1@| 0))       (= |IN@3| |IT@3|)       (not (<= |V#1@| (+ 64 gl@)))       (not (<= |V#1@| (- 160)))       (not (<= (+ |V#1@| (* 8 |It4@3|)) 0))       (or (and P47 (not (<= |IN@3| 0))) (and (not P47) (not (>= |IN@3| 0))))       (= i@2 (store i@1 |IN@3| |Ivalue@2|))       (= |It5@3| |IN@3|)       (= |It6@3| (+ 4 |It5@3|))       (= |It7@3| |It6@3|)       (= |anew@2| |It7@3|)       (= |ahead@2| gl@)       (= |at3@3| (select |H@1| |ahead@2|))       (= |Anew@2| |anew@2|)       (= |Aprev@2| |ahead@2|)       (= |Anext@2| |at3@3|)       (= |At4@3| |Anext@2|)       (= |At5@3| (+ 4 |At4@3|))       (= |H@2| (store |H@1| |At5@3| |Anew@2|))       (= |H@3| (store |H@2| |Anew@2| |Anext@2|))       (= |At6@3| |Anew@2|)       (= |At7@3| (+ 4 |At6@3|))       (= |H@4| (store |H@3| |At7@3| |Aprev@2|))       (= |H@5| (store |H@4| |Aprev@2| |Anew@2|))       (= |It8@3| |IN@3|)       (= |It9@3| (+ 12 |It8@3|))       (= |It10@3| |IN@3|)       (= |It11@3| (+ 12 |It10@3|))       (= |H@6| (store |H@5| |It9@3| |It11@3|))       (= |It12@3| |IN@3|)       (= |It13@3| (+ 12 |It12@3|))       (= |It14@3| |IN@3|)       (= |It15@3| (+ 12 |It14@3|))       (= |H@7| (store |H@6| |It13@3| |It15@3|))       (= |gl_read::T@4| __VERIFIER_nondet_int@4)       (= |Ivalue@3| |gl_read::T@4|)       (= |It4@5| 20)       (= |IT@5| z3name!115)       (not (<= |V#2@| 0))       (= |IN@5| |IT@5|)       (not (<= |V#2@| (+ |V#1@| (* 8 |It4@3|))))       (not (<= |V#2@| (+ 160 |V#1@|)))       (not (<= |V#2@| (- 160)))       (not (<= (+ |V#2@| (* 8 |It4@5|)) 0))       (or (and P46 (not (<= |IN@5| 0))) (and (not P46) (not (>= |IN@5| 0))))       (= i@3 (store i@2 |IN@5| |Ivalue@3|))       (= |It5@5| |IN@5|)       (= |It6@5| (+ 4 |It5@5|))       (= |It7@5| |It6@5|)       (= |anew@3| |It7@5|)       (= |ahead@3| gl@)       (= |at3@5| (select |H@7| |ahead@3|))       (= |Anew@3| |anew@3|)       (= |Aprev@3| |ahead@3|)       (= |Anext@3| |at3@5|)       (= |At4@5| |Anext@3|)       (= |At5@5| (+ 4 |At4@5|))       (= |H@8| (store |H@7| |At5@5| |Anew@3|))       (= |H@9| (store |H@8| |Anew@3| |Anext@3|))       (= |At6@5| |Anew@3|)       (= |At7@5| (+ 4 |At6@5|))       (= |H@10| (store |H@9| |At7@5| |Aprev@3|))       (= |H@11| (store |H@10| |Aprev@3| |Anew@3|))       (= |It8@5| |IN@5|)       (= |It9@5| (+ 12 |It8@5|))       (= |It10@5| |IN@5|)       (= |It11@5| (+ 12 |It10@5|))       (= |H@12| (store |H@11| |It9@5| |It11@5|))       (= |It12@5| |IN@5|)       (= |It13@5| (+ 12 |It12@5|))       (= |It14@5| |IN@5|)       (= |It15@5| (+ 12 |It14@5|))       (= |H@13| (store |H@12| |It13@5| |It15@5|))       (or (and P45 (not (= M@2 0)))  (and (not P45) (= z3name!114 0)))       (or (and P44 (= M@2 0)) (and (not P44) (= z3name!114 |V#1@|)))       (or (and P43 (not (= M@3 0))) (and (not P43) (= z3name!115 0)))       (or (and P42 (= M@3 0)) (and (not P42) (= z3name!115 |V#2@|)))))";
    static final String MEDIUM_ARRAY_QUERY = "(declare-fun |H@1| () (Array Int Int))(declare-fun |H@2| () (Array Int Int))(declare-fun |H@3| () (Array Int Int))(declare-fun |H@4| () (Array Int Int))(declare-fun |H@5| () (Array Int Int))(declare-fun |H@6| () (Array Int Int))(declare-fun |H@7| () (Array Int Int))(declare-fun |H@8| () (Array Int Int))(declare-fun |H@9| () (Array Int Int))(declare-fun |H@10| () (Array Int Int))(declare-fun |H@11| () (Array Int Int))(declare-fun |H@12| () (Array Int Int))(declare-fun |H@13| () (Array Int Int))(declare-fun I10 () Int)(declare-fun I11 () Int)(declare-fun I12 () Int)(declare-fun I13 () Int)(declare-fun I14 () Int)(declare-fun I15 () Int)(declare-fun |at3@5| () Int)(declare-fun |at3@3| () Int)(declare-fun |At5@3| () Int)(declare-fun |At7@3| () Int)(declare-fun |At7@5| () Int)(declare-fun |ahead@3| () Int)(declare-fun |ahead@2| () Int)(declare-fun |At5@5| () Int)(assert   (and (not (<= |ahead@2| 0))       (= |H@2| (store |H@1| |At5@3| 1))       (= |H@3| (store |H@2| 3 1))       (= |H@4| (store |H@3| 4 1))       (= |H@5| (store |H@4| 5 1))       (= |H@6| (store |H@5| 6 1))       (= |H@7| (store |H@6| 7 1))       (= |H@8| (store |H@7| 8 1))       (= |at3@3| (select |H@1| |ahead@2|))       (= |at3@5| (select |H@7| |ahead@3|))       (= I11 (+ 12 I10))       (= I13 (+ 12 I12))       (= I15 (+ 12 I14))       ))";
    static final String UGLY_ARRAY_QUERY = "(declare-fun V () Int)(declare-fun W () Int)(declare-fun A () Int)(declare-fun B () Int)(declare-fun U () Int)(declare-fun G () Int)(declare-fun ARR () (Array Int Int))(declare-fun EMPTY () (Array Int Int))(assert   (and (> (+ V U) 0)       (not (= B (- 4)))       (= ARR (store (store (store EMPTY G B) B G) A W))       ))";
    static final String UGLY_ARRAY_QUERY_2 = "(declare-fun A () Int)(declare-fun B () Int)(declare-fun ARR () (Array Int Int))(declare-fun EMPTY () (Array Int Int))(assert (and (= A 0) (= B 0) (= ARR (store (store EMPTY A 1) B 2))))";
    static final String SMALL_BV_FLOAT_QUERY = "(declare-fun |f@2| () (_ FloatingPoint 8 23))(declare-fun |p@3| () (_ BitVec 32))(declare-fun *float@1 () (Array (_ BitVec 32) (_ FloatingPoint 8 23)))(declare-fun |i@3| () (_ BitVec 32))(declare-fun |Ai@| () (_ BitVec 32))(declare-fun *unsigned_int@1 () (Array (_ BitVec 32) (_ BitVec 32)))(assert (and (bvslt #x00000000 |Ai@|)     (bvslt #x00000000 (bvadd |Ai@| #x00000020))     (= |i@3| #x00000000)     (= |p@3| |Ai@|)     (= (select *unsigned_int@1 |Ai@|) |i@3|)     (= |f@2| (select *float@1 |p@3|))     (not (fp.eq ((_ to_fp 11 52) roundNearestTiesToEven |f@2|)                 (_ +zero 11 52)))))";
    static final String SMALL_BV_FLOAT_QUERY2 = "(declare-fun a () (_ FloatingPoint 8 23))(declare-fun A () (Array (_ BitVec 32) (_ FloatingPoint 8 23)))(assert (= a (select A #x00000000)))";

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void testGetSmallIntegers() throws SolverException, InterruptedException {
        this.testModelGetters(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L)), (Formula)this.imgr.makeVariable("x"), BigInteger.valueOf(10L), "x");
    }

    @Test
    public void testGetNegativeIntegers() throws SolverException, InterruptedException {
        this.testModelGetters(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(-10L)), (Formula)this.imgr.makeVariable("x"), BigInteger.valueOf(-10L), "x");
    }

    @Test
    public void testGetLargeIntegers() throws SolverException, InterruptedException {
        BigInteger large = new BigInteger("1000000000000000000000000000000000000000");
        this.testModelGetters(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(large)), (Formula)this.imgr.makeVariable("x"), large, "x");
    }

    @Test
    public void testGetSmallIntegralRationals() throws SolverException, InterruptedException {
        this.requireRationals();
        this.testModelGetters(this.rmgr.equal(this.rmgr.makeVariable("x"), this.rmgr.makeNumber(1L)), (Formula)this.rmgr.makeVariable("x"), Rational.ONE, "x");
    }

    @Test
    public void testGetLargeIntegralRationals() throws SolverException, InterruptedException {
        this.requireRationals();
        BigInteger large = new BigInteger("1000000000000000000000000000000000000000");
        this.testModelGetters(this.rmgr.equal(this.rmgr.makeVariable("x"), this.rmgr.makeNumber(large)), (Formula)this.rmgr.makeVariable("x"), Rational.ofBigInteger((BigInteger)large), "x");
    }

    @Test
    public void testGetRationals() throws SolverException, InterruptedException {
        this.requireRationals();
        this.testModelGetters(this.rmgr.equal(this.rmgr.makeVariable("x"), this.rmgr.makeNumber(Rational.ofString((String)"1/3"))), (Formula)this.rmgr.makeVariable("x"), Rational.ofString((String)"1/3"), "x");
    }

    @Test
    public void testGetBooleans() throws SolverException, InterruptedException {
        this.testModelGetters(this.bmgr.makeVariable("x"), this.bmgr.makeBoolean(true), true, "x");
    }

    @Test
    public void testGetUFs() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula x = this.fmgr.declareAndCallUF("UF", FormulaType.IntegerType, (List<Formula>)ImmutableList.of(this.imgr.makeVariable("arg")));
        this.testModelGetters(this.imgr.equal(x, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)), x, BigInteger.ONE, "UF");
    }

    @Test
    public void testGetMultipleUFs() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula arg1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("arg1");
        NumeralFormula.IntegerFormula arg2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("arg2");
        FunctionDeclaration<NumeralFormula.IntegerFormula> declaration = this.fmgr.declareUF("UF", FormulaType.IntegerType, FormulaType.IntegerType);
        NumeralFormula.IntegerFormula app1 = this.fmgr.callUF(declaration, arg1);
        NumeralFormula.IntegerFormula app2 = this.fmgr.callUF(declaration, arg2);
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula two = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L);
        NumeralFormula.IntegerFormula three = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(3L);
        NumeralFormula.IntegerFormula four = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(4L);
        ImmutableList expectedModel = ImmutableList.of((Object)new Model.ValueAssignment(arg1, three, this.imgr.equal(arg1, three), "arg1", BigInteger.valueOf(3L), (Collection<?>)ImmutableList.of()), (Object)new Model.ValueAssignment(arg2, four, this.imgr.equal(arg2, four), "arg2", BigInteger.valueOf(4L), (Collection<?>)ImmutableList.of()), (Object)new Model.ValueAssignment(this.fmgr.callUF(declaration, three), one, this.imgr.equal(this.fmgr.callUF(declaration, three), one), "UF", BigInteger.valueOf(1L), (Collection<?>)ImmutableList.of((Object)BigInteger.valueOf(3L))), (Object)new Model.ValueAssignment(this.fmgr.callUF(declaration, four), (Formula)this.imgr.makeNumber(2L), this.imgr.equal(this.fmgr.callUF(declaration, four), two), "UF", BigInteger.valueOf(2L), (Collection<?>)ImmutableList.of((Object)BigInteger.valueOf(4L))));
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(this.bmgr.and(this.imgr.equal(app1, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)), this.imgr.equal(app2, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L))));
            prover.push(this.imgr.equal(arg1, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(3L)));
            prover.push(this.imgr.equal(arg2, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(4L)));
            ProverEnvironmentSubject.assertThat(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                Truth.assertThat((Comparable)m.evaluate(app1)).isEqualTo((Object)BigInteger.ONE);
                Truth.assertThat((Comparable)m.evaluate(app2)).isEqualTo((Object)BigInteger.valueOf(2L));
                Truth.assertThat((Iterable)m).containsExactlyElementsIn((Iterable)expectedModel);
            }
            Truth.assertThat(prover.getModelAssignments()).containsExactlyElementsIn((Iterable)expectedModel);
        }
    }

    @Test
    public void testQuantifiedUF() throws SolverException, InterruptedException {
        this.requireQuantifiers();
        NumeralFormula.IntegerFormula var = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("var");
        BooleanFormula varIsOne = this.imgr.equal(var, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L));
        NumeralFormula.IntegerFormula boundVar = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("boundVar");
        BooleanFormula boundVarIsZero = this.imgr.equal(boundVar, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L));
        String func = "func";
        NumeralFormula.IntegerFormula funcAtZero = this.fmgr.declareAndCallUF(func, FormulaType.IntegerType, new Formula[]{this.imgr.makeNumber(0L)});
        NumeralFormula.IntegerFormula funcAtBoundVar = this.fmgr.declareAndCallUF(func, FormulaType.IntegerType, boundVar);
        BooleanFormula body = this.bmgr.and(boundVarIsZero, this.imgr.equal(var, funcAtBoundVar));
        BooleanFormula f = this.bmgr.and(varIsOne, this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)boundVar), body));
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(f);
            ProverEnvironmentSubject.assertThat(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                for (Model.ValueAssignment valueAssignment : m) {
                }
                Truth.assertThat((Iterable)m).contains((Object)new Model.ValueAssignment(funcAtZero, one, this.imgr.equal(funcAtZero, one), func, BigInteger.ONE, (Collection<?>)ImmutableList.of((Object)BigInteger.ZERO)));
            }
        }
    }

    @Test
    public void testGetBitvectors() throws SolverException, InterruptedException {
        this.requireBitvectors();
        this.testModelGetters(this.bvmgr.equal(this.bvmgr.makeVariable(1, "x"), this.bvmgr.makeBitvector(1, BigInteger.ONE)), this.bvmgr.makeVariable(1, "x"), BigInteger.ONE, "x");
    }

    @Test
    public void testGetModelAssignments() throws SolverException, InterruptedException {
        this.testModelIterator(this.bmgr.and(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"))));
    }

    @Test
    public void testEmptyStackModel() throws SolverException, InterruptedException {
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            ProverEnvironmentSubject.assertThat(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                Truth.assertThat((Comparable)m.evaluate((NumeralFormula.IntegerFormula)this.imgr.makeNumber(123L))).isEqualTo((Object)BigInteger.valueOf(123L));
                Truth.assertThat((Boolean)m.evaluate(this.bmgr.makeBoolean(true))).isEqualTo((Object)true);
                Truth.assertThat((Boolean)m.evaluate(this.bmgr.makeBoolean(false))).isEqualTo((Object)false);
                if (SOLVERS_WITH_PARTIAL_MODEL.contains((Object)this.solver)) {
                    Truth.assertThat((Comparable)m.evaluate((NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"))).isNull();
                } else {
                    Truth.assertThat((Comparable)m.evaluate((NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"))).isNotNull();
                }
            }
        }
    }

    @Test
    public void testNonExistantSymbol() throws SolverException, InterruptedException {
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(this.bmgr.makeBoolean(true));
            ProverEnvironmentSubject.assertThat(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                if (SOLVERS_WITH_PARTIAL_MODEL.contains((Object)this.solver)) {
                    Truth.assertThat((Comparable)m.evaluate((NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"))).isNull();
                } else {
                    Truth.assertThat((Comparable)m.evaluate((NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"))).isNotNull();
                }
            }
        }
    }

    @Test
    public void testPartialModels() throws SolverException, InterruptedException {
        TruthJUnit.assume().withMessage("As of now, only Z3 and Princess support partial models").that((Comparable)((Object)this.solver)).isIn(SOLVERS_WITH_PARTIAL_MODEL);
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
            prover.push(this.imgr.equal(x, x));
            ProverEnvironmentSubject.assertThat(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                Truth.assertThat((Comparable)m.evaluate(x)).isEqualTo(null);
                Truth.assertThat((Iterable)m).isEmpty();
            }
        }
    }

    @Test
    public void testPartialModelsUF() throws SolverException, InterruptedException {
        TruthJUnit.assume().withMessage("As of now, only Z3 and Princess support partial model evaluation").that((Comparable)((Object)this.solver)).isIn((Iterable)ImmutableList.of((Object)((Object)SolverContextFactory.Solvers.Z3), (Object)((Object)SolverContextFactory.Solvers.PRINCESS)));
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
            NumeralFormula.IntegerFormula f = this.fmgr.declareAndCallUF("f", FormulaType.IntegerType, x);
            prover.push(this.imgr.equal(x, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
            ProverEnvironmentSubject.assertThat(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                Truth.assertThat((Comparable)m.evaluate(f)).isEqualTo(null);
            }
        }
    }

    @Test
    public void testEvaluatingConstants() throws SolverException, InterruptedException {
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(this.bmgr.makeVariable("b"));
            Truth.assertThat((Boolean)prover.isUnsat()).isFalse();
            try (Model m = prover.getModel();){
                Truth.assertThat((Comparable)m.evaluate((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L))).isEqualTo((Object)BigInteger.ONE);
                Truth.assertThat((Boolean)m.evaluate(this.bmgr.makeBoolean(true))).isEqualTo((Object)true);
            }
        }
    }

    @Test
    public void testGetArrays() throws SolverException, InterruptedException {
        this.requireArrays();
        ArrayFormula array = this.amgr.makeArray("array", FormulaType.IntegerType, FormulaType.IntegerType);
        ArrayFormula<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> updated = this.amgr.store(array, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L));
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(this.imgr.equal(this.amgr.select(updated, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
            ProverEnvironmentSubject.assertThat(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                for (Model.ValueAssignment valueAssignment : m) {
                }
                Truth.assertThat((Comparable)m.evaluate(this.amgr.select(updated, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)))).isEqualTo((Object)BigInteger.ONE);
            }
        }
    }

    @Test
    public void testGetArrays2() throws SolverException, InterruptedException {
        this.requireArrays();
        BooleanFormula f = this.mgr.parse("(declare-fun |pi@2| () Int)\n(declare-fun *unsigned_int@1 () (Array Int Int))\n(declare-fun |z2@2| () Int)\n(declare-fun |z1@2| () Int)\n(declare-fun |t@2| () Int)\n(declare-fun |__ADDRESS_OF_t| () Int)\n(declare-fun *char@1 () (Array Int Int))\n(assert    (and (= |t@2| 50)        (not (<= |__ADDRESS_OF_t| 0))        (= |z1@2| |__ADDRESS_OF_t|)        (= (select *char@1 |__ADDRESS_OF_t|) |t@2|)        (= |z2@2| |z1@2|)        (= |pi@2| |z2@2|)        (not (= (select *unsigned_int@1 |pi@2|) 50))))");
        this.testModelIterator(f);
    }

    @Test
    public void testGetArrays3() throws SolverException, InterruptedException {
        this.requireArrays();
        TruthJUnit.assume().withMessage("As of now, only Princess does not support multi-dimensional arrays").that((Comparable)((Object)this.solver)).isNotSameAs((Object)SolverContextFactory.Solvers.PRINCESS);
        BooleanFormula f = this.mgr.parse("(declare-fun x () Int)\n(declare-fun arr () (Array Int (Array Int (Array Int Int))))\n(assert (and    (= (select (select (select arr 5) 3) 1) x)    (= x 123)))");
        this.testModelIterator(f);
        this.testModelGetters(f, (Formula)this.imgr.makeVariable("x"), BigInteger.valueOf(123L), "x");
        FormulaType.ArrayFormulaType arrType = FormulaType.getArrayType(FormulaType.IntegerType, FormulaType.getArrayType(FormulaType.IntegerType, FormulaType.getArrayType(FormulaType.IntegerType, FormulaType.IntegerType)));
        this.testModelGetters(f, (Formula)this.amgr.select((ArrayFormula)this.amgr.select((ArrayFormula)this.amgr.select(this.amgr.makeArray("arr", arrType), this.imgr.makeNumber(5L)), this.imgr.makeNumber(3L)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)), BigInteger.valueOf(123L), "arr", true);
    }

    @Test
    public void testGetArrays4() throws SolverException, InterruptedException {
        this.requireArrays();
        BooleanFormula f = this.mgr.parse("(declare-fun x () Int)\n(declare-fun arr () (Array Int Int))\n(assert (and    (= (select arr 5) x)    (= x 123)))");
        this.testModelIterator(f);
        this.testModelGetters(f, (Formula)this.imgr.makeVariable("x"), BigInteger.valueOf(123L), "x");
        this.testModelGetters(f, this.amgr.select(this.amgr.makeArray("arr", FormulaType.getArrayType(FormulaType.IntegerType, FormulaType.IntegerType)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L)), BigInteger.valueOf(123L), "arr", true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetArrays4invalid() throws SolverException, InterruptedException {
        this.requireArrays();
        BooleanFormula f = this.mgr.parse("(declare-fun x () Int)\n(declare-fun arr () (Array Int Int))\n(assert (and    (= (select arr 5) x)    (= x 123)))");
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(f);
            ProverEnvironmentSubject.assertThat(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                Object object = m.evaluate(this.amgr.makeArray("arr", FormulaType.getArrayType(FormulaType.IntegerType, FormulaType.IntegerType)));
            }
        }
    }

    @Test
    public void testGetArrays5() throws SolverException, InterruptedException {
        this.requireArrays();
        BooleanFormula f = this.mgr.parse("(declare-fun x () Int)\n(declare-fun arr () (Array Int Int))\n(assert (and    (= (select (store arr 6 x) 5) x)    (= x 123)))");
        this.testModelIterator(f);
        this.testModelGetters(f, (Formula)this.imgr.makeVariable("x"), BigInteger.valueOf(123L), "x");
        this.testModelGetters(f, this.amgr.select(this.amgr.makeArray("arr", FormulaType.getArrayType(FormulaType.IntegerType, FormulaType.IntegerType)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L)), BigInteger.valueOf(123L), "arr", true);
    }

    private void testModelIterator(BooleanFormula f) throws SolverException, InterruptedException {
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(f);
            ProverEnvironmentSubject.assertThat(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                for (Model.ValueAssignment valueAssignment : m) {
                }
                Truth.assertThat(prover.getModelAssignments()).containsExactlyElementsIn((Iterable)m).inOrder();
            }
        }
    }

    private void testModelGetters(BooleanFormula constraint, Formula variable, Object expectedValue, String varName) throws SolverException, InterruptedException {
        this.testModelGetters(constraint, variable, expectedValue, varName, false);
    }

    private void testModelGetters(BooleanFormula constraint, Formula variable, Object expectedValue, String varName, boolean isArray) throws SolverException, InterruptedException {
        ArrayList<BooleanFormula> modelAssignments = new ArrayList<BooleanFormula>();
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(constraint);
            ProverEnvironmentSubject.assertThat(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                Truth.assertThat((Object)m.evaluate(variable)).isEqualTo(expectedValue);
                for (Model.ValueAssignment va : m) {
                    modelAssignments.add(va.getAssignmentAsFormula());
                }
                List relevantAssignments = prover.getModelAssignments().stream().filter(assignment -> assignment.getName().equals(varName)).collect(Collectors.toList());
                Truth.assertThat(relevantAssignments).isNotEmpty();
                if (isArray) {
                    List arrayAssignments = relevantAssignments.stream().filter(assignment -> expectedValue.equals(assignment.getValue())).collect(Collectors.toList());
                    Truth.assertThat(arrayAssignments).isNotEmpty();
                } else {
                    Truth.assertThat(relevantAssignments).hasSize(1);
                    Model.ValueAssignment assignment2 = (Model.ValueAssignment)Iterables.getOnlyElement(relevantAssignments);
                    Truth.assertThat((Object)assignment2.getValue()).isEqualTo(expectedValue);
                    Truth.assertThat((Object)m.evaluate(assignment2.getKey())).isEqualTo(expectedValue);
                }
            }
        }
        this.assertThatFormula(this.bmgr.and(modelAssignments)).implies(constraint);
    }

    @Test
    public void ufTest() throws SolverException, InterruptedException {
        this.requireQuantifiers();
        this.requireBitvectors();
        TruthJUnit.assume().withMessage("solver does not implement optimisation").that((Comparable)((Object)this.solverToUse())).isEqualTo((Object)SolverContextFactory.Solvers.Z3);
        FormulaType.BitvectorType t32 = FormulaType.getBitvectorTypeWithSize(32);
        FunctionDeclaration<BitvectorFormula> si1 = this.fmgr.declareUF("*signed_int@1", t32, t32);
        FunctionDeclaration<BitvectorFormula> si2 = this.fmgr.declareUF("*signed_int@2", t32, t32);
        BitvectorFormula ctr = this.bvmgr.makeVariable(t32, "*signed_int@1@counter");
        BitvectorFormula adr = this.bvmgr.makeVariable(t32, "__ADDRESS_OF_test");
        BitvectorFormula num0 = this.bvmgr.makeBitvector(32, 0L);
        BitvectorFormula num4 = this.bvmgr.makeBitvector(32, 4L);
        BitvectorFormula num10 = this.bvmgr.makeBitvector(32, 10L);
        BooleanFormula a11 = this.bmgr.implication(this.bmgr.and(this.bvmgr.lessOrEquals(adr, ctr, false), this.bvmgr.lessThan(ctr, this.bvmgr.add(adr, num10), false)), this.bvmgr.equal(this.fmgr.callUF(si2, ctr), num0));
        BooleanFormula a21 = this.bmgr.not(this.bmgr.and(this.bvmgr.lessOrEquals(adr, ctr, false), this.bvmgr.lessThan(ctr, this.bvmgr.add(adr, num10), false)));
        BooleanFormula body = this.bmgr.and(a11, this.bmgr.implication(a21, this.bvmgr.equal(this.fmgr.callUF(si2, ctr), this.fmgr.callUF(si1, ctr))));
        BooleanFormula a1 = this.qmgr.forall(ctr, body);
        BooleanFormula a2 = this.bvmgr.equal(this.fmgr.callUF(si1, this.bvmgr.add(adr, this.bvmgr.multiply(num4, num0))), num0);
        BooleanFormula f = this.bmgr.and(a1, this.bvmgr.lessThan(num0, adr, true), this.bmgr.not(a2));
        this.checkModelIteration(f, true);
        this.checkModelIteration(f, false);
    }

    private void checkModelIteration(BooleanFormula f, boolean useOptProver) throws SolverException, InterruptedException {
        ImmutableList<Model.ValueAssignment> assignments;
        try (OptimizationProverEnvironment prover = useOptProver ? this.context.newOptimizationProverEnvironment(new SolverContext.ProverOptions[0]) : this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(f);
            Truth.assertThat((Boolean)prover.isUnsat()).isFalse();
            try (Model m = prover.getModel();){
                for (Model.ValueAssignment valueAssignment : m) {
                }
                Truth.assertThat(prover.getModelAssignments()).containsExactlyElementsIn((Iterable)m).inOrder();
                assignments = prover.getModelAssignments();
            }
        }
        ArrayList<BooleanFormula> assignmentFormulas = new ArrayList<BooleanFormula>();
        for (Model.ValueAssignment va : assignments) {
            assignmentFormulas.add(va.getAssignmentAsFormula());
            this.assertThatFormula(va.getAssignmentAsFormula()).isEqualTo(this.makeAssignment(va.getKey(), va.getValueAsFormula()));
        }
        this.assertThatFormula(this.bmgr.and(assignmentFormulas)).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(f, this.bmgr.and(assignmentFormulas))).isSatisfiable();
    }

    private BooleanFormula makeAssignment(Formula pFormula1, Formula pFormula2) {
        FormulaType<Formula> pType = this.mgr.getFormulaType(pFormula1);
        assert (this.mgr.getFormulaType(pFormula1).equals(this.mgr.getFormulaType(pFormula2))) : String.format("Trying to equalize two formulas %s and %s of different types %s and %s", pFormula1, pFormula2, pType, this.mgr.getFormulaType(pFormula2));
        if (pType.isBooleanType()) {
            return this.bmgr.equivalence((BooleanFormula)pFormula1, (BooleanFormula)pFormula2);
        }
        if (pType.isIntegerType()) {
            return this.imgr.equal((NumeralFormula.IntegerFormula)pFormula1, (NumeralFormula.IntegerFormula)pFormula2);
        }
        if (pType.isRationalType()) {
            return this.rmgr.equal((NumeralFormula.RationalFormula)pFormula1, (NumeralFormula.RationalFormula)pFormula2);
        }
        if (pType.isBitvectorType()) {
            return this.bvmgr.equal((BitvectorFormula)pFormula1, (BitvectorFormula)pFormula2);
        }
        if (pType.isFloatingPointType()) {
            return this.fpmgr.assignment((FloatingPointFormula)pFormula1, (FloatingPointFormula)pFormula2);
        }
        if (pType.isArrayType()) {
            ArrayFormula f2 = (ArrayFormula)pFormula2;
            return this.amgr.equivalence((ArrayFormula)pFormula1, f2);
        }
        throw new IllegalArgumentException("Cannot make equality of formulas with type " + pType + " in the Solver!");
    }

    @Test
    public void quantifierTestShort() throws SolverException, InterruptedException {
        this.requireQuantifiers();
        NumeralFormula.IntegerFormula ctr = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
        BooleanFormula body = this.imgr.equal(ctr, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L));
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(this.qmgr.exists(ctr, body));
            Truth.assertThat((Boolean)prover.isUnsat()).isFalse();
            try (Model m = prover.getModel();){
                for (Model.ValueAssignment v : m) {
                    Truth.assertThat((Boolean)BigInteger.ZERO.equals(v.getValue())).isTrue();
                }
            }
            prover.pop();
            prover.push(body);
            Truth.assertThat((Boolean)prover.isUnsat()).isFalse();
            m = prover.getModel();
            var6_7 = null;
            try {
                Model.ValueAssignment v = m.iterator().next();
                Truth.assertThat((Boolean)"x".equals(v.getName())).isTrue();
                Truth.assertThat((Boolean)BigInteger.ZERO.equals(v.getValue())).isTrue();
            }
            catch (Throwable throwable) {
                var6_7 = throwable;
                throw throwable;
            }
            finally {
                if (m != null) {
                    ModelTest.$closeResource(var6_7, m);
                }
            }
        }
    }

    @Test
    public void arrayTest1() throws SolverException, InterruptedException {
        this.requireArrays();
        for (String query : Lists.newArrayList((Object[])new String[]{SMALL_ARRAY_QUERY, MEDIUM_ARRAY_QUERY, UGLY_ARRAY_QUERY, UGLY_ARRAY_QUERY_2})) {
            BooleanFormula formula = this.context.getFormulaManager().parse(query);
            this.checkModelIteration(formula, false);
        }
    }

    @Test
    public void arrayTest2() throws SolverException, InterruptedException {
        this.requireArrays();
        this.requireOptimization();
        this.requireFloats();
        this.requireBitvectors();
        for (String query : Lists.newArrayList((Object[])new String[]{BIG_ARRAY_QUERY, SMALL_BV_FLOAT_QUERY, SMALL_BV_FLOAT_QUERY2})) {
            BooleanFormula formula = this.context.getFormulaManager().parse(query);
            this.checkModelIteration(formula, true);
            this.checkModelIteration(formula, false);
        }
    }
}

