/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.base.Preconditions;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.SimpleSubjectBuilder;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class BooleanFormulaSubject
extends Subject<BooleanFormulaSubject, BooleanFormula> {
    private final SolverContext context;

    private BooleanFormulaSubject(FailureMetadata pMetadata, BooleanFormula pFormula, SolverContext pMgr) {
        super(pMetadata, (Object)pFormula);
        this.context = (SolverContext)Preconditions.checkNotNull((Object)pMgr);
    }

    public static Subject.Factory<BooleanFormulaSubject, BooleanFormula> booleanFormulasOf(SolverContext context) {
        return (metadata, formula) -> new BooleanFormulaSubject(metadata, (BooleanFormula)formula, context);
    }

    public static SimpleSubjectBuilder<BooleanFormulaSubject, BooleanFormula> assertUsing(SolverContext context) {
        return Truth.assert_().about(BooleanFormulaSubject.booleanFormulasOf(context));
    }

    private void checkIsUnsat(BooleanFormula subject, String verb, Object expected) throws SolverException, InterruptedException {
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(subject);
            if (prover.isUnsat()) {
                return;
            }
            try (Model model = prover.getModel();){
                this.failWithBadResults(verb, expected, "has counterexample", model);
            }
        }
    }

    public void isUnsatisfiable() throws SolverException, InterruptedException {
        if (this.context.getFormulaManager().getBooleanFormulaManager().isTrue((BooleanFormula)this.actual())) {
            this.failWithBadResults("is", "unsatisfiable", "is", "trivially satisfiable");
        }
        this.checkIsUnsat((BooleanFormula)this.actual(), "is", "unsatisfiable");
    }

    public void isSatisfiable() throws SolverException, InterruptedException {
        if (this.context.getFormulaManager().getBooleanFormulaManager().isFalse((BooleanFormula)this.actual())) {
            this.failWithBadResults("is", "satisfiable", "is", "trivially unsatisfiable");
        }
        try (ProverEnvironment prover = this.context.newProverEnvironment(new SolverContext.ProverOptions[0]);){
            prover.push((BooleanFormula)this.actual());
            if (!prover.isUnsat()) {
                return;
            }
        }
        try {
            prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
            var2_3 = null;
            try {
                List<BooleanFormula> unsatCore = prover.getUnsatCore();
                if (unsatCore.isEmpty() || unsatCore.size() == 1 && ((BooleanFormula)this.actual()).equals(unsatCore.get(0))) {
                    this.fail("is", "satisfiable");
                } else {
                    this.failWithBadResults("is", "satisfiable", "has unsat core", unsatCore);
                }
            }
            catch (Throwable throwable) {
                var2_3 = throwable;
                throw throwable;
            }
            finally {
                if (prover != null) {
                    BooleanFormulaSubject.$closeResource(var2_3, prover);
                }
            }
        }
        catch (UnsupportedOperationException ex) {
            this.fail("is", "satisfiable");
        }
    }

    public void isTautological() throws SolverException, InterruptedException {
        this.isSatisfiable();
        this.checkIsUnsat(this.context.getFormulaManager().getBooleanFormulaManager().not((BooleanFormula)this.actual()), "is", "tautological");
    }

    public void isEquivalentTo(BooleanFormula expected) throws SolverException, InterruptedException {
        if (((BooleanFormula)this.actual()).equals(expected)) {
            return;
        }
        BooleanFormula f = this.context.getFormulaManager().getBooleanFormulaManager().xor((BooleanFormula)this.actual(), expected);
        this.checkIsUnsat(f, "is equivalent to", expected);
    }

    public void isEquisatisfiableTo(BooleanFormula other) throws SolverException, InterruptedException {
        BooleanFormulaManager bfmgr = this.context.getFormulaManager().getBooleanFormulaManager();
        this.checkIsUnsat(bfmgr.and((BooleanFormula)this.actual(), bfmgr.not(other)), " is not equisatisfiable with ", other);
    }

    public void implies(BooleanFormula expected) throws SolverException, InterruptedException {
        if (((BooleanFormula)this.actual()).equals(expected)) {
            return;
        }
        BooleanFormulaManager bmgr = this.context.getFormulaManager().getBooleanFormulaManager();
        BooleanFormula implication = bmgr.or(bmgr.not((BooleanFormula)this.actual()), expected);
        this.checkIsUnsat(bmgr.not(implication), "implies", expected);
    }
}

