/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.z3;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.microsoft.z3.Native;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_decl_kind;
import com.microsoft.z3.enumerations.Z3_lbool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaCreator;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3Model;
import org.sosy_lab.java_smt.solvers.z3.Z3SolverException;

abstract class Z3SolverBasedProver<T>
implements BasicProverEnvironment<T> {
    protected final Z3FormulaCreator creator;
    protected final long z3context;
    private final FormulaManager mgr;
    protected boolean closed = false;
    protected final long z3solver;
    private int level = 0;
    private static final String UNSAT_CORE_TEMP_VARNAME = "Z3_UNSAT_CORE_%d";
    private final UniqueIdGenerator trackId = new UniqueIdGenerator();
    @Nullable
    private final Map<String, BooleanFormula> storedConstraints;

    Z3SolverBasedProver(Z3FormulaCreator pCreator, long z3params, FormulaManager pMgr, boolean enableUnsatCores) {
        this.creator = pCreator;
        this.z3context = (Long)this.creator.getEnv();
        this.z3solver = Native.mkSolver((long)this.z3context);
        this.mgr = pMgr;
        Native.solverIncRef((long)this.z3context, (long)this.z3solver);
        Native.solverSetParams((long)this.z3context, (long)this.z3solver, (long)z3params);
        this.storedConstraints = enableUnsatCores ? new HashMap() : null;
    }

    @Override
    public boolean isUnsat() throws Z3SolverException, InterruptedException {
        int result;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        try {
            result = Native.solverCheck((long)this.z3context, (long)this.z3solver);
        }
        catch (Z3Exception e) {
            throw this.creator.handleZ3Exception(e);
        }
        this.undefinedStatusToException(result);
        return result == Z3_lbool.Z3_L_FALSE.toInt();
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> assumptions) throws Z3SolverException, InterruptedException {
        int result;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        try {
            result = Native.solverCheckAssumptions((long)this.z3context, (long)this.z3solver, (int)assumptions.size(), (long[])assumptions.stream().mapToLong(this.creator::extractInfo).toArray());
        }
        catch (Z3Exception e) {
            throw this.creator.handleZ3Exception(e);
        }
        this.undefinedStatusToException(result);
        return result == Z3_lbool.Z3_L_FALSE.toInt();
    }

    protected final void undefinedStatusToException(int solverStatus) throws Z3SolverException, InterruptedException {
        if (solverStatus == Z3_lbool.Z3_L_UNDEF.toInt()) {
            this.creator.shutdownNotifier.shutdownIfNecessary();
            throw new Z3SolverException("Solver returned 'unknown' status, reason: " + Native.solverGetReasonUnknown((long)this.z3context, (long)this.z3solver));
        }
    }

    @Override
    public Z3Model getModel() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return Z3Model.create(this.z3context, this.getZ3Model(), this.creator);
    }

    @Override
    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        try (Z3Model model = this.getModel();){
            ImmutableList<Model.ValueAssignment> immutableList = model.modelToList();
            return immutableList;
        }
    }

    protected long getZ3Model() {
        return Native.solverGetModel((long)this.z3context, (long)this.z3solver);
    }

    @CanIgnoreReturnValue
    protected long addConstraint0(BooleanFormula f) throws InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long e = this.creator.extractInfo(f);
        Native.incRef((long)this.z3context, (long)e);
        try {
            if (this.storedConstraints != null) {
                String varName = String.format(UNSAT_CORE_TEMP_VARNAME, this.trackId.getFreshId());
                BooleanFormula t = this.mgr.getBooleanFormulaManager().makeVariable(varName);
                Native.solverAssertAndTrack((long)this.z3context, (long)this.z3solver, (long)e, (long)this.creator.extractInfo(t));
                this.storedConstraints.put(varName, f);
                Native.decRef((long)this.z3context, (long)e);
            } else {
                this.assertContraint(e);
            }
        }
        catch (Z3Exception exception) {
            throw this.creator.handleZ3Exception(exception);
        }
        Native.decRef((long)this.z3context, (long)e);
        return e;
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ++this.level;
        Native.solverPush((long)this.z3context, (long)this.z3solver);
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((Native.solverGetNumScopes((long)this.z3context, (long)this.z3solver) >= 1 ? 1 : 0) != 0);
        --this.level;
        Native.solverPop((long)this.z3context, (long)this.z3solver, (int)1);
    }

    protected int getLevel() {
        return this.level;
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.storedConstraints == null) {
            throw new UnsupportedOperationException("Option to generate the UNSAT core wasn't enabled when creating the prover environment.");
        }
        ArrayList<BooleanFormula> constraints = new ArrayList<BooleanFormula>();
        long unsatCore = Native.solverGetUnsatCore((long)this.z3context, (long)this.z3solver);
        Native.astVectorIncRef((long)this.z3context, (long)unsatCore);
        for (int i = 0; i < Native.astVectorSize((long)this.z3context, (long)unsatCore); ++i) {
            long ast = Native.astVectorGet((long)this.z3context, (long)unsatCore, (int)i);
            Native.incRef((long)this.z3context, (long)ast);
            String varName = Native.astToString((long)this.z3context, (long)ast);
            Native.decRef((long)this.z3context, (long)ast);
            constraints.add(this.storedConstraints.get(varName));
        }
        Native.astVectorDecRef((long)this.z3context, (long)unsatCore);
        return constraints;
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        if (!this.isUnsatWithAssumptions(assumptions)) {
            return Optional.empty();
        }
        ArrayList<BooleanFormula> core = new ArrayList<BooleanFormula>();
        long unsatCore = Native.solverGetUnsatCore((long)this.z3context, (long)this.z3solver);
        Native.astVectorIncRef((long)this.z3context, (long)unsatCore);
        for (int i = 0; i < Native.astVectorSize((long)this.z3context, (long)unsatCore); ++i) {
            long ast = Native.astVectorGet((long)this.z3context, (long)unsatCore, (int)i);
            core.add(this.creator.encapsulateBoolean(ast));
        }
        Native.astVectorDecRef((long)this.z3context, (long)unsatCore);
        return Optional.of(core);
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((Native.solverGetNumScopes((long)this.z3context, (long)this.z3solver) >= 0 ? 1 : 0) != 0, (Object)"a negative number of scopes is not allowed");
        while (this.level > 0) {
            this.pop();
        }
        Native.solverDecRef((long)this.z3context, (long)this.z3solver);
        this.closed = true;
    }

    public String toString() {
        if (this.closed) {
            return "Closed Z3Solver";
        }
        return Native.solverToString((long)this.z3context, (long)this.z3solver);
    }

    @Override
    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long[] importantFormulas = new long[important.size()];
        int i = 0;
        for (BooleanFormula impF : important) {
            importantFormulas[i++] = Z3FormulaManager.getZ3Expr(impF);
        }
        try {
            this.push();
        }
        catch (Z3Exception e) {
            throw this.creator.handleZ3Exception(e);
        }
        while (!this.isUnsat()) {
            ArrayList<Long> valuesOfModel = new ArrayList<Long>(importantFormulas.length);
            long z3model = this.getZ3Model();
            for (int j = 0; j < importantFormulas.length; ++j) {
                long funcDecl = Native.getAppDecl((long)this.z3context, (long)importantFormulas[j]);
                long valueOfExpr = Native.modelGetConstInterp((long)this.z3context, (long)z3model, (long)funcDecl);
                if (valueOfExpr == 0L) continue;
                if (Z3FormulaCreator.isOP(this.z3context, valueOfExpr, Z3_decl_kind.Z3_OP_FALSE.toInt())) {
                    long negated = Native.mkNot((long)this.z3context, (long)importantFormulas[j]);
                    Native.incRef((long)this.z3context, (long)negated);
                    valuesOfModel.add(negated);
                    continue;
                }
                valuesOfModel.add(importantFormulas[j]);
            }
            callback.apply(Lists.transform(valuesOfModel, f -> this.creator.encapsulateBoolean((Long)f)));
            try {
                long negatedModel = Native.mkNot((long)this.z3context, (long)Native.mkAnd((long)this.z3context, (int)valuesOfModel.size(), (long[])Longs.toArray(valuesOfModel)));
                Native.incRef((long)this.z3context, (long)negatedModel);
                this.assertContraint(negatedModel);
            }
            catch (Z3Exception e) {
                throw this.creator.handleZ3Exception(e);
            }
        }
        this.pop();
        return callback.getResult();
    }

    protected void assertContraint(long negatedModel) {
        Native.solverAssert((long)this.z3context, (long)this.z3solver, (long)negatedModel);
    }
}

