/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import com.google.common.base.Preconditions;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolBasicProver;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaManager;

class SmtInterpolTheoremProver
extends SmtInterpolBasicProver<Void, Term>
implements ProverEnvironment {
    private final boolean generateUnsatCores;

    SmtInterpolTheoremProver(SmtInterpolFormulaManager pMgr, Set<SolverContext.ProverOptions> options) {
        super(pMgr);
        this.generateUnsatCores = options.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
    }

    @Override
    @Nullable
    public Void addConstraint(BooleanFormula constraint) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Term t = (Term)this.mgr.extractInfo(constraint);
        if (this.generateUnsatCores) {
            String termName = SmtInterpolTheoremProver.generateTermName();
            Term annotated = this.env.annotate(t, new Annotation(":named", (Object)termName));
            this.annotatedTerms.put(termName, t);
            this.env.assertTerm(annotated);
        } else {
            this.env.assertTerm(t);
        }
        ((List)this.assertedFormulas.peek()).add(t);
        return null;
    }

    @Override
    protected Collection<Term> getAssertedTerms() {
        ArrayList<Term> result = new ArrayList<Term>();
        this.assertedFormulas.forEach(result::addAll);
        return result;
    }
}

