/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.basicimpl.AbstractSolverContext;
import org.sosy_lab.java_smt.basicimpl.reusableStack.ReusableStackInterpolatingProver;
import org.sosy_lab.java_smt.basicimpl.reusableStack.ReusableStackTheoremProver;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolEnvironment;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaCreator;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolIntegerFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolRationalFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolTheoremProver;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolUFManager;

public class SmtInterpolSolverContext
extends AbstractSolverContext {
    private final SmtInterpolEnvironment environment;
    private final SmtInterpolFormulaManager manager;

    private SmtInterpolSolverContext(SmtInterpolFormulaCreator pFormulaCreator, SmtInterpolFormulaManager pManager) {
        super(pManager);
        this.environment = (SmtInterpolEnvironment)pFormulaCreator.getEnv();
        this.manager = pManager;
    }

    public static SmtInterpolSolverContext create(Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier, @Nullable PathCounterTemplate smtLogfile, long randomSeed) throws InvalidConfigurationException {
        SmtInterpolEnvironment env = new SmtInterpolEnvironment(config, logger, pShutdownNotifier, smtLogfile, randomSeed);
        SmtInterpolFormulaCreator creator = new SmtInterpolFormulaCreator(env);
        SmtInterpolUFManager functionTheory = new SmtInterpolUFManager(creator);
        SmtInterpolBooleanFormulaManager booleanTheory = new SmtInterpolBooleanFormulaManager(creator, env.getTheory());
        SmtInterpolIntegerFormulaManager integerTheory = new SmtInterpolIntegerFormulaManager(creator);
        SmtInterpolRationalFormulaManager rationalTheory = new SmtInterpolRationalFormulaManager(creator);
        SmtInterpolArrayFormulaManager arrayTheory = new SmtInterpolArrayFormulaManager(creator);
        SmtInterpolFormulaManager manager = new SmtInterpolFormulaManager(creator, functionTheory, booleanTheory, integerTheory, rationalTheory, arrayTheory);
        return new SmtInterpolSolverContext(creator, manager);
    }

    @Override
    protected ProverEnvironment newProverEnvironment0(Set<SolverContext.ProverOptions> options) {
        return new ReusableStackTheoremProver(new SmtInterpolTheoremProver(this.manager, options));
    }

    @Override
    protected InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation0(Set<SolverContext.ProverOptions> options) {
        return new ReusableStackInterpolatingProver<String>(this.environment.getInterpolator(this.manager));
    }

    @Override
    public OptimizationProverEnvironment newOptimizationProverEnvironment0(Set<SolverContext.ProverOptions> options) {
        throw new UnsupportedOperationException("SMTInterpol does not support optimization");
    }

    @Override
    public String getVersion() {
        return this.environment.getVersion();
    }

    @Override
    public SolverContextFactory.Solvers getSolverName() {
        return SolverContextFactory.Solvers.SMTINTERPOL;
    }

    @Override
    public void close() {
    }

    @Override
    protected boolean supportsAssumptionSolving() {
        return false;
    }
}

