/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.basicimpl.AbstractModel;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolEnvironment;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaCreator;

class SmtInterpolModel
extends AbstractModel.CachingAbstractModel<Term, Sort, SmtInterpolEnvironment> {
    private final Model model;
    private final ImmutableList<Term> assertedTerms;
    private final SmtInterpolFormulaCreator formulaCreator;

    SmtInterpolModel(Model pModel, FormulaCreator<Term, Sort, SmtInterpolEnvironment, ?> pCreator, Collection<Term> assertedTerms) {
        super(pCreator);
        this.formulaCreator = (SmtInterpolFormulaCreator)pCreator;
        this.model = pModel;
        this.assertedTerms = ImmutableList.copyOf(assertedTerms);
    }

    @Override
    @Nullable
    public Object evaluateImpl(Term f) {
        Term out = this.model.evaluate(f);
        return this.getValue(out);
    }

    @Override
    protected ImmutableList<Model.ValueAssignment> modelToList() {
        ImmutableSet.Builder assignments = ImmutableSet.builder();
        for (Term t : this.assertedTerms) {
            this.creator.extractVariablesAndUFs(t, true, (name, f) -> {
                if (f.getSort().isArraySort()) {
                    assignments.addAll(this.getArrayAssignment((String)name, (Term)f, (Term)f, Collections.emptyList()));
                } else {
                    assignments.add((Object)this.getAssignment((String)name, (ApplicationTerm)f));
                }
            });
        }
        return assignments.build().asList();
    }

    private Collection<Model.ValueAssignment> getArrayAssignment(String symbol, Term key, Term array, List<Object> upperIndices) {
        assert (array.getSort().isArraySort());
        ArrayList<Model.ValueAssignment> assignments = new ArrayList<Model.ValueAssignment>();
        Term evaluation = this.model.evaluate(array);
        while (evaluation instanceof ApplicationTerm) {
            ApplicationTerm arrayEval = (ApplicationTerm)evaluation;
            FunctionSymbol funcDecl = arrayEval.getFunction();
            Term[] params = arrayEval.getParameters();
            if (!funcDecl.isIntern() || !"store".equals(funcDecl.getName())) break;
            Term index = params[1];
            Term content = params[2];
            ArrayList innerIndices = Lists.newArrayList(upperIndices);
            innerIndices.add(this.evaluateImpl(index));
            Term select = ((SmtInterpolEnvironment)this.creator.getEnv()).term("select", key, index);
            if (content.getSort().isArraySort()) {
                assignments.addAll(this.getArrayAssignment(symbol, select, content, innerIndices));
            } else {
                assignments.add(new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(select), this.creator.encapsulateWithTypeOf(this.model.evaluate(content)), this.creator.encapsulateBoolean(((SmtInterpolEnvironment)this.creator.getEnv()).term("=", select, content)), symbol, this.evaluateImpl(content), innerIndices));
            }
            evaluation = params[0];
        }
        return assignments;
    }

    private Model.ValueAssignment getAssignment(String key, ApplicationTerm term) {
        ArrayList<Object> argumentInterpretation = new ArrayList<Object>();
        for (Term param : term.getParameters()) {
            argumentInterpretation.add(this.evaluateImpl(param));
        }
        Term value = this.model.evaluate((Term)term);
        return new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(term), this.creator.encapsulateWithTypeOf(value), this.creator.encapsulateBoolean(((SmtInterpolEnvironment)this.creator.getEnv()).term("=", new Term[]{term, value})), key, this.evaluateImpl((Term)term), argumentInterpretation);
    }

    @Override
    public String toString() {
        return this.model.toString();
    }

    private Object getValue(Term value) {
        FormulaType<?> type = this.creator.getFormulaType(value);
        if (type.isBooleanType()) {
            return value.getTheory().mTrue == value;
        }
        if (value instanceof ConstantTerm && ((ConstantTerm)value).getValue() instanceof de.uni_freiburg.informatik.ultimate.logic.Rational) {
            de.uni_freiburg.informatik.ultimate.logic.Rational rationalValue = (de.uni_freiburg.informatik.ultimate.logic.Rational)((ConstantTerm)value).getValue();
            Rational out = Rational.of((BigInteger)rationalValue.numerator(), (BigInteger)rationalValue.denominator());
            if (this.formulaCreator.getFormulaTypeOfSort(value.getSort()).isIntegerType()) {
                assert (out.isIntegral());
                return out.getNum();
            }
            return out;
        }
        throw new IllegalArgumentException("Unexpected value: " + value);
    }

    @Override
    public void close() {
    }
}

