/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolBasicProver;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaManager;

class SmtInterpolInterpolatingProver
extends SmtInterpolBasicProver<String, String>
implements InterpolatingProverEnvironment<String> {
    SmtInterpolInterpolatingProver(SmtInterpolFormulaManager pMgr) {
        super(pMgr);
    }

    @Override
    public void pop() {
        for (String removed : (List)this.assertedFormulas.peek()) {
            this.annotatedTerms.remove(removed);
        }
        super.pop();
    }

    @Override
    public String addConstraint(BooleanFormula f) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        String termName = SmtInterpolInterpolatingProver.generateTermName();
        Term t = (Term)this.mgr.extractInfo(f);
        Term annotatedTerm = this.env.annotate(t, new Annotation(":named", (Object)termName));
        this.env.assertTerm(annotatedTerm);
        ((List)this.assertedFormulas.peek()).add(termName);
        this.annotatedTerms.put(termName, t);
        return termName;
    }

    @Override
    public BooleanFormula getInterpolant(List<String> pTermNamesOfA) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        if (pTermNamesOfA.isEmpty()) {
            return ((AbstractBooleanFormulaManager)this.mgr.getBooleanFormulaManager()).makeBoolean(true);
        }
        if (pTermNamesOfA.containsAll(this.annotatedTerms.keySet())) {
            return ((AbstractBooleanFormulaManager)this.mgr.getBooleanFormulaManager()).makeBoolean(false);
        }
        ImmutableSet termNamesOfA = ImmutableSet.copyOf(pTermNamesOfA);
        Set termNamesOfB = (Set)this.annotatedTerms.keySet().stream().filter(arg_0 -> SmtInterpolInterpolatingProver.lambda$getInterpolant$0((Set)termNamesOfA, arg_0)).collect(ImmutableSet.toImmutableSet());
        Term termA = this.buildConjunctionOfNamedTerms((Collection<String>)termNamesOfA);
        Term termB = this.buildConjunctionOfNamedTerms(termNamesOfB);
        return this.getInterpolant(termA, termB);
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<? extends Collection<String>> partitionedTermNames) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Term[] formulas = new Term[partitionedTermNames.size()];
        for (int i = 0; i < formulas.length; ++i) {
            formulas[i] = this.buildConjunctionOfNamedTerms(partitionedTermNames.get(i));
        }
        Term[] itps = this.env.getInterpolants(formulas);
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        for (Term itp : itps) {
            result.add(this.mgr.encapsulateBooleanFormula(itp));
        }
        return result;
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<? extends Collection<String>> partitionedTermNames, int[] startOfSubTree) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        assert (InterpolatingProverEnvironment.checkTreeStructure(partitionedTermNames.size(), startOfSubTree));
        Term[] formulas = new Term[partitionedTermNames.size()];
        for (int i = 0; i < formulas.length; ++i) {
            formulas[i] = this.buildConjunctionOfNamedTerms(partitionedTermNames.get(i));
        }
        Term[] itps = this.env.getTreeInterpolants(formulas, startOfSubTree);
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        for (Term itp : itps) {
            result.add(this.mgr.encapsulateBooleanFormula(itp));
        }
        return result;
    }

    protected BooleanFormula getInterpolant(Term termA, Term termB) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Term[] itp = this.env.getInterpolants(new Term[]{termA, termB});
        assert (itp.length == 1);
        return this.mgr.encapsulateBooleanFormula(itp[0]);
    }

    private Term buildConjunctionOfNamedTerms(Collection<String> termNames) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Preconditions.checkArgument((!termNames.isEmpty() ? 1 : 0) != 0);
        if (termNames.size() == 1) {
            return this.env.term((String)Iterables.getOnlyElement(termNames), new Term[0]);
        }
        return this.env.term("and", (Term[])termNames.stream().map(x$0 -> this.env.term((String)x$0, new Term[0])).toArray(Term[]::new));
    }

    @Override
    protected Collection<Term> getAssertedTerms() {
        return this.annotatedTerms.values();
    }

    private static /* synthetic */ boolean lambda$getInterpolant$0(Set termNamesOfA, String n) {
        return !termNamesOfA.contains(n);
    }
}

