/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.princess;

import ap.SimpleAPI;
import ap.basetypes.IdealInt;
import ap.parser.IAtom;
import ap.parser.IBinFormula;
import ap.parser.IBinJunctor;
import ap.parser.IBoolLit;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFunApp;
import ap.parser.IIntLit;
import ap.parser.ITerm;
import ap.terfor.ConstantTerm;
import ap.types.Sort;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.basicimpl.AbstractModel;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.solvers.princess.PrincessEnvironment;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.Map;
import scala.collection.Seq;

class PrincessModel
extends AbstractModel.CachingAbstractModel<IExpression, Sort, PrincessEnvironment> {
    private final SimpleAPI.PartialModel model;

    PrincessModel(SimpleAPI.PartialModel partialModel, FormulaCreator<IExpression, Sort, PrincessEnvironment, ?> creator) {
        super(creator);
        this.model = partialModel;
    }

    @Override
    @Nullable
    public Object evaluateImpl(IExpression f) {
        Option out = this.model.evalExpression(f);
        if (out.isEmpty()) {
            return null;
        }
        SimpleAPI.ModelValue value = (SimpleAPI.ModelValue)out.get();
        return this.getValue(value);
    }

    @Override
    protected ImmutableList<Model.ValueAssignment> modelToList() {
        Map interpretation = this.model.interpretation();
        java.util.Map<IdealInt, ITerm> arrays = this.getArrayAddresses((Map<SimpleAPI.ModelLocation, SimpleAPI.ModelValue>)interpretation);
        ImmutableSet.Builder assignments = ImmutableSet.builder();
        for (Tuple2 entry : JavaConversions.asJavaIterable((Iterable)interpretation)) {
            Model.ValueAssignment assignment = this.getAssignment((SimpleAPI.ModelLocation)entry._1, (SimpleAPI.ModelValue)entry._2, arrays);
            if (assignment == null) continue;
            assignments.add((Object)assignment);
        }
        return assignments.build().asList();
    }

    private java.util.Map<IdealInt, ITerm> getArrayAddresses(Map<SimpleAPI.ModelLocation, SimpleAPI.ModelValue> interpretation) {
        HashMap<IdealInt, ITerm> arrays = new HashMap<IdealInt, ITerm>();
        for (Tuple2 entry : JavaConversions.asJavaIterable(interpretation)) {
            if (!(entry._1 instanceof SimpleAPI.ConstantLoc)) continue;
            ITerm maybeArray = IExpression.i((ConstantTerm)((SimpleAPI.ConstantLoc)entry._1).c());
            if (!((PrincessEnvironment)this.creator.getEnv()).hasArrayType((IExpression)maybeArray) || !(entry._2 instanceof SimpleAPI.IntValue)) continue;
            arrays.put(((SimpleAPI.IntValue)entry._2).v(), maybeArray);
        }
        return arrays;
    }

    @Nullable
    private Model.ValueAssignment getAssignment(SimpleAPI.ModelLocation key, SimpleAPI.ModelValue value, java.util.Map<IdealInt, ITerm> arrays) {
        IBinFormula fAssignment;
        String name;
        IAtom fKey;
        Object directValue = this.getValue(value);
        IExpression fValue = this.getValueFormula(value);
        Collection<Object> argumentInterpretations = Collections.emptyList();
        if (key instanceof SimpleAPI.PredicateLoc) {
            IAtom predicate;
            fKey = predicate = new IAtom(((SimpleAPI.PredicateLoc)key).p(), (Seq)JavaConversions.asScalaBuffer(Collections.emptyList()));
            name = key.toString();
            fAssignment = new IBinFormula(IBinJunctor.Eqv(), (IFormula)predicate, (IFormula)fValue);
        } else if (key instanceof SimpleAPI.ConstantLoc) {
            ITerm term = IExpression.i((ConstantTerm)((SimpleAPI.ConstantLoc)key).c());
            if (((PrincessEnvironment)this.creator.getEnv()).hasArrayType((IExpression)term)) {
                return null;
            }
            fKey = term;
            name = key.toString();
            fAssignment = term.$eq$eq$eq((ITerm)fValue);
        } else if (key instanceof SimpleAPI.IntFunctionLoc) {
            SimpleAPI.IntFunctionLoc cKey = (SimpleAPI.IntFunctionLoc)key;
            if ("select/2".equals(cKey.f().toString())) {
                IdealInt arrayId = (IdealInt)cKey.args().apply(0);
                IdealInt arrayIndex = (IdealInt)cKey.args().apply(1);
                ITerm arrayF = arrays.get(arrayId);
                if (arrayF == null) {
                    return null;
                }
                fKey = ((PrincessEnvironment)this.creator.getEnv()).makeSelect(arrayF, IExpression.i((IdealInt)arrayIndex));
                name = arrayF.toString();
                argumentInterpretations = Collections.singleton(arrayIndex.bigIntValue());
            } else if ("store/3".equals(cKey.f().toString())) {
                IdealInt arrayId = ((SimpleAPI.IntValue)value).v();
                IdealInt arrayIndex = (IdealInt)cKey.args().apply(1);
                IdealInt arrayContent = (IdealInt)cKey.args().apply(2);
                ITerm arrayF = arrays.get(arrayId);
                if (arrayF == null) {
                    return null;
                }
                fKey = ((PrincessEnvironment)this.creator.getEnv()).makeSelect(arrayF, IExpression.i((IdealInt)arrayIndex));
                fValue = new IIntLit(arrayContent);
                name = arrayF.toString();
                directValue = arrayContent.bigIntValue();
                argumentInterpretations = Collections.singleton(arrayIndex.bigIntValue());
            } else {
                argumentInterpretations = new ArrayList();
                ArrayList<ITerm> argTerms = new ArrayList<ITerm>();
                for (IdealInt arg : JavaConversions.seqAsJavaList((Seq)cKey.args())) {
                    argumentInterpretations.add(arg.bigIntValue());
                    argTerms.add(IExpression.i((IdealInt)arg));
                }
                fKey = new IFunApp(cKey.f(), (Seq)JavaConversions.asScalaBuffer(argTerms));
                name = cKey.f().name();
            }
            fAssignment = ((ITerm)fKey).$eq$eq$eq((ITerm)fValue);
        } else {
            throw new AssertionError((Object)String.format("unknown type of key: %s -> %s (%s)", key, value, key.getClass()));
        }
        return new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(fKey), this.creator.encapsulateWithTypeOf(fValue), this.creator.encapsulateBoolean(fAssignment), name, directValue, argumentInterpretations);
    }

    @Override
    public String toString() {
        return this.model.toString();
    }

    private Object getValue(SimpleAPI.ModelValue value) {
        if (value instanceof SimpleAPI.BoolValue) {
            return ((SimpleAPI.BoolValue)value).v();
        }
        if (value instanceof SimpleAPI.IntValue) {
            return ((SimpleAPI.IntValue)value).v().bigIntValue();
        }
        throw new IllegalArgumentException("unhandled model value " + value + " of type " + value.getClass());
    }

    private IExpression getValueFormula(SimpleAPI.ModelValue value) {
        if (value instanceof SimpleAPI.BoolValue) {
            return new IBoolLit(((SimpleAPI.BoolValue)value).v());
        }
        if (value instanceof SimpleAPI.IntValue) {
            return new IIntLit(((SimpleAPI.IntValue)value).v());
        }
        throw new IllegalArgumentException("unhandled model value " + value + " of type " + value.getClass());
    }

    @Override
    public void close() {
    }
}

