/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.princess;

import ap.SimpleAPI;
import ap.parser.IBinFormula;
import ap.parser.IBinJunctor;
import ap.parser.IBoolLit;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFunction;
import ap.parser.INot;
import ap.parser.ITerm;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.solvers.princess.PrincessEnvironment;
import org.sosy_lab.java_smt.solvers.princess.PrincessFormulaCreator;
import org.sosy_lab.java_smt.solvers.princess.PrincessFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessModel;
import scala.Enumeration;
import scala.Option;
import scala.collection.JavaConversions;
import scala.collection.immutable.Set;

abstract class PrincessAbstractProver<E, AF>
implements BasicProverEnvironment<E> {
    protected final SimpleAPI api;
    protected final PrincessFormulaManager mgr;
    protected final Deque<List<AF>> assertedFormulas = new ArrayDeque<List<AF>>();
    private final Deque<Level> trackingStack = new ArrayDeque<Level>();
    protected final ShutdownNotifier shutdownNotifier;
    protected final boolean computeUnsatCores;
    private final PrincessFormulaCreator creator;
    protected boolean closed = false;
    protected boolean wasLastSatCheckSat = false;

    protected PrincessAbstractProver(PrincessFormulaManager pMgr, PrincessFormulaCreator creator, SimpleAPI pApi, ShutdownNotifier pShutdownNotifier, boolean pComputeUnsatCores) {
        this.mgr = pMgr;
        this.creator = creator;
        this.api = (SimpleAPI)Preconditions.checkNotNull((Object)pApi);
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
        this.computeUnsatCores = pComputeUnsatCores;
    }

    @Override
    public boolean isUnsat() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.wasLastSatCheckSat = false;
        Enumeration.Value result = this.api.checkSat(true);
        if (result.equals((Object)SimpleAPI.ProverStatus$.MODULE$.Sat())) {
            this.wasLastSatCheckSat = true;
            return false;
        }
        if (result.equals((Object)SimpleAPI.ProverStatus$.MODULE$.Unsat())) {
            return true;
        }
        if (result.equals((Object)SimpleAPI.ProverStatus$.MODULE$.OutOfMemory())) {
            throw new SolverException("Princess ran out of stack or heap memory, try increasing their sizes.");
        }
        throw new SolverException("Princess' checkSat call returned " + result);
    }

    protected void addConstraint0(IFormula t) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.wasLastSatCheckSat = false;
        this.api.addAssertion(this.api.abbrevSharedExpressions(t, ((PrincessEnvironment)this.creator.getEnv()).getMinAtomsForAbbreviation()));
    }

    protected int addAssertedFormula(AF f) {
        this.assertedFormulas.peek().add(f);
        int id = this.trackingStack.peek().constraintNum++;
        return id;
    }

    @Override
    public final void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.wasLastSatCheckSat = false;
        this.assertedFormulas.push(new ArrayList());
        this.api.push();
        int oldConstraintNum = this.trackingStack.isEmpty() ? 0 : this.trackingStack.peek().constraintNum;
        this.trackingStack.push(new Level(oldConstraintNum));
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.wasLastSatCheckSat = false;
        this.assertedFormulas.pop();
        this.api.pop();
        Level level = this.trackingStack.pop();
        this.api.addBooleanVariables(JavaConversions.iterableAsScalaIterable(level.booleanSymbols));
        this.api.addConstants(JavaConversions.iterableAsScalaIterable(level.intSymbols));
        level.functionSymbols.forEach(arg_0 -> ((SimpleAPI)this.api).addFunction(arg_0));
        if (!this.trackingStack.isEmpty()) {
            this.trackingStack.peek().mergeWithHigher(level);
        }
    }

    @Override
    public PrincessModel getModel() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.wasLastSatCheckSat, (Object)"model is only available for SAT environments");
        return new PrincessModel(this.api.partialModel(), this.creator);
    }

    @Override
    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        try (PrincessModel model = this.getModel();){
            ImmutableList<Model.ValueAssignment> immutableList = model.modelToList();
            return immutableList;
        }
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException("Solving with assumptions is not supported.");
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((!this.closed && this.computeUnsatCores ? 1 : 0) != 0);
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        Set core = this.api.getUnsatCore();
        int cnt = 0;
        for (IExpression formula : this.getAssertedFormulas()) {
            if (core.contains((Object)cnt)) {
                result.add(this.mgr.encapsulateBooleanFormula(formula));
            }
            ++cnt;
        }
        return result;
    }

    protected abstract Iterable<IExpression> getAssertedFormulas();

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> assumptions) {
        throw new UnsupportedOperationException("UNSAT cores not supported by Princess");
    }

    @Override
    public void close() {
        Preconditions.checkNotNull((Object)this.api);
        Preconditions.checkNotNull((Object)this.mgr);
        if (!this.closed) {
            if (this.shutdownNotifier.shouldShutdown()) {
                this.api.shutDown();
            } else {
                for (int i = 0; i < this.trackingStack.size(); ++i) {
                    this.pop();
                }
            }
            ((PrincessEnvironment)this.creator.getEnv()).unregisterStack(this);
        }
        this.closed = true;
    }

    @Override
    public <T> T allSat(BasicProverEnvironment.AllSatCallback<T> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ArrayList<IFormula> importantFormulas = new ArrayList<IFormula>(important.size());
        for (BooleanFormula impF : important) {
            importantFormulas.add((IFormula)this.mgr.extractInfo(impF));
        }
        this.api.push();
        while (!this.isUnsat()) {
            this.shutdownNotifier.shutdownIfNecessary();
            IBoolLit newFormula = new IBoolLit(true);
            ArrayList<BooleanFormula> wrappedPartialModel = new ArrayList<BooleanFormula>(important.size());
            for (IFormula f : importantFormulas) {
                Option value = this.api.evalPartial(f);
                if (!value.isDefined()) continue;
                boolean isTrueValue = (Boolean)value.get();
                IFormula newElement = isTrueValue ? f : new INot(f);
                wrappedPartialModel.add(this.mgr.encapsulateBooleanFormula((IExpression)newElement));
                newFormula = new IBinFormula(IBinJunctor.And(), (IFormula)newFormula, newElement);
            }
            callback.apply(wrappedPartialModel);
            this.addConstraint0((IFormula)new INot((IFormula)newFormula));
        }
        this.shutdownNotifier.shutdownIfNecessary();
        this.api.pop();
        this.wasLastSatCheckSat = false;
        return callback.getResult();
    }

    void addSymbol(IFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.api.addBooleanVariable(f);
        if (!this.trackingStack.isEmpty()) {
            this.trackingStack.peek().booleanSymbols.add(f);
        }
    }

    void addSymbol(ITerm f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.api.addConstant(f);
        if (!this.trackingStack.isEmpty()) {
            this.trackingStack.peek().intSymbols.add(f);
        }
    }

    void addSymbol(IFunction f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.api.addFunction(f);
        if (!this.trackingStack.isEmpty()) {
            this.trackingStack.peek().functionSymbols.add(f);
        }
    }

    private static class Level {
        final List<IFormula> booleanSymbols = new ArrayList<IFormula>();
        final List<ITerm> intSymbols = new ArrayList<ITerm>();
        final List<IFunction> functionSymbols = new ArrayList<IFunction>();
        int constraintNum = 0;

        Level(int constraintNum) {
            this.constraintNum = constraintNum;
        }

        void mergeWithHigher(Level other) {
            this.booleanSymbols.addAll(other.booleanSymbols);
            this.intSymbols.addAll(other.intSymbols);
            this.functionSymbols.addAll(other.functionSymbols);
        }

        public String toString() {
            return String.format("{%s, %s, %s}", this.booleanSymbols, this.intSymbols, this.functionSymbols);
        }
    }
}

