/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import java.math.BigDecimal;
import java.util.List;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.RationalFormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NumeralFormulaManager;

class Mathsat5RationalFormulaManager
extends Mathsat5NumeralFormulaManager<NumeralFormula, NumeralFormula.RationalFormula>
implements RationalFormulaManager {
    Mathsat5RationalFormulaManager(Mathsat5FormulaCreator pCreator) {
        super(pCreator);
    }

    @Override
    protected long getNumeralType() {
        return (Long)this.getFormulaCreator().getRationalType();
    }

    @Override
    protected Long makeNumberImpl(double pNumber) {
        return this.makeNumberImpl(Double.toString(pNumber));
    }

    @Override
    protected Long makeNumberImpl(BigDecimal pNumber) {
        return this.makeNumberImpl(pNumber.toPlainString());
    }

    @Override
    public Long divide(Long pNumber1, Long pNumber2) {
        List frac;
        if (!this.isNumeral(pNumber2)) {
            return super.divide(pNumber1, pNumber2);
        }
        long mathsatEnv = (Long)this.getFormulaCreator().getEnv();
        long t1 = pNumber1;
        long t2 = pNumber2;
        String n = Mathsat5NativeApi.msat_term_repr(t2);
        if (n.startsWith("(")) {
            n = n.substring(1, n.length() - 1);
        }
        if ((frac = Splitter.on((char)'/').splitToList((CharSequence)n)).size() == 1) {
            n = "1/" + n;
        } else {
            Verify.verify((frac.size() == 2 ? 1 : 0) != 0);
            n = (String)frac.get(1) + "/" + (String)frac.get(0);
        }
        t2 = Mathsat5NativeApi.msat_make_number(mathsatEnv, n);
        return Mathsat5NativeApi.msat_make_times(mathsatEnv, t2, t1);
    }
}

