/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.basicimpl.AbstractModel;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;

class Mathsat5Model
extends AbstractModel.CachingAbstractModel<Long, Long, Long> {
    private final long model;
    private final Mathsat5FormulaCreator formulaCreator;

    Mathsat5Model(long model, Mathsat5FormulaCreator creator) {
        super(creator);
        this.model = model;
        this.formulaCreator = creator;
    }

    @Override
    public Object evaluateImpl(Long f) {
        long term = Mathsat5NativeApi.msat_model_eval(this.model, f);
        return this.formulaCreator.convertValue(f, term);
    }

    @Override
    protected ImmutableList<Model.ValueAssignment> modelToList() {
        ImmutableList.Builder assignments = ImmutableList.builder();
        long modelIterator = Mathsat5NativeApi.msat_model_create_iterator(this.model);
        while (Mathsat5NativeApi.msat_model_iterator_has_next(modelIterator)) {
            long[] key = new long[1];
            long[] value = new long[1];
            if (Mathsat5NativeApi.msat_model_iterator_next(modelIterator, key, value)) {
                throw new NoSuchElementException();
            }
            if (Mathsat5NativeApi.msat_is_array_type((Long)this.creator.getEnv(), Mathsat5NativeApi.msat_term_get_type(value[0]))) {
                assignments.addAll(this.getArrayAssignments(key[0], key[0], value[0], Collections.emptyList()));
                continue;
            }
            assignments.add((Object)this.getAssignment(key[0], value[0]));
        }
        Mathsat5NativeApi.msat_destroy_model_iterator(modelIterator);
        return assignments.build();
    }

    private Model.ValueAssignment getAssignment(long key, long value) {
        ArrayList<Object> argumentInterpretation = new ArrayList<Object>();
        for (int i = 0; i < Mathsat5NativeApi.msat_term_arity(key); ++i) {
            long arg = Mathsat5NativeApi.msat_term_get_arg(key, i);
            argumentInterpretation.add(this.evaluateImpl(arg));
        }
        return new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(key), this.creator.encapsulateWithTypeOf(value), this.creator.encapsulateBoolean(Mathsat5NativeApi.msat_make_eq((Long)this.creator.getEnv(), key, value)), this.formulaCreator.getName(key), this.formulaCreator.convertValue(key, value), argumentInterpretation);
    }

    private Collection<Model.ValueAssignment> getArrayAssignments(long symbol, long key, long array, List<Object> upperIndices) {
        ArrayList<Model.ValueAssignment> assignments = new ArrayList<Model.ValueAssignment>();
        while (Mathsat5NativeApi.msat_term_is_array_write((Long)this.creator.getEnv(), array)) {
            long index = Mathsat5NativeApi.msat_term_get_arg(array, 1);
            ArrayList innerIndices = Lists.newArrayList(upperIndices);
            innerIndices.add(this.evaluateImpl(index));
            long content = Mathsat5NativeApi.msat_term_get_arg(array, 2);
            long select = Mathsat5NativeApi.msat_make_array_read((Long)this.creator.getEnv(), key, index);
            if (Mathsat5NativeApi.msat_is_array_type((Long)this.creator.getEnv(), Mathsat5NativeApi.msat_term_get_type(content))) {
                assignments.addAll(this.getArrayAssignments(symbol, select, content, innerIndices));
            } else {
                assignments.add(new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(select), this.creator.encapsulateWithTypeOf(content), this.creator.encapsulateBoolean(Mathsat5NativeApi.msat_make_eq((Long)this.creator.getEnv(), select, content)), this.formulaCreator.getName(symbol), this.evaluateImpl(content), innerIndices));
            }
            array = Mathsat5NativeApi.msat_term_get_arg(array, 0);
        }
        return assignments;
    }

    @Override
    public void close() {
        Mathsat5NativeApi.msat_destroy_model(this.model);
    }
}

