/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NumeralFormulaManager;

class Mathsat5IntegerFormulaManager
extends Mathsat5NumeralFormulaManager<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula>
implements IntegerFormulaManager {
    Mathsat5IntegerFormulaManager(Mathsat5FormulaCreator pCreator) {
        super(pCreator);
    }

    @Override
    protected long getNumeralType() {
        return (Long)this.getFormulaCreator().getIntegerType();
    }

    @Override
    protected Long makeNumberImpl(double pNumber) {
        return this.makeNumberImpl((long)pNumber);
    }

    @Override
    protected Long makeNumberImpl(BigDecimal pNumber) {
        return (Long)this.decimalAsInteger(pNumber);
    }

    @Override
    public Long divide(Long pNumber1, Long pNumber2) {
        List frac;
        if (!this.isNumeral(pNumber2)) {
            return super.divide(pNumber1, pNumber2);
        }
        long mathsatEnv = (Long)this.getFormulaCreator().getEnv();
        long t1 = pNumber1;
        long t2 = pNumber2;
        String n = Mathsat5NativeApi.msat_term_repr(t2);
        if (n.startsWith("(")) {
            n = n.substring(1, n.length() - 1);
        }
        if ((frac = Splitter.on((char)'/').splitToList((CharSequence)n)).size() == 1) {
            return super.divide(pNumber1, pNumber2);
        }
        Verify.verify((frac.size() == 2 ? 1 : 0) != 0);
        n = (String)frac.get(1) + "/" + (String)frac.get(0);
        t2 = Mathsat5NativeApi.msat_make_number(mathsatEnv, n);
        return Mathsat5NativeApi.msat_make_times(mathsatEnv, t2, t1);
    }

    @Override
    protected Long modularCongruence(Long pNumber1, Long pNumber2, BigInteger pModulo) {
        return this.modularCongruence0(pNumber1, pNumber2, pModulo.toString());
    }

    @Override
    protected Long modularCongruence(Long pNumber1, Long pNumber2, long pModulo) {
        return this.modularCongruence0(pNumber1, pNumber2, Long.toString(pModulo));
    }

    protected Long modularCongruence0(Long pNumber1, Long pNumber2, String pModulo) {
        return Mathsat5NativeApi.msat_make_int_modular_congruence((Long)this.getFormulaCreator().getEnv(), pModulo, pNumber1, pNumber2);
    }
}

