/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaTransformationVisitor;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;
import org.sosy_lab.java_smt.basicimpl.AbstractBaseFormulaManager;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.basicimpl.FunctionDeclarationImpl;

public abstract class AbstractBooleanFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl>
extends AbstractBaseFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl>
implements BooleanFormulaManager {
    @Nullable
    private BooleanFormula trueFormula = null;
    @Nullable
    private BooleanFormula falseFormula = null;
    private final FormulaVisitor<Set<BooleanFormula>> conjunctionFinder = new DefaultFormulaVisitor<Set<BooleanFormula>>(){

        @Override
        protected Set<BooleanFormula> visitDefault(Formula f) {
            assert (f instanceof BooleanFormula);
            BooleanFormula bf = (BooleanFormula)f;
            if (AbstractBooleanFormulaManager.this.isTrue(bf)) {
                return ImmutableSet.of();
            }
            return ImmutableSet.of((Object)((BooleanFormula)f));
        }

        @Override
        public Set<BooleanFormula> visitFunction(Formula f, List<Formula> args, FunctionDeclaration<?> functionDeclaration) {
            if (functionDeclaration.getKind() == FunctionDeclarationKind.AND) {
                return ImmutableSet.copyOf(args);
            }
            return this.visitDefault(f);
        }
    };
    private final FormulaVisitor<Set<BooleanFormula>> disjunctionFinder = new DefaultFormulaVisitor<Set<BooleanFormula>>(){

        @Override
        protected Set<BooleanFormula> visitDefault(Formula f) {
            assert (f instanceof BooleanFormula);
            BooleanFormula bf = (BooleanFormula)f;
            if (AbstractBooleanFormulaManager.this.isFalse(bf)) {
                return ImmutableSet.of();
            }
            return ImmutableSet.of((Object)((BooleanFormula)f));
        }

        @Override
        public Set<BooleanFormula> visitFunction(Formula f, List<Formula> args, FunctionDeclaration<?> functionDeclaration) {
            if (functionDeclaration.getKind() == FunctionDeclarationKind.OR) {
                return ImmutableSet.copyOf(args);
            }
            return this.visitDefault(f);
        }
    };

    protected AbstractBooleanFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv, TFuncDecl> pCreator) {
        super(pCreator);
    }

    private BooleanFormula wrap(TFormulaInfo formulaInfo) {
        return this.getFormulaCreator().encapsulateBoolean(formulaInfo);
    }

    @Override
    public BooleanFormula makeVariable(String pVar) {
        AbstractBooleanFormulaManager.checkVariableName(pVar);
        return this.wrap(this.makeVariableImpl(pVar));
    }

    protected abstract TFormulaInfo makeVariableImpl(String var1);

    @Override
    public BooleanFormula makeTrue() {
        if (this.trueFormula == null) {
            this.trueFormula = this.wrap(this.makeBooleanImpl(true));
        }
        return this.trueFormula;
    }

    @Override
    public BooleanFormula makeFalse() {
        if (this.falseFormula == null) {
            this.falseFormula = this.wrap(this.makeBooleanImpl(false));
        }
        return this.falseFormula;
    }

    @Override
    public BooleanFormula makeBoolean(boolean value) {
        return value ? this.makeTrue() : this.makeFalse();
    }

    protected abstract TFormulaInfo makeBooleanImpl(boolean var1);

    @Override
    public BooleanFormula not(BooleanFormula pBits) {
        Object param1 = this.extractInfo(pBits);
        return this.wrap(this.not(param1));
    }

    protected abstract TFormulaInfo not(TFormulaInfo var1);

    @Override
    public BooleanFormula and(BooleanFormula pBits1, BooleanFormula pBits2) {
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.and(param1, param2));
    }

    protected abstract TFormulaInfo and(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula and(Collection<BooleanFormula> pBits) {
        if (pBits.isEmpty()) {
            return this.makeBoolean(true);
        }
        if (pBits.size() == 1) {
            return (BooleanFormula)Iterables.getOnlyElement(pBits);
        }
        TFormulaInfo result = this.andImpl(Collections2.transform(pBits, this::extractInfo));
        return this.wrap(result);
    }

    @Override
    public BooleanFormula and(BooleanFormula ... pBits) {
        return this.and(Arrays.asList(pBits));
    }

    protected TFormulaInfo andImpl(Collection<TFormulaInfo> pParams) {
        TFormulaInfo result = this.makeBooleanImpl(true);
        for (TFormulaInfo formula : pParams) {
            result = this.and(result, formula);
        }
        return result;
    }

    @Override
    public Collector<BooleanFormula, ?, BooleanFormula> toConjunction() {
        return Collectors.reducing(this.makeTrue(), this::and);
    }

    @Override
    public BooleanFormula or(BooleanFormula pBits1, BooleanFormula pBits2) {
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.or(param1, param2));
    }

    @Override
    public BooleanFormula or(BooleanFormula ... pBits) {
        return this.or(Arrays.asList(pBits));
    }

    protected abstract TFormulaInfo or(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula xor(BooleanFormula pBits1, BooleanFormula pBits2) {
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.xor(param1, param2));
    }

    @Override
    public BooleanFormula or(Collection<BooleanFormula> pBits) {
        if (pBits.isEmpty()) {
            return this.makeBoolean(false);
        }
        if (pBits.size() == 1) {
            return (BooleanFormula)Iterables.getOnlyElement(pBits);
        }
        TFormulaInfo result = this.orImpl(Collections2.transform(pBits, this::extractInfo));
        return this.wrap(result);
    }

    protected TFormulaInfo orImpl(Collection<TFormulaInfo> pParams) {
        TFormulaInfo result = this.makeBooleanImpl(false);
        for (TFormulaInfo formula : pParams) {
            result = this.or(result, formula);
        }
        return result;
    }

    @Override
    public Collector<BooleanFormula, ?, BooleanFormula> toDisjunction() {
        return Collectors.reducing(this.makeFalse(), this::or);
    }

    protected abstract TFormulaInfo xor(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public final BooleanFormula equivalence(BooleanFormula pBits1, BooleanFormula pBits2) {
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.equivalence(param1, param2));
    }

    protected abstract TFormulaInfo equivalence(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public final BooleanFormula implication(BooleanFormula pBits1, BooleanFormula pBits2) {
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.implication(param1, param2));
    }

    protected TFormulaInfo implication(TFormulaInfo bits1, TFormulaInfo bits2) {
        return this.or(this.not(bits1), bits2);
    }

    @Override
    public final boolean isTrue(BooleanFormula pBits) {
        return this.isTrue(this.extractInfo(pBits));
    }

    protected abstract boolean isTrue(TFormulaInfo var1);

    @Override
    public final boolean isFalse(BooleanFormula pBits) {
        return this.isFalse(this.extractInfo(pBits));
    }

    protected abstract boolean isFalse(TFormulaInfo var1);

    @Override
    public final <T extends Formula> T ifThenElse(BooleanFormula pBits, T f1, T f2) {
        FormulaType<?> t1 = this.getFormulaCreator().getFormulaType(f1);
        FormulaType<?> t2 = this.getFormulaCreator().getFormulaType(f2);
        Preconditions.checkArgument((boolean)t1.equals(t2), (String)"Cannot create if-then-else formula with branches of different types: %s is of type %s; %s is of type %s", f1, t1, f2, t2);
        Object result = this.ifThenElse(this.extractInfo(pBits), this.extractInfo(f1), this.extractInfo(f2));
        return (T)this.getFormulaCreator().encapsulate(t1, result);
    }

    protected abstract TFormulaInfo ifThenElse(TFormulaInfo var1, TFormulaInfo var2, TFormulaInfo var3);

    @Override
    public <R> R visit(BooleanFormula pFormula, BooleanFormulaVisitor<R> visitor) {
        return this.formulaCreator.visit(pFormula, new DelegatingFormulaVisitor<R>(visitor));
    }

    @Override
    public void visitRecursively(BooleanFormula pF, BooleanFormulaVisitor<TraversalProcess> pFormulaVisitor) {
        this.formulaCreator.visitRecursively(new DelegatingFormulaVisitor<TraversalProcess>(pFormulaVisitor), pF, arg_0 -> ((Predicate)Predicates.instanceOf(BooleanFormula.class)).apply(arg_0));
    }

    @Override
    public BooleanFormula transformRecursively(BooleanFormula f, BooleanFormulaTransformationVisitor pVisitor) {
        return this.formulaCreator.transformRecursively(new DelegatingFormulaVisitor<BooleanFormula>(pVisitor), f, p -> p instanceof BooleanFormula);
    }

    @Override
    public Set<BooleanFormula> toConjunctionArgs(BooleanFormula f, boolean flatten) {
        if (flatten) {
            return this.asFuncRecursive(f, this.conjunctionFinder);
        }
        return this.formulaCreator.visit(f, this.conjunctionFinder);
    }

    @Override
    public Set<BooleanFormula> toDisjunctionArgs(BooleanFormula f, boolean flatten) {
        if (flatten) {
            return this.asFuncRecursive(f, this.disjunctionFinder);
        }
        return this.formulaCreator.visit(f, this.disjunctionFinder);
    }

    private Set<BooleanFormula> asFuncRecursive(BooleanFormula f, FormulaVisitor<Set<BooleanFormula>> visitor) {
        ImmutableSet.Builder output = ImmutableSet.builder();
        ArrayDeque<BooleanFormula> toProcess = new ArrayDeque<BooleanFormula>();
        HashMap<BooleanFormula, Set> cache = new HashMap<BooleanFormula, Set>();
        toProcess.add(f);
        while (!toProcess.isEmpty()) {
            BooleanFormula s = (BooleanFormula)toProcess.pop();
            Set out = cache.computeIfAbsent(s, ss -> (Set)this.formulaCreator.visit((Formula)ss, visitor));
            if (out.size() == 1 && s.equals(out.iterator().next())) {
                output.add((Object)s);
            }
            for (BooleanFormula arg : out) {
                if (cache.get(arg) != null) continue;
                toProcess.add(arg);
            }
        }
        return output.build();
    }

    private class DelegatingFormulaVisitor<R>
    implements FormulaVisitor<R> {
        private final BooleanFormulaVisitor<R> delegate;

        DelegatingFormulaVisitor(BooleanFormulaVisitor<R> pDelegate) {
            this.delegate = pDelegate;
        }

        @Override
        public R visitFreeVariable(Formula f, String name) {
            assert (f instanceof BooleanFormula);
            BooleanFormula casted = (BooleanFormula)f;
            return this.delegate.visitAtom(casted, FunctionDeclarationImpl.of(name, FunctionDeclarationKind.VAR, ImmutableList.of(), FormulaType.BooleanType, AbstractBooleanFormulaManager.this.formulaCreator.getBooleanVarDeclaration(casted)));
        }

        @Override
        public R visitBoundVariable(Formula f, int deBruijnIdx) {
            assert (f instanceof BooleanFormula);
            return this.delegate.visitBoundVar((BooleanFormula)f, deBruijnIdx);
        }

        @Override
        public R visitConstant(Formula f, Object value) {
            Preconditions.checkState((boolean)(value instanceof Boolean));
            return this.delegate.visitConstant((Boolean)value);
        }

        private List<BooleanFormula> getBoolArgs(List<Formula> args) {
            List<Formula> out = args;
            return out;
        }

        @Override
        public R visitFunction(Formula f, List<Formula> args, FunctionDeclaration<?> functionDeclaration) {
            switch (functionDeclaration.getKind()) {
                case AND: {
                    Preconditions.checkState((boolean)(args.iterator().next() instanceof BooleanFormula));
                    R out = this.delegate.visitAnd(this.getBoolArgs(args));
                    return out;
                }
                case NOT: {
                    Preconditions.checkState((args.size() == 1 ? 1 : 0) != 0);
                    Formula arg = args.get(0);
                    Preconditions.checkArgument((boolean)(arg instanceof BooleanFormula));
                    return this.delegate.visitNot((BooleanFormula)arg);
                }
                case OR: {
                    Preconditions.checkState((boolean)(args.iterator().next() instanceof BooleanFormula));
                    R out2 = this.delegate.visitOr(this.getBoolArgs(args));
                    return out2;
                }
                case IFF: {
                    Preconditions.checkState((args.size() == 2 ? 1 : 0) != 0);
                    Formula a = args.get(0);
                    Formula b = args.get(1);
                    Preconditions.checkState((a instanceof BooleanFormula && b instanceof BooleanFormula ? 1 : 0) != 0);
                    R out3 = this.delegate.visitEquivalence((BooleanFormula)a, (BooleanFormula)b);
                    return out3;
                }
                case EQ: {
                    if (args.size() == 2 && args.get(0) instanceof BooleanFormula && args.get(1) instanceof BooleanFormula) {
                        return this.delegate.visitEquivalence((BooleanFormula)args.get(0), (BooleanFormula)args.get(1));
                    }
                    return this.delegate.visitAtom((BooleanFormula)f, this.toBooleanDeclaration(functionDeclaration));
                }
                case ITE: {
                    Preconditions.checkArgument((args.size() == 3 ? 1 : 0) != 0);
                    Formula ifC = args.get(0);
                    Formula then = args.get(1);
                    Formula elseC = args.get(2);
                    Preconditions.checkState((ifC instanceof BooleanFormula && then instanceof BooleanFormula && elseC instanceof BooleanFormula ? 1 : 0) != 0);
                    return this.delegate.visitIfThenElse((BooleanFormula)ifC, (BooleanFormula)then, (BooleanFormula)elseC);
                }
                case XOR: {
                    Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0);
                    Formula a1 = args.get(0);
                    Formula a2 = args.get(1);
                    Preconditions.checkState((a1 instanceof BooleanFormula && a2 instanceof BooleanFormula ? 1 : 0) != 0);
                    return this.delegate.visitXor((BooleanFormula)a1, (BooleanFormula)a2);
                }
                case IMPLIES: {
                    Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0);
                    Formula b1 = args.get(0);
                    Formula b2 = args.get(1);
                    Preconditions.checkArgument((b1 instanceof BooleanFormula && b2 instanceof BooleanFormula ? 1 : 0) != 0);
                    return this.delegate.visitImplication((BooleanFormula)b1, (BooleanFormula)b2);
                }
            }
            return this.delegate.visitAtom((BooleanFormula)f, this.toBooleanDeclaration(functionDeclaration));
        }

        @Override
        public R visitQuantifier(BooleanFormula f, QuantifiedFormulaManager.Quantifier quantifier, List<Formula> boundVariables, BooleanFormula body) {
            return this.delegate.visitQuantifier(quantifier, f, boundVariables, body);
        }

        private FunctionDeclaration<BooleanFormula> toBooleanDeclaration(FunctionDeclaration<?> decl) {
            return decl;
        }
    }
}

