/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.api;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverException;

public interface BasicProverEnvironment<T>
extends AutoCloseable {
    @Nullable
    @CanIgnoreReturnValue
    default public T push(BooleanFormula f) throws InterruptedException {
        this.push();
        return this.addConstraint(f);
    }

    public void pop();

    @Nullable
    @CanIgnoreReturnValue
    public T addConstraint(BooleanFormula var1) throws InterruptedException;

    public void push();

    public boolean isUnsat() throws SolverException, InterruptedException;

    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> var1) throws SolverException, InterruptedException;

    public Model getModel() throws SolverException;

    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException;

    public List<BooleanFormula> getUnsatCore();

    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> var1) throws SolverException, InterruptedException;

    @Override
    public void close();

    public <R> R allSat(AllSatCallback<R> var1, List<BooleanFormula> var2) throws InterruptedException, SolverException;

    public static interface AllSatCallback<R> {
        public void apply(List<BooleanFormula> var1);

        public R getResult() throws InterruptedException;
    }
}

