/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.z3;

import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.microsoft.z3.Native;
import com.microsoft.z3.enumerations.Z3_decl_kind;
import com.microsoft.z3.enumerations.Z3_sort_kind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.basicimpl.AbstractModel;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaCreator;

class Z3Model
extends AbstractModel.CachingAbstractModel<Long, Long, Long> {
    private final long model;
    private final long z3context;
    private static final Pattern Z3_IRRELEVANT_MODEL_TERM_PATTERN = Pattern.compile(".*![0-9]+");
    private final Z3FormulaCreator z3creator;
    private boolean closed = false;

    private Z3Model(long z3context, long z3model, Z3FormulaCreator pCreator) {
        super(pCreator);
        Native.modelIncRef((long)z3context, (long)z3model);
        this.model = z3model;
        this.z3context = z3context;
        this.z3creator = pCreator;
    }

    static Z3Model create(long z3context, long z3model, Z3FormulaCreator pCreator) {
        return new Z3Model(z3context, z3model, pCreator);
    }

    @Override
    protected ImmutableList<Model.ValueAssignment> toList() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ImmutableList.Builder out = ImmutableList.builder();
        for (int constIdx = 0; constIdx < Native.modelGetNumConsts((long)this.z3context, (long)this.model); ++constIdx) {
            long keyDecl = Native.modelGetConstDecl((long)this.z3context, (long)this.model, (int)constIdx);
            Native.incRef((long)this.z3context, (long)keyDecl);
            out.addAll(this.getConstAssignments(keyDecl));
            Native.decRef((long)this.z3context, (long)keyDecl);
        }
        for (int funcIdx = 0; funcIdx < Native.modelGetNumFuncs((long)this.z3context, (long)this.model); ++funcIdx) {
            long funcDecl = Native.modelGetFuncDecl((long)this.z3context, (long)this.model, (int)funcIdx);
            Native.incRef((long)this.z3context, (long)funcDecl);
            if (!this.isInternalSymbol(funcDecl)) {
                String functionName = this.z3creator.symbolToString(Native.getDeclName((long)this.z3context, (long)funcDecl));
                out.addAll(this.getFunctionAssignments(funcDecl, funcDecl, functionName));
            }
            Native.decRef((long)this.z3context, (long)funcDecl);
        }
        return out.build();
    }

    private boolean isInternalSymbol(long funcDecl) {
        return Z3_IRRELEVANT_MODEL_TERM_PATTERN.matcher(this.z3creator.symbolToString(Native.getDeclName((long)this.z3context, (long)funcDecl))).matches() || Z3_decl_kind.Z3_OP_SELECT == Z3_decl_kind.fromInt((int)Native.getDeclKind((long)this.z3context, (long)funcDecl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Model.ValueAssignment> getConstAssignments(long keyDecl) {
        Preconditions.checkArgument((Native.getArity((long)this.z3context, (long)keyDecl) == 0 ? 1 : 0) != 0, (Object)"Declaration is not a constant");
        long var = Native.mkApp((long)this.z3context, (long)keyDecl, (int)0, (long[])new long[0]);
        long value = Native.modelGetConstInterp((long)this.z3context, (long)this.model, (long)keyDecl);
        this.checkReturnValue(value, keyDecl);
        Native.incRef((long)this.z3context, (long)value);
        long equality = Native.mkEq((long)this.z3context, (long)var, (long)value);
        Native.incRef((long)this.z3context, (long)equality);
        try {
            long symbol = Native.getDeclName((long)this.z3context, (long)keyDecl);
            if (this.z3creator.isConstant(value)) {
                List<Model.ValueAssignment> list = Collections.singletonList(new Model.ValueAssignment(this.z3creator.encapsulateWithTypeOf(var), this.z3creator.encapsulateWithTypeOf(value), this.z3creator.encapsulateBoolean(equality), this.z3creator.symbolToString(symbol), this.z3creator.convertValue(value), (Collection<?>)ImmutableList.of()));
                return list;
            }
            if (Native.isAsArray((long)this.z3context, (long)value)) {
                long arrayFormula = Native.mkConst((long)this.z3context, (long)symbol, (long)Native.getSort((long)this.z3context, (long)value));
                Native.incRef((long)this.z3context, (long)arrayFormula);
                Collection<Model.ValueAssignment> collection = this.getArrayAssignments(symbol, arrayFormula, value, Collections.emptyList());
                return collection;
            }
            if (Native.isApp((long)this.z3context, (long)value)) {
                long decl = Native.getAppDecl((long)this.z3context, (long)value);
                Native.incRef((long)this.z3context, (long)decl);
                Z3_sort_kind sortKind = Z3_sort_kind.fromInt((int)Native.getSortKind((long)this.z3context, (long)Native.getSort((long)this.z3context, (long)value)));
                assert (sortKind == Z3_sort_kind.Z3_ARRAY_SORT) : "unexpected sort: " + sortKind;
                try {
                    Collection<Model.ValueAssignment> collection = this.getConstantArrayAssignment(symbol, value, decl);
                    return collection;
                }
                finally {
                    Native.decRef((long)this.z3context, (long)decl);
                }
            }
            throw new UnsupportedOperationException("unknown model evaluation: " + Native.astToString((long)this.z3context, (long)value));
        }
        finally {
            Native.decRef((long)this.z3context, (long)value);
        }
    }

    private Collection<Model.ValueAssignment> getConstantArrayAssignment(long arraySymbol, long value, long decl) {
        long arrayFormula = Native.mkConst((long)this.z3context, (long)arraySymbol, (long)Native.getSort((long)this.z3context, (long)value));
        Native.incRef((long)this.z3context, (long)arrayFormula);
        Z3_decl_kind declKind = Z3_decl_kind.fromInt((int)Native.getDeclKind((long)this.z3context, (long)decl));
        int numArgs = Native.getAppNumArgs((long)this.z3context, (long)value);
        ArrayList<Model.ValueAssignment> out = new ArrayList<Model.ValueAssignment>();
        HashSet<Long> indizes = new HashSet<Long>();
        while (Z3_decl_kind.Z3_OP_STORE == declKind) {
            assert (numArgs == 3);
            long arrayIndex = Native.getAppArg((long)this.z3context, (long)value, (int)1);
            Native.incRef((long)this.z3context, (long)arrayIndex);
            if (indizes.add(arrayIndex)) {
                long select = Native.mkSelect((long)this.z3context, (long)arrayFormula, (long)arrayIndex);
                Native.incRef((long)this.z3context, (long)select);
                long nestedValue = Native.getAppArg((long)this.z3context, (long)value, (int)2);
                Native.incRef((long)this.z3context, (long)nestedValue);
                long equality = Native.mkEq((long)this.z3context, (long)select, (long)nestedValue);
                Native.incRef((long)this.z3context, (long)equality);
                out.add(new Model.ValueAssignment(this.z3creator.encapsulateWithTypeOf(select), this.z3creator.encapsulateWithTypeOf(nestedValue), this.z3creator.encapsulateBoolean(equality), this.z3creator.symbolToString(arraySymbol), this.z3creator.convertValue(nestedValue), (Collection<?>)ImmutableList.of((Object)this.evaluateImpl(arrayIndex))));
            }
            Native.decRef((long)this.z3context, (long)arrayIndex);
            value = Native.getAppArg((long)this.z3context, (long)value, (int)0);
            decl = Native.getAppDecl((long)this.z3context, (long)value);
            declKind = Z3_decl_kind.fromInt((int)Native.getDeclKind((long)this.z3context, (long)decl));
            numArgs = Native.getAppNumArgs((long)this.z3context, (long)value);
        }
        if (Z3_decl_kind.Z3_OP_CONST_ARRAY == declKind) assert (numArgs == 1);
        return out;
    }

    private Collection<Model.ValueAssignment> getArrayAssignments(long arraySymbol, long arrayFormula, long value, List<Object> upperIndices) {
        long evalDecl = Native.getAsArrayFuncDecl((long)this.z3context, (long)value);
        Native.incRef((long)this.z3context, (long)evalDecl);
        long interp = Native.modelGetFuncInterp((long)this.z3context, (long)this.model, (long)evalDecl);
        this.checkReturnValue(interp, evalDecl);
        Native.funcInterpIncRef((long)this.z3context, (long)interp);
        ArrayList<Model.ValueAssignment> lst = new ArrayList<Model.ValueAssignment>();
        int numInterpretations = Native.funcInterpGetNumEntries((long)this.z3context, (long)interp);
        for (int interpIdx = 0; interpIdx < numInterpretations; ++interpIdx) {
            long entry = Native.funcInterpGetEntry((long)this.z3context, (long)interp, (int)interpIdx);
            Native.funcEntryIncRef((long)this.z3context, (long)entry);
            long arrayValue = Native.funcEntryGetValue((long)this.z3context, (long)entry);
            Native.incRef((long)this.z3context, (long)arrayValue);
            int noArgs = Native.funcEntryGetNumArgs((long)this.z3context, (long)entry);
            assert (noArgs == 1) : "array modelled as UF is expected to have only one parameter, aka index";
            long arrayIndex = Native.funcEntryGetArg((long)this.z3context, (long)entry, (int)0);
            Native.incRef((long)this.z3context, (long)arrayIndex);
            long select = Native.mkSelect((long)this.z3context, (long)arrayFormula, (long)arrayIndex);
            Native.incRef((long)this.z3context, (long)select);
            ArrayList innerIndices = Lists.newArrayList(upperIndices);
            innerIndices.add(this.evaluateImpl(arrayIndex));
            if (this.z3creator.isConstant(arrayValue)) {
                long equality = Native.mkEq((long)this.z3context, (long)select, (long)arrayValue);
                Native.incRef((long)this.z3context, (long)equality);
                lst.add(new Model.ValueAssignment(this.z3creator.encapsulateWithTypeOf(select), this.z3creator.encapsulateWithTypeOf(arrayValue), this.z3creator.encapsulateBoolean(equality), this.z3creator.symbolToString(arraySymbol), this.z3creator.convertValue(arrayValue), innerIndices));
            } else if (Native.isAsArray((long)this.z3context, (long)arrayValue)) {
                lst.addAll(this.getArrayAssignments(arraySymbol, select, arrayValue, innerIndices));
            }
            Native.decRef((long)this.z3context, (long)arrayIndex);
            Native.funcEntryDecRef((long)this.z3context, (long)entry);
        }
        Native.funcInterpDecRef((long)this.z3context, (long)interp);
        Native.decRef((long)this.z3context, (long)evalDecl);
        return lst;
    }

    private void checkReturnValue(long value, long funcDecl) {
        if (value == 0L) {
            throw new VerifyException("Z3 unexpectedly claims that the value of " + Native.funcDeclToString((long)this.z3context, (long)funcDecl) + " does not matter in model.");
        }
    }

    private Collection<Model.ValueAssignment> getFunctionAssignments(long evalDecl, long funcDecl, String functionName) {
        long interp = Native.modelGetFuncInterp((long)this.z3context, (long)this.model, (long)evalDecl);
        this.checkReturnValue(interp, evalDecl);
        Native.funcInterpIncRef((long)this.z3context, (long)interp);
        ArrayList<Model.ValueAssignment> lst = new ArrayList<Model.ValueAssignment>();
        int numInterpretations = Native.funcInterpGetNumEntries((long)this.z3context, (long)interp);
        if (numInterpretations == 0) {
            long elseInterp = Native.funcInterpGetElse((long)this.z3context, (long)interp);
            Native.incRef((long)this.z3context, (long)elseInterp);
            long aliasDecl = Native.getAppDecl((long)this.z3context, (long)elseInterp);
            Native.incRef((long)this.z3context, (long)aliasDecl);
            if (this.isInternalSymbol(aliasDecl)) {
                lst.addAll(this.getFunctionAssignments(aliasDecl, funcDecl, functionName));
            }
            Native.decRef((long)this.z3context, (long)aliasDecl);
            Native.decRef((long)this.z3context, (long)elseInterp);
        } else {
            for (int interpIdx = 0; interpIdx < numInterpretations; ++interpIdx) {
                long entry = Native.funcInterpGetEntry((long)this.z3context, (long)interp, (int)interpIdx);
                Native.funcEntryIncRef((long)this.z3context, (long)entry);
                long entryValue = Native.funcEntryGetValue((long)this.z3context, (long)entry);
                if (this.z3creator.isConstant(entryValue)) {
                    lst.add(this.getFunctionAssignment(functionName, funcDecl, entry, entryValue));
                }
                Native.funcEntryDecRef((long)this.z3context, (long)entry);
            }
        }
        Native.funcInterpDecRef((long)this.z3context, (long)interp);
        return lst;
    }

    private Model.ValueAssignment getFunctionAssignment(String functionName, long funcDecl, long entry, long entryValue) {
        Object value = this.z3creator.convertValue(entryValue);
        int numArgs = Native.funcEntryGetNumArgs((long)this.z3context, (long)entry);
        long[] args = new long[numArgs];
        ArrayList<Object> argumentInterpretation = new ArrayList<Object>();
        for (int k = 0; k < numArgs; ++k) {
            long arg = Native.funcEntryGetArg((long)this.z3context, (long)entry, (int)k);
            Native.incRef((long)this.z3context, (long)arg);
            assert (!Native.isAsArray((long)this.z3context, (long)arg)) : "unexpected array-reference as evaluation of a UF parameter: " + Native.astToString((long)this.z3context, (long)arg);
            argumentInterpretation.add(this.z3creator.convertValue(arg));
            args[k] = arg;
        }
        long func = Native.mkApp((long)this.z3context, (long)funcDecl, (int)args.length, (long[])args);
        for (long arg : args) {
            Native.decRef((long)this.z3context, (long)arg);
        }
        long equality = Native.mkEq((long)this.z3context, (long)func, (long)entryValue);
        Native.incRef((long)this.z3context, (long)equality);
        return new Model.ValueAssignment(this.z3creator.encapsulateWithTypeOf(func), this.z3creator.encapsulateWithTypeOf(entryValue), this.z3creator.encapsulateBoolean(equality), functionName, value, argumentInterpretation);
    }

    @Override
    public String toString() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return Native.modelToString((long)this.z3context, (long)this.model);
    }

    @Override
    public void close() {
        if (!this.closed) {
            Native.modelDecRef((long)this.z3context, (long)this.model);
            this.closed = true;
        }
    }

    @Override
    protected Long evalImpl(Long formula) {
        Native.LongPtr resultPtr = new Native.LongPtr();
        boolean satisfiableModel = Native.modelEval((long)this.z3context, (long)this.model, (long)formula, (boolean)false, (Native.LongPtr)resultPtr);
        Preconditions.checkState((boolean)satisfiableModel);
        if (resultPtr.value == 0L) {
            return null;
        }
        Native.incRef((long)this.z3context, (long)resultPtr.value);
        return resultPtr.value;
    }
}

