/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.princess;

import ap.basetypes.IdealInt;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFunApp;
import ap.parser.IFunction;
import ap.parser.IIntLit;
import ap.parser.ITerm;
import ap.parser.ITermITE;
import ap.theories.nia.GroebnerMultiplication;
import ap.types.Sort;
import ap.types.SortedIFunction$;
import com.google.common.base.Preconditions;
import java.util.List;
import org.sosy_lab.java_smt.solvers.princess.PrincessEnvironment;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;

abstract class PrincessFunctionDeclaration {
    private PrincessFunctionDeclaration() {
    }

    abstract IExpression makeApp(PrincessEnvironment var1, List<IExpression> var2);

    static class PrincessMultiplyDeclaration
    extends PrincessFunctionDeclaration {
        static final PrincessMultiplyDeclaration INSTANCE = new PrincessMultiplyDeclaration(){};

        private PrincessMultiplyDeclaration() {
        }

        @Override
        public IExpression makeApp(PrincessEnvironment env, List<IExpression> args) {
            Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0);
            return GroebnerMultiplication.mult((ITerm)((ITerm)args.get(0)), (ITerm)((ITerm)args.get(1)));
        }
    }

    static class PrincessEquationDeclaration
    extends PrincessFunctionDeclaration {
        static final PrincessEquationDeclaration INSTANCE = new PrincessEquationDeclaration(){};

        private PrincessEquationDeclaration() {
        }

        @Override
        public IExpression makeApp(PrincessEnvironment env, List<IExpression> args) {
            Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0);
            return ((ITerm)args.get(0)).$eq$eq$eq((ITerm)args.get(1));
        }
    }

    static class PrincessByExampleDeclaration
    extends PrincessFunctionDeclaration {
        private final IExpression example;

        PrincessByExampleDeclaration(IExpression pExample) {
            this.example = pExample;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PrincessByExampleDeclaration)) {
                return false;
            }
            PrincessByExampleDeclaration other = (PrincessByExampleDeclaration)o;
            return this.example.equals(other.example);
        }

        @Override
        public IExpression makeApp(PrincessEnvironment env, List<IExpression> args) {
            return this.example.update((Seq)JavaConversions.asScalaBuffer(args));
        }

        public int hashCode() {
            return this.example.hashCode();
        }

        public String toString() {
            return this.example.toString();
        }
    }

    static class PrincessIFunctionDeclaration
    extends PrincessFunctionDeclaration {
        private final IFunction app;

        PrincessIFunctionDeclaration(IFunction pApp) {
            this.app = pApp;
        }

        @Override
        public IExpression makeApp(PrincessEnvironment env, List<IExpression> args) {
            Preconditions.checkArgument((args.size() == this.app.arity() ? 1 : 0) != 0, (Object)"functiontype has different number of args.");
            ArrayBuffer argsBuf = new ArrayBuffer();
            for (IExpression arg : args) {
                Object termArg = arg instanceof IFormula ? new ITermITE((IFormula)arg, (ITerm)new IIntLit(IdealInt.ZERO()), (ITerm)new IIntLit(IdealInt.ONE())) : (ITerm)arg;
                argsBuf.$plus$eq(termArg);
            }
            IFunApp returnFormula = new IFunApp(this.app, argsBuf.toSeq());
            Sort returnType = SortedIFunction$.MODULE$.iResultSort(this.app, returnFormula.args());
            if (returnType == PrincessEnvironment.BOOL_SORT) {
                IExpression.BooleanFunApplier ap = new IExpression.BooleanFunApplier(this.app);
                return ap.apply((Seq)argsBuf);
            }
            return returnFormula;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PrincessIFunctionDeclaration)) {
                return false;
            }
            PrincessIFunctionDeclaration other = (PrincessIFunctionDeclaration)o;
            return this.app.equals(other.app);
        }

        public int hashCode() {
            return this.app.hashCode();
        }

        public String toString() {
            return this.app.toString();
        }
    }
}

