/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.api.visitors;

import java.util.List;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaVisitor;

public abstract class BooleanFormulaTransformationVisitor
implements BooleanFormulaVisitor<BooleanFormula> {
    private final FormulaManager mgr;
    private final BooleanFormulaManager bfmgr;

    protected BooleanFormulaTransformationVisitor(FormulaManager pMgr) {
        this.mgr = pMgr;
        this.bfmgr = this.mgr.getBooleanFormulaManager();
    }

    @Override
    public BooleanFormula visitConstant(boolean value) {
        return this.bfmgr.makeBoolean(value);
    }

    @Override
    public BooleanFormula visitBoundVar(BooleanFormula var, int deBruijnIdx) {
        return var;
    }

    @Override
    public BooleanFormula visitAtom(BooleanFormula pAtom, FunctionDeclaration<BooleanFormula> decl) {
        return pAtom;
    }

    @Override
    public BooleanFormula visitNot(BooleanFormula processedOperand) {
        return this.bfmgr.not(processedOperand);
    }

    @Override
    public BooleanFormula visitAnd(List<BooleanFormula> processedOperands) {
        for (BooleanFormula op : processedOperands) {
            if (!this.bfmgr.isFalse(op)) continue;
            return this.bfmgr.makeBoolean(false);
        }
        return processedOperands.stream().filter(input -> !this.bfmgr.isTrue((BooleanFormula)input)).collect(this.bfmgr.toConjunction());
    }

    @Override
    public BooleanFormula visitOr(List<BooleanFormula> processedOperands) {
        for (BooleanFormula op : processedOperands) {
            if (!this.bfmgr.isTrue(op)) continue;
            return this.bfmgr.makeBoolean(true);
        }
        return processedOperands.stream().filter(input -> !this.bfmgr.isFalse((BooleanFormula)input)).collect(this.bfmgr.toDisjunction());
    }

    @Override
    public BooleanFormula visitXor(BooleanFormula processedOperand1, BooleanFormula processedOperand2) {
        return this.bfmgr.xor(processedOperand1, processedOperand2);
    }

    @Override
    public BooleanFormula visitEquivalence(BooleanFormula processedOperand1, BooleanFormula processedOperand2) {
        return this.bfmgr.equivalence(processedOperand1, processedOperand2);
    }

    @Override
    public BooleanFormula visitImplication(BooleanFormula processedOperand1, BooleanFormula processedOperand2) {
        return this.bfmgr.implication(processedOperand1, processedOperand2);
    }

    @Override
    public BooleanFormula visitIfThenElse(BooleanFormula processedCondition, BooleanFormula processedThenFormula, BooleanFormula processedElseFormula) {
        return this.bfmgr.ifThenElse(processedCondition, processedThenFormula, processedElseFormula);
    }

    @Override
    public BooleanFormula visitQuantifier(QuantifiedFormulaManager.Quantifier quantifier, BooleanFormula quantifiedAST, List<Formula> boundVars, BooleanFormula processedBody) {
        return this.mgr.getQuantifiedFormulaManager().mkQuantifier(quantifier, boundVars, processedBody);
    }
}

