/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.api;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.Appender;
import org.sosy_lab.java_smt.api.ArrayFormulaManager;
import org.sosy_lab.java_smt.api.BitvectorFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.FloatingPointFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.RationalFormulaManager;
import org.sosy_lab.java_smt.api.Tactic;
import org.sosy_lab.java_smt.api.UFManager;
import org.sosy_lab.java_smt.api.visitors.FormulaTransformationVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;

public interface FormulaManager {
    public IntegerFormulaManager getIntegerFormulaManager();

    public RationalFormulaManager getRationalFormulaManager();

    public BooleanFormulaManager getBooleanFormulaManager();

    public ArrayFormulaManager getArrayFormulaManager();

    public BitvectorFormulaManager getBitvectorFormulaManager();

    public FloatingPointFormulaManager getFloatingPointFormulaManager();

    public UFManager getUFManager();

    public QuantifiedFormulaManager getQuantifiedFormulaManager();

    public <T extends Formula> T makeVariable(FormulaType<T> var1, String var2);

    public <T extends Formula> T makeApplication(FunctionDeclaration<T> var1, List<? extends Formula> var2);

    public <T extends Formula> T makeApplication(FunctionDeclaration<T> var1, Formula ... var2);

    public <T extends Formula> FormulaType<T> getFormulaType(T var1);

    public BooleanFormula parse(String var1) throws IllegalArgumentException;

    public Appender dumpFormula(BooleanFormula var1);

    public BooleanFormula applyTactic(BooleanFormula var1, Tactic var2) throws InterruptedException;

    public <T extends Formula> T simplify(T var1) throws InterruptedException;

    @CanIgnoreReturnValue
    public <R> R visit(Formula var1, FormulaVisitor<R> var2);

    public void visitRecursively(Formula var1, FormulaVisitor<TraversalProcess> var2);

    public <T extends Formula> T transformRecursively(T var1, FormulaTransformationVisitor var2);

    public Map<String, Formula> extractVariables(Formula var1);

    public Map<String, Formula> extractVariablesAndUFs(Formula var1);

    public <T extends Formula> T substitute(T var1, Map<? extends Formula, ? extends Formula> var2);

    public BooleanFormula translateFrom(BooleanFormula var1, FormulaManager var2);

    public boolean isValidName(String var1);
}

