/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.truth.TruthJUnit;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.After;
import org.junit.Before;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.ArrayFormulaManager;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BitvectorFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.FloatingPointFormulaManager;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.RationalFormulaManager;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.UFManager;
import org.sosy_lab.java_smt.test.BooleanFormulaSubject;
import org.sosy_lab.java_smt.test.ProverEnvironmentSubject;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="test code")
public abstract class SolverBasedTest0 {
    protected Configuration config;
    protected final LogManager logger = LogManager.createTestLogManager();
    protected SolverContextFactory factory;
    protected SolverContext context;
    protected FormulaManager mgr;
    protected BooleanFormulaManager bmgr;
    protected UFManager fmgr;
    protected IntegerFormulaManager imgr;
    protected @Nullable RationalFormulaManager rmgr;
    protected @Nullable BitvectorFormulaManager bvmgr;
    protected @Nullable QuantifiedFormulaManager qmgr;
    protected @Nullable ArrayFormulaManager amgr;
    protected @Nullable FloatingPointFormulaManager fpmgr;
    protected ShutdownManager shutdownManager = ShutdownManager.create();

    protected ShutdownNotifier shutdownNotifierToUse() {
        return this.shutdownManager.getNotifier();
    }

    protected SolverContextFactory.Solvers solverToUse() {
        return SolverContextFactory.Solvers.SMTINTERPOL;
    }

    protected ConfigurationBuilder createTestConfigBuilder() {
        return Configuration.builder().setOption("solver.solver", this.solverToUse().toString());
    }

    @Before
    public final void initSolver() throws InvalidConfigurationException {
        this.config = this.createTestConfigBuilder().build();
        this.factory = new SolverContextFactory(this.config, this.logger, this.shutdownNotifierToUse());
        try {
            this.context = this.factory.generateContext();
        }
        catch (InvalidConfigurationException e) {
            TruthJUnit.assume().withMessage(e.getMessage()).that((Throwable)e).hasCauseThat().isNotInstanceOf(UnsatisfiedLinkError.class);
            throw e;
        }
        this.mgr = this.context.getFormulaManager();
        this.fmgr = this.mgr.getUFManager();
        this.bmgr = this.mgr.getBooleanFormulaManager();
        this.imgr = this.mgr.getIntegerFormulaManager();
        try {
            this.rmgr = this.mgr.getRationalFormulaManager();
        }
        catch (UnsupportedOperationException e) {
            this.rmgr = null;
        }
        try {
            this.bvmgr = this.mgr.getBitvectorFormulaManager();
        }
        catch (UnsupportedOperationException e) {
            this.bvmgr = null;
        }
        try {
            this.qmgr = this.mgr.getQuantifiedFormulaManager();
        }
        catch (UnsupportedOperationException e) {
            this.qmgr = null;
        }
        try {
            this.amgr = this.mgr.getArrayFormulaManager();
        }
        catch (UnsupportedOperationException e) {
            this.amgr = null;
        }
        try {
            this.fpmgr = this.mgr.getFloatingPointFormulaManager();
        }
        catch (UnsupportedOperationException e) {
            this.fpmgr = null;
        }
    }

    @After
    public final void closeSolver() {
        if (this.context != null) {
            this.context.close();
        }
    }

    protected final void requireRationals() {
        TruthJUnit.assume().withMessage("Solver %s does not support the theory of rationals", new Object[]{this.solverToUse()}).that((Object)this.rmgr).isNotNull();
    }

    protected final void requireBitvectors() {
        TruthJUnit.assume().withMessage("Solver %s does not support the theory of bitvectors", new Object[]{this.solverToUse()}).that((Object)this.bvmgr).isNotNull();
    }

    protected final void requireQuantifiers() {
        TruthJUnit.assume().withMessage("Solver %s does not support quantifiers", new Object[]{this.solverToUse()}).that((Object)this.qmgr).isNotNull();
    }

    protected final void requireArrays() {
        TruthJUnit.assume().withMessage("Solver %s does not support the theory of arrays", new Object[]{this.solverToUse()}).that((Object)this.amgr).isNotNull();
    }

    protected final void requireFloats() {
        TruthJUnit.assume().withMessage("Solver %s does not support the theory of floats", new Object[]{this.solverToUse()}).that((Object)this.fpmgr).isNotNull();
    }

    protected final void requireOptimization() {
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.MATHSAT5);
        try {
            this.context.newOptimizationProverEnvironment(new SolverContext.ProverOptions[0]).close();
        }
        catch (UnsupportedOperationException e) {
            TruthJUnit.assume().withMessage("Solver %s does not support optimization", new Object[]{this.solverToUse()}).that((Throwable)e).isNull();
        }
    }

    protected final void requireInterpolation() {
        try {
            this.context.newProverEnvironmentWithInterpolation(new SolverContext.ProverOptions[0]).close();
        }
        catch (UnsupportedOperationException e) {
            TruthJUnit.assume().withMessage("Solver %s does not support interpolation", new Object[]{this.solverToUse()}).that((Throwable)e).isNull();
        }
    }

    @Deprecated
    protected final void requireFalse(String failureMessage) {
        TruthJUnit.assume().withMessage(failureMessage).fail();
    }

    protected final BooleanFormulaSubject assertThatFormula(BooleanFormula formula) {
        return (BooleanFormulaSubject)BooleanFormulaSubject.assertUsing(this.context).that((Object)formula);
    }

    protected final ProverEnvironmentSubject assertThatEnvironment(BasicProverEnvironment<?> prover) {
        return ProverEnvironmentSubject.assertThat(prover);
    }
}

