/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.junit.AssumptionViolatedException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.test.NonLinearArithmeticTest;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class NonLinearArithmeticWithModuloTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;
    @Parameterized.Parameter(value=1)
    public AbstractNumeralFormulaManager.NonLinearArithmetic nonLinearArithmetic;

    @Parameterized.Parameters(name="{0} {1}")
    public static Iterable<Object[]> getAllSolvers() {
        return (Iterable)Lists.cartesianProduct((List[])new List[]{Arrays.asList(SolverContextFactory.Solvers.values()), Arrays.asList(AbstractNumeralFormulaManager.NonLinearArithmetic.values())}).stream().map(e -> e.toArray()).collect(ImmutableList.toImmutableList());
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Override
    protected ConfigurationBuilder createTestConfigBuilder() {
        return super.createTestConfigBuilder().setOption("solver.nonLinearArithmetic", this.nonLinearArithmetic.name());
    }

    private NumeralFormula.IntegerFormula handleExpectedException(Supplier<NumeralFormula.IntegerFormula> supplier) {
        try {
            return supplier.get();
        }
        catch (UnsupportedOperationException e) {
            if (this.nonLinearArithmetic == AbstractNumeralFormulaManager.NonLinearArithmetic.USE && NonLinearArithmeticTest.SOLVER_WITHOUT_NONLINEAR_ARITHMETIC.contains((Object)this.solver)) {
                throw new AssumptionViolatedException("Expected UnsupportedOperationException was thrown correctly");
            }
            throw e;
        }
    }

    private void assertExpectedUnsatifiabilityForNonLinearArithmetic(BooleanFormula f) throws SolverException, InterruptedException {
        if (this.nonLinearArithmetic == AbstractNumeralFormulaManager.NonLinearArithmetic.USE || this.nonLinearArithmetic == AbstractNumeralFormulaManager.NonLinearArithmetic.APPROXIMATE_FALLBACK && !NonLinearArithmeticTest.SOLVER_WITHOUT_NONLINEAR_ARITHMETIC.contains((Object)this.solver)) {
            this.assertThatFormula(f).isUnsatisfiable();
        } else {
            this.assertThatFormula(f).isSatisfiable();
        }
    }

    @Test
    public void testModuloConstant() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a");
        BooleanFormula f = this.bmgr.and(this.imgr.equal(a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(3L)), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), this.handleExpectedException(() -> this.imgr.modulo(a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L)))));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testModuloConstantUnsatisfiable() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a");
        BooleanFormula f = this.bmgr.and(this.imgr.equal(a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L)), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), this.handleExpectedException(() -> this.imgr.modulo(a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(3L)))));
        if (this.solver == SolverContextFactory.Solvers.SMTINTERPOL && this.nonLinearArithmetic == AbstractNumeralFormulaManager.NonLinearArithmetic.APPROXIMATE_FALLBACK) {
            this.assertThatFormula(f).isUnsatisfiable();
        } else {
            this.assertExpectedUnsatifiabilityForNonLinearArithmetic(f);
        }
    }

    @Test
    public void testModulo() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a");
        BooleanFormula f = this.bmgr.and(this.imgr.equal(a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L)), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), this.handleExpectedException(() -> this.imgr.modulo((NumeralFormula.IntegerFormula)this.imgr.makeNumber(3L), a))));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testModuloUnsatisfiable() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a");
        BooleanFormula f = this.bmgr.and(this.imgr.equal(a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(3L)), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), this.handleExpectedException(() -> this.imgr.modulo((NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L), a))));
        this.assertExpectedUnsatifiabilityForNonLinearArithmetic(f);
    }
}

