/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.base.Throwables;
import com.google.common.truth.ExpectFailure;
import com.google.common.truth.SimpleSubjectBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.BooleanFormulaSubject;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class BooleanFormulaSubjectTest
extends SolverBasedTest0 {
    @Parameterized.Parameter
    public SolverContextFactory.Solvers solver;
    private BooleanFormula simpleFormula;
    private BooleanFormula contradiction;
    private BooleanFormula tautology;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Before
    public void setupFormulas() {
        this.simpleFormula = this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("a"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L));
        this.contradiction = this.bmgr.and(this.simpleFormula, this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("a"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L)));
        this.tautology = this.bmgr.or(this.simpleFormula, this.bmgr.not(this.simpleFormula));
    }

    @Test
    public void testIsTriviallySatisfiableYes() throws SolverException, InterruptedException {
        this.assertThatFormula(this.bmgr.makeTrue()).isSatisfiable();
    }

    @Test
    public void testIsTriviallySatisfiableNo() {
        AssertionError failure = this.expectFailure(whenTesting -> ((BooleanFormulaSubject)whenTesting.that((Object)this.bmgr.makeFalse())).isSatisfiable());
        ExpectFailure.assertThat((AssertionError)failure).factValue("but was").isEqualTo((Object)"trivially unsatisfiable");
    }

    @Test
    public void testIsSatisfiableYes() throws SolverException, InterruptedException {
        this.assertThatFormula(this.simpleFormula).isSatisfiable();
    }

    @Test
    public void testIsSatisfiableNo() {
        AssertionError failure = this.expectFailure(whenTesting -> ((BooleanFormulaSubject)whenTesting.that((Object)this.contradiction)).isSatisfiable());
        ExpectFailure.assertThat((AssertionError)failure).factValue("which has unsat core").isNotEmpty();
    }

    @Test
    public void testIsTriviallyUnSatisfiableYes() throws SolverException, InterruptedException {
        this.assertThatFormula(this.bmgr.makeFalse()).isUnsatisfiable();
    }

    @Test
    public void testIsTriviallyUnSatisfiableNo() {
        AssertionError failure = this.expectFailure(whenTesting -> ((BooleanFormulaSubject)whenTesting.that((Object)this.bmgr.makeTrue())).isUnsatisfiable());
        ExpectFailure.assertThat((AssertionError)failure).factValue("but was").isEqualTo((Object)"trivially satisfiable");
    }

    @Test
    public void testIsUnsatisfiableYes() throws SolverException, InterruptedException {
        this.assertThatFormula(this.contradiction).isUnsatisfiable();
    }

    @Test
    public void testIsUnsatisfiableNo() {
        AssertionError failure = this.expectFailure(whenTesting -> ((BooleanFormulaSubject)whenTesting.that((Object)this.simpleFormula)).isUnsatisfiable());
        ExpectFailure.assertThat((AssertionError)failure).factValue("which has model").isNotEmpty();
    }

    @Test
    public void testIsTriviallyTautologicalYes() throws SolverException, InterruptedException {
        this.assertThatFormula(this.bmgr.makeTrue()).isTautological();
    }

    @Test
    public void testIsTriviallyTautologicalNo() {
        AssertionError failure = this.expectFailure(whenTesting -> ((BooleanFormulaSubject)whenTesting.that((Object)this.bmgr.makeFalse())).isTautological());
        ExpectFailure.assertThat((AssertionError)failure).factValue("but was").isEqualTo((Object)"trivially unsatisfiable");
    }

    @Test
    public void testIsTautologicalYes() throws SolverException, InterruptedException {
        this.assertThatFormula(this.tautology).isTautological();
    }

    @Test
    public void testIsTautologicalNo1() {
        AssertionError failure = this.expectFailure(whenTesting -> ((BooleanFormulaSubject)whenTesting.that((Object)this.simpleFormula)).isTautological());
        ExpectFailure.assertThat((AssertionError)failure).factValue("which has model").isNotEmpty();
    }

    @Test
    public void testIsTautologicalNo2() {
        AssertionError failure = this.expectFailure(whenTesting -> ((BooleanFormulaSubject)whenTesting.that((Object)this.contradiction)).isTautological());
        ExpectFailure.assertThat((AssertionError)failure).factValue("which has model").isNotEmpty();
    }

    @Test
    public void testIsEquivalentToYes() throws SolverException, InterruptedException {
        BooleanFormula simpleFormula2 = this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("a"), (NumeralFormula.IntegerFormula)this.imgr.add((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
        this.assertThatFormula(this.simpleFormula).isEquivalentTo(simpleFormula2);
    }

    @Test
    public void testIsEquivalentToNo() {
        AssertionError failure = this.expectFailure(whenTesting -> ((BooleanFormulaSubject)whenTesting.that((Object)this.simpleFormula)).isEquivalentTo(this.tautology));
        ExpectFailure.assertThat((AssertionError)failure).factValue("which has model").isNotEmpty();
    }

    @Test
    public void testIsEquisatisfiableToYes() throws SolverException, InterruptedException {
        this.assertThatFormula(this.simpleFormula).isEquisatisfiableTo(this.tautology);
    }

    @Test
    public void testIsEquisatisfiableoNo() {
        BooleanFormula simpleFormula2 = this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("a"), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("2"));
        AssertionError failure = this.expectFailure(whenTesting -> ((BooleanFormulaSubject)whenTesting.that((Object)this.simpleFormula)).isEquisatisfiableTo(simpleFormula2));
        ExpectFailure.assertThat((AssertionError)failure).factValue("which has model").isNotEmpty();
    }

    @Test
    public void testImpliesYes() throws SolverException, InterruptedException {
        this.assertThatFormula(this.simpleFormula).implies(this.tautology);
    }

    @Test
    public void testImpliesNo() {
        AssertionError failure = this.expectFailure(whenTesting -> ((BooleanFormulaSubject)whenTesting.that((Object)this.tautology)).implies(this.simpleFormula));
        ExpectFailure.assertThat((AssertionError)failure).factValue("which has model").isNotEmpty();
    }

    private AssertionError expectFailure(ExpectFailureCallback expectFailureCallback) {
        return ExpectFailure.expectFailureAbout(BooleanFormulaSubject.booleanFormulasOf(this.context), (ExpectFailure.SimpleSubjectBuilderCallback)expectFailureCallback);
    }

    private static interface ExpectFailureCallback
    extends ExpectFailure.SimpleSubjectBuilderCallback<BooleanFormulaSubject, BooleanFormula> {
        public void invokeAssertionUnchecked(SimpleSubjectBuilder<BooleanFormulaSubject, BooleanFormula> var1) throws Exception;

        default public void invokeAssertion(SimpleSubjectBuilder<BooleanFormulaSubject, BooleanFormula> pWhenTesting) {
            try {
                this.invokeAssertionUnchecked(pWhenTesting);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

