/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.z3;

import com.google.common.base.Preconditions;
import com.microsoft.z3.Native;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_lbool;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.solvers.z3.Z3AbstractProver;
import org.sosy_lab.java_smt.solvers.z3.Z3Formula;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaCreator;
import org.sosy_lab.java_smt.solvers.z3.Z3SolverException;

class Z3OptimizationProver
extends Z3AbstractProver<Void>
implements OptimizationProverEnvironment {
    private final LogManager logger;
    private final long z3optSolver;

    Z3OptimizationProver(Z3FormulaCreator creator, LogManager pLogger, long z3params, FormulaManager pMgr, Set<SolverContext.ProverOptions> pOptions) {
        super(creator, z3params, pMgr, pOptions);
        this.z3optSolver = Native.mkOptimize((long)this.z3context);
        Native.optimizeIncRef((long)this.z3context, (long)this.z3optSolver);
        this.logger = pLogger;
    }

    @Override
    public @Nullable Void addConstraint(BooleanFormula constraint) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long z3Constraint = this.creator.extractInfo(constraint);
        Native.optimizeAssert((long)this.z3context, (long)this.z3optSolver, (long)z3Constraint);
        return null;
    }

    @Override
    public int maximize(Formula objective) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Z3Formula z3Objective = (Z3Formula)objective;
        return Native.optimizeMaximize((long)this.z3context, (long)this.z3optSolver, (long)z3Objective.getFormulaInfo());
    }

    @Override
    public int minimize(Formula objective) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Z3Formula z3Objective = (Z3Formula)objective;
        return Native.optimizeMinimize((long)this.z3context, (long)this.z3optSolver, (long)z3Objective.getFormulaInfo());
    }

    @Override
    public OptimizationProverEnvironment.OptStatus check() throws InterruptedException, Z3SolverException {
        int status;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        try {
            status = Native.optimizeCheck((long)this.z3context, (long)this.z3optSolver);
        }
        catch (Z3Exception ex) {
            throw this.creator.handleZ3Exception(ex);
        }
        if (status == Z3_lbool.Z3_L_FALSE.toInt()) {
            return OptimizationProverEnvironment.OptStatus.UNSAT;
        }
        if (status == Z3_lbool.Z3_L_UNDEF.toInt()) {
            this.creator.shutdownNotifier.shutdownIfNecessary();
            this.logger.log(Level.INFO, new Object[]{"Solver returned an unknown status, explanation: ", Native.optimizeGetReasonUnknown((long)this.z3context, (long)this.z3optSolver)});
            return OptimizationProverEnvironment.OptStatus.UNDEF;
        }
        return OptimizationProverEnvironment.OptStatus.OPT;
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Native.optimizePush((long)this.z3context, (long)this.z3optSolver);
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Native.optimizePop((long)this.z3context, (long)this.z3optSolver);
    }

    @Override
    public boolean isUnsat() throws Z3SolverException, InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return this.check() == OptimizationProverEnvironment.OptStatus.UNSAT;
    }

    @Override
    public Optional<Rational> upper(int handle, Rational epsilon) {
        return this.round(handle, epsilon, Native::optimizeGetUpperAsVector);
    }

    @Override
    public Optional<Rational> lower(int handle, Rational epsilon) {
        return this.round(handle, epsilon, Native::optimizeGetLowerAsVector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Rational> round(int handle, Rational epsilon, RoundingFunction direction) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long vector = direction.round(this.z3context, this.z3optSolver, handle);
        Native.astVectorIncRef((long)this.z3context, (long)vector);
        assert (Native.astVectorSize((long)this.z3context, (long)vector) == 3);
        long inf = Native.astVectorGet((long)this.z3context, (long)vector, (int)0);
        Native.incRef((long)this.z3context, (long)inf);
        long value = Native.astVectorGet((long)this.z3context, (long)vector, (int)1);
        Native.incRef((long)this.z3context, (long)value);
        long eps = Native.astVectorGet((long)this.z3context, (long)vector, (int)2);
        Native.incRef((long)this.z3context, (long)eps);
        Native.IntPtr ptr = new Native.IntPtr();
        boolean status = Native.getNumeralInt((long)this.z3context, (long)inf, (Native.IntPtr)ptr);
        assert (status);
        if (ptr.value != 0) {
            return Optional.empty();
        }
        Rational v = Rational.ofString((String)Native.getNumeralString((long)this.z3context, (long)value));
        status = Native.getNumeralInt((long)this.z3context, (long)eps, (Native.IntPtr)ptr);
        assert (status);
        try {
            Optional<Rational> optional = Optional.of(v.plus(epsilon.times(Rational.of((long)ptr.value))));
            return optional;
        }
        finally {
            Native.astVectorDecRef((long)this.z3context, (long)vector);
            Native.decRef((long)this.z3context, (long)inf);
            Native.decRef((long)this.z3context, (long)value);
            Native.decRef((long)this.z3context, (long)eps);
        }
    }

    @Override
    protected long getZ3Model() {
        return Native.optimizeGetModel((long)this.z3context, (long)this.z3optSolver);
    }

    @Override
    protected void assertContraint(long negatedModel) {
        Native.optimizeAssert((long)this.z3context, (long)this.z3optSolver, (long)negatedModel);
    }

    void setParam(String key, String value) {
        long keySymbol = Native.mkStringSymbol((long)this.z3context, (String)key);
        long valueSymbol = Native.mkStringSymbol((long)this.z3context, (String)value);
        long params = Native.mkParams((long)this.z3context);
        Native.paramsSetSymbol((long)this.z3context, (long)params, (long)keySymbol, (long)valueSymbol);
        Native.optimizeSetParams((long)this.z3context, (long)this.z3optSolver, (long)params);
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        throw new UnsupportedOperationException("unsat core computation is not available for optimization prover environment.");
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException("unsat core computation is not available for optimization prover environment.");
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Native.optimizeDecRef((long)this.z3context, (long)this.z3optSolver);
        this.closed = true;
    }

    @Override
    public String toString() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return Native.optimizeToString((long)this.z3context, (long)this.z3optSolver);
    }

    private static interface RoundingFunction {
        public long round(long var1, long var3, int var5);
    }
}

