/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.princess;

import ap.SimpleAPI;
import ap.parser.IAtom;
import ap.parser.IBinFormula;
import ap.parser.IBinJunctor;
import ap.parser.IConstant;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFunApp;
import ap.parser.IIntLit;
import ap.parser.ITerm;
import ap.types.Sort;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.basicimpl.AbstractModel;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.solvers.princess.PrincessEnvironment;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.Map;
import scala.collection.Seq;

class PrincessModel
extends AbstractModel.CachingAbstractModel<IExpression, Sort, PrincessEnvironment> {
    private final SimpleAPI.PartialModel model;

    PrincessModel(SimpleAPI.PartialModel partialModel, FormulaCreator<IExpression, Sort, PrincessEnvironment, ?> creator) {
        super(creator);
        this.model = partialModel;
    }

    @Override
    protected ImmutableList<Model.ValueAssignment> toList() {
        Map interpretation = this.model.interpretation();
        java.util.Map<IIntLit, ITerm> arrays = this.getArrayAddresses((Map<IExpression, IExpression>)interpretation);
        ImmutableSet.Builder assignments = ImmutableSet.builder();
        for (Tuple2 entry : JavaConversions.asJavaIterable((Iterable)interpretation)) {
            Model.ValueAssignment assignment = this.getAssignment((IExpression)entry._1, (IExpression)entry._2, arrays);
            if (assignment == null) continue;
            assignments.add((Object)assignment);
        }
        return assignments.build().asList();
    }

    private java.util.Map<IIntLit, ITerm> getArrayAddresses(Map<IExpression, IExpression> interpretation) {
        HashMap<IIntLit, ITerm> arrays = new HashMap<IIntLit, ITerm>();
        for (Tuple2 entry : JavaConversions.asJavaIterable(interpretation)) {
            if (!(entry._1 instanceof IConstant)) continue;
            IConstant maybeArray = (IConstant)entry._1;
            if (!((PrincessEnvironment)this.creator.getEnv()).hasArrayType((IExpression)maybeArray) || !(entry._2 instanceof IIntLit)) continue;
            arrays.put((IIntLit)entry._2, (ITerm)maybeArray);
        }
        return arrays;
    }

    private @Nullable Model.ValueAssignment getAssignment(IExpression key, IExpression value, java.util.Map<IIntLit, ITerm> pArrays) {
        IBinFormula fAssignment;
        String name;
        IExpression fKey;
        IExpression fValue = value;
        Collection<Object> argumentInterpretations = Collections.emptyList();
        if (key instanceof IAtom) {
            fKey = key;
            name = key.toString();
            fAssignment = new IBinFormula(IBinJunctor.Eqv(), (IFormula)((IAtom)key), (IFormula)fValue);
        } else if (key instanceof IConstant) {
            if (((PrincessEnvironment)this.creator.getEnv()).hasArrayType(key)) {
                return null;
            }
            fKey = key;
            name = key.toString();
            fAssignment = ((IConstant)key).$eq$eq$eq((ITerm)fValue);
        } else if (key instanceof IFunApp) {
            IFunApp cKey = (IFunApp)key;
            switch (cKey.fun().name()) {
                case "select": {
                    ITerm arrayId = (ITerm)cKey.args().apply(0);
                    ITerm arrayIndex = (ITerm)cKey.args().apply(1);
                    ITerm arrayF = pArrays.get(arrayId);
                    if (arrayF == null) {
                        return null;
                    }
                    fKey = ((PrincessEnvironment)this.creator.getEnv()).makeSelect(arrayF, arrayIndex);
                    name = arrayF.toString();
                    argumentInterpretations = Collections.singleton(this.creator.convertValue(arrayIndex));
                    break;
                }
                case "store": {
                    ITerm arrayId2 = (ITerm)value;
                    ITerm arrayIndex2 = (ITerm)cKey.args().apply(1);
                    ITerm arrayContent = (ITerm)cKey.args().apply(2);
                    ITerm arrayF2 = pArrays.get(arrayId2);
                    if (arrayF2 == null) {
                        return null;
                    }
                    fKey = ((PrincessEnvironment)this.creator.getEnv()).makeSelect(arrayF2, arrayIndex2);
                    fValue = arrayContent;
                    name = arrayF2.toString();
                    argumentInterpretations = Collections.singleton(this.creator.convertValue(arrayIndex2));
                    break;
                }
                default: {
                    argumentInterpretations = new ArrayList();
                    for (ITerm arg : JavaConversions.seqAsJavaList((Seq)cKey.args())) {
                        argumentInterpretations.add(this.creator.convertValue(arg));
                    }
                    fKey = cKey;
                    name = cKey.fun().name();
                }
            }
            fAssignment = ((ITerm)fKey).$eq$eq$eq((ITerm)fValue);
        } else {
            throw new AssertionError((Object)String.format("unknown type of key: %s -> %s (%s)", key, value, key.getClass()));
        }
        return new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(fKey), this.creator.encapsulateWithTypeOf(fValue), this.creator.encapsulateBoolean(fAssignment), name, this.creator.convertValue(fValue), argumentInterpretations);
    }

    @Override
    public String toString() {
        return this.model.toString();
    }

    @Override
    public void close() {
    }

    @Override
    protected IExpression evalImpl(IExpression formula) {
        if (formula instanceof ITerm) {
            Option out = this.model.evalToTerm((ITerm)formula);
            return out.isEmpty() ? null : (IExpression)out.get();
        }
        if (formula instanceof IFormula) {
            Option out = this.model.evalExpression(formula);
            return out.isEmpty() ? null : (IExpression)out.get();
        }
        throw new AssertionError((Object)("unexpected formula: " + formula));
    }
}

