/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.visitors.FormulaTransformationVisitor;

public class HoudiniApp {
    private final FormulaManager fmgr;
    private final BooleanFormulaManager bfmgr;
    private final SolverContext context;

    public static void main(String ... args) throws InvalidConfigurationException, SolverException, InterruptedException {
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = BasicLogManager.create((Configuration)config);
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        for (SolverContextFactory.Solvers solver : SolverContextFactory.Solvers.values()) {
            logger.log(Level.INFO, new Object[]{"using solver", solver});
            try (SolverContext solverContext = SolverContextFactory.createSolverContext(config, logger, notifier, solver);){
                HoudiniApp houdini = new HoudiniApp(solverContext);
                IntegerFormulaManager ifmgr = solverContext.getFormulaManager().getIntegerFormulaManager();
                NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)ifmgr.makeVariable("X");
                NumeralFormula.IntegerFormula xPrimed = (NumeralFormula.IntegerFormula)ifmgr.makeVariable("X'");
                NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)ifmgr.makeNumber(1L);
                ImmutableList lemmas = ImmutableList.of((Object)ifmgr.greaterThan(x, one), (Object)ifmgr.lessThan(x, one));
                BooleanFormula transition = ifmgr.equal(xPrimed, (NumeralFormula.IntegerFormula)ifmgr.add(x, one));
                List<BooleanFormula> result = houdini.houdini((List<BooleanFormula>)lemmas, transition);
                logger.log(Level.INFO, new Object[]{"Houdini returned", result});
            }
            catch (UnsatisfiedLinkError | InvalidConfigurationException e) {
                logger.logUserException(Level.INFO, e, "Solver " + (Object)((Object)solver) + " is not available.");
            }
        }
    }

    public HoudiniApp(SolverContext solverContext) {
        this.context = solverContext;
        this.fmgr = this.context.getFormulaManager();
        this.bfmgr = this.context.getFormulaManager().getBooleanFormulaManager();
    }

    private BooleanFormula getSelectorVar(int idx) {
        return this.bfmgr.makeVariable("SEL_" + idx);
    }

    private BooleanFormula prime(BooleanFormula input) {
        return this.fmgr.transformRecursively(input, new FormulaTransformationVisitor(this.fmgr){

            @Override
            public Formula visitFreeVariable(Formula f, String name) {
                return HoudiniApp.this.fmgr.makeVariable(HoudiniApp.this.fmgr.getFormulaType(f), name + "'");
            }
        });
    }

    public List<BooleanFormula> houdini(List<BooleanFormula> lemmas, BooleanFormula transition) throws SolverException, InterruptedException {
        ArrayList<BooleanFormula> annotated = new ArrayList<BooleanFormula>();
        ArrayList<BooleanFormula> annotatedPrimes = new ArrayList<BooleanFormula>();
        HashMap<Integer, BooleanFormula> indexed = new HashMap<Integer, BooleanFormula>();
        for (int i = 0; i < lemmas.size(); ++i) {
            BooleanFormula lemma = lemmas.get(i);
            BooleanFormula primed = this.prime(lemma);
            annotated.add(this.bfmgr.or(this.getSelectorVar(i), lemma));
            annotatedPrimes.add(this.bfmgr.or(this.getSelectorVar(i), primed));
            indexed.put(i, lemma);
        }
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.addConstraint(transition);
            prover.addConstraint(this.bfmgr.and(annotated));
            prover.addConstraint(this.bfmgr.not(this.bfmgr.and(annotatedPrimes)));
            while (!prover.isUnsat()) {
                Model m = prover.getModel();
                Throwable throwable = null;
                try {
                    for (int i = 0; i < annotatedPrimes.size(); ++i) {
                        BooleanFormula annotatedPrime = (BooleanFormula)annotatedPrimes.get(i);
                        if (m.evaluate(annotatedPrime).booleanValue()) continue;
                        prover.addConstraint(this.getSelectorVar(i));
                        indexed.remove(i);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (m == null) continue;
                    HoudiniApp.$closeResource(throwable, m);
                }
            }
        }
        return new ArrayList<BooleanFormula>(indexed.values());
    }
}

