/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;
import org.sosy_lab.java_smt.utils.AutoValue_UfElimination_UninterpretedFunctionApplication;

public class UfElimination {
    private static final UniqueIdGenerator UNIQUE_ID_GENERATOR = new UniqueIdGenerator();
    private static final String prefix = "__UF_fresh_";
    private final BooleanFormulaManager bfmgr;
    private final FormulaManager fmgr;

    UfElimination(FormulaManager pFmgr) {
        this.bfmgr = pFmgr.getBooleanFormulaManager();
        this.fmgr = pFmgr;
    }

    public BooleanFormula eliminateUfs(BooleanFormula f) {
        Result result = this.eliminateUfs(f, Result.empty(this.fmgr));
        return this.fmgr.getBooleanFormulaManager().and(result.getFormula(), result.getConstraints());
    }

    public Result eliminateUfs(BooleanFormula pF, Result pOtherResult) {
        Preconditions.checkArgument((!this.isQuantified(pF) ? 1 : 0) != 0);
        BooleanFormula f = !pOtherResult.getSubstitution().isEmpty() ? this.fmgr.substitute(pF, pOtherResult.getSubstitution()) : pF;
        int depth = this.getNestingDepthOfUfs(f);
        Multimap<FunctionDeclaration<?>, UninterpretedFunctionApplication> ufs = this.findUFs(f);
        ufs = this.merge(ufs, pOtherResult);
        ImmutableMap.Builder substitutionsBuilder = ImmutableMap.builder();
        ArrayList<BooleanFormula> extraConstraints = new ArrayList();
        for (FunctionDeclaration function : ufs.keySet()) {
            ArrayList applications = new ArrayList(ufs.get((Object)function));
            for (int idx1 = 0; idx1 < applications.size(); ++idx1) {
                UninterpretedFunctionApplication application = (UninterpretedFunctionApplication)applications.get(idx1);
                Formula uf = application.getFormula();
                List<Formula> args = application.getArguments();
                Formula substitution = application.getSubstitution();
                substitutionsBuilder.put((Object)uf, (Object)substitution);
                for (int idx2 = idx1 + 1; idx2 < applications.size(); ++idx2) {
                    UninterpretedFunctionApplication application2 = (UninterpretedFunctionApplication)applications.get(idx2);
                    List<Formula> otherArgs = application2.getArguments();
                    Verify.verify((args.size() == otherArgs.size() ? 1 : 0) != 0);
                    ArrayList<BooleanFormula> argumentEquality = new ArrayList<BooleanFormula>(args.size());
                    for (int i = 0; i < args.size(); ++i) {
                        Formula arg1 = args.get(i);
                        Formula arg2 = otherArgs.get(i);
                        argumentEquality.add(this.makeEqual(arg1, arg2));
                    }
                    BooleanFormula functionEquality = this.makeEqual(substitution, application2.getSubstitution());
                    extraConstraints.add(this.bfmgr.implication(this.bfmgr.and(argumentEquality), functionEquality));
                }
            }
        }
        ImmutableMap substitutions = substitutionsBuilder.build();
        BooleanFormula formulaWithoutUFs = this.fmgr.substitute(f, (Map<? extends Formula, ? extends Formula>)substitutions);
        for (int i = 0; i < depth; ++i) {
            extraConstraints = extraConstraints.stream().map(c -> this.fmgr.substitute(c, (Map<? extends Formula, ? extends Formula>)substitutions)).collect(Collectors.toList());
        }
        Map otherSubstitution = Maps.difference(pOtherResult.getSubstitution(), (Map)substitutions).entriesOnlyOnLeft();
        substitutionsBuilder.putAll(otherSubstitution);
        ImmutableMap allSubstitutions = substitutionsBuilder.build();
        BooleanFormula constraints = this.bfmgr.and(extraConstraints);
        return new Result(formulaWithoutUFs, constraints, (ImmutableMap<Formula, Formula>)allSubstitutions, ImmutableMultimap.copyOf(ufs));
    }

    private Multimap<FunctionDeclaration<?>, UninterpretedFunctionApplication> merge(Multimap<FunctionDeclaration<?>, UninterpretedFunctionApplication> pUfs, Result pPreviousResult) {
        for (Map.Entry ufInOtherFormula : pPreviousResult.getUfs().entries()) {
            if (!pUfs.containsKey(ufInOtherFormula.getKey())) continue;
            pUfs.put((Object)((FunctionDeclaration)ufInOtherFormula.getKey()), (Object)((UninterpretedFunctionApplication)ufInOtherFormula.getValue()));
        }
        return pUfs;
    }

    @CheckReturnValue
    private BooleanFormula makeEqual(Formula pLhs, Formula pRhs) {
        BooleanFormula t;
        if (pLhs instanceof BooleanFormula && pRhs instanceof BooleanFormula) {
            t = this.bfmgr.equivalence((BooleanFormula)pLhs, (BooleanFormula)pRhs);
        } else if (pLhs instanceof NumeralFormula.IntegerFormula && pRhs instanceof NumeralFormula.IntegerFormula) {
            t = this.fmgr.getIntegerFormulaManager().equal((NumeralFormula.IntegerFormula)pLhs, (NumeralFormula.IntegerFormula)pRhs);
        } else if (pLhs instanceof NumeralFormula && pRhs instanceof NumeralFormula) {
            t = this.fmgr.getRationalFormulaManager().equal((NumeralFormula)pLhs, (NumeralFormula)pRhs);
        } else if (pLhs instanceof BitvectorFormula) {
            t = this.fmgr.getBitvectorFormulaManager().equal((BitvectorFormula)pLhs, (BitvectorFormula)pRhs);
        } else if (pLhs instanceof FloatingPointFormula && pRhs instanceof FloatingPointFormula) {
            FloatingPointFormulaManager fpfmgr = this.fmgr.getFloatingPointFormulaManager();
            t = fpfmgr.equalWithFPSemantics((FloatingPointFormula)pLhs, (FloatingPointFormula)pRhs);
        } else if (pLhs instanceof ArrayFormula && pRhs instanceof ArrayFormula) {
            ArrayFormula lhs = (ArrayFormula)pLhs;
            ArrayFormula rhs = (ArrayFormula)pRhs;
            t = this.fmgr.getArrayFormulaManager().equivalence(lhs, rhs);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return t;
    }

    private boolean isQuantified(Formula f) {
        final AtomicBoolean result = new AtomicBoolean();
        this.fmgr.visitRecursively(f, (FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>(){

            @Override
            protected TraversalProcess visitDefault(Formula pF) {
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitQuantifier(BooleanFormula pF, QuantifiedFormulaManager.Quantifier pQ, List<Formula> pBoundVariables, BooleanFormula pBody) {
                result.set(true);
                return TraversalProcess.ABORT;
            }
        });
        return result.get();
    }

    private int getNestingDepthOfUfs(Formula f) {
        return this.fmgr.visit(f, new DefaultFormulaVisitor<Integer>(){

            @Override
            protected Integer visitDefault(Formula pF) {
                return 0;
            }

            @Override
            public Integer visitFunction(Formula pF, List<Formula> pArgs, FunctionDeclaration<?> pFunctionDeclaration) {
                int depthOfArgs = pArgs.stream().mapToInt(f -> UfElimination.this.fmgr.visit((Formula)f, this)).max().orElse(0);
                if (pFunctionDeclaration.getKind() == FunctionDeclarationKind.UF) {
                    return depthOfArgs + 1;
                }
                return depthOfArgs;
            }

            @Override
            public Integer visitQuantifier(BooleanFormula pF, QuantifiedFormulaManager.Quantifier pQ, List<Formula> pBoundVariables, BooleanFormula pBody) {
                return UfElimination.this.fmgr.visit(pBody, this);
            }
        });
    }

    private Multimap<FunctionDeclaration<?>, UninterpretedFunctionApplication> findUFs(Formula f) {
        HashMultimap ufs = HashMultimap.create();
        this.fmgr.visitRecursively(f, (FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>((Multimap)ufs){
            final /* synthetic */ Multimap val$ufs;
            {
                this.val$ufs = multimap;
            }

            @Override
            protected TraversalProcess visitDefault(Formula f) {
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitFunction(Formula f, List<Formula> args, FunctionDeclaration<?> decl) {
                if (decl.getKind() == FunctionDeclarationKind.UF) {
                    Formula substitution = UfElimination.this.freshUfReplaceVariable(decl.getType());
                    this.val$ufs.put(decl, (Object)UninterpretedFunctionApplication.create(f, args, substitution));
                }
                return TraversalProcess.CONTINUE;
            }
        });
        return ufs;
    }

    private Formula freshUfReplaceVariable(FormulaType<?> pType) {
        return this.fmgr.makeVariable(pType, prefix + UNIQUE_ID_GENERATOR.getFreshId());
    }

    static abstract class UninterpretedFunctionApplication {
        UninterpretedFunctionApplication() {
        }

        static UninterpretedFunctionApplication create(Formula pF, List<Formula> pArguments, Formula pSubstitution) {
            return new AutoValue_UfElimination_UninterpretedFunctionApplication(pF, pArguments, pSubstitution);
        }

        abstract Formula getFormula();

        abstract List<Formula> getArguments();

        abstract Formula getSubstitution();
    }

    public static class Result {
        private final BooleanFormula formula;
        private final BooleanFormula constraints;
        private final ImmutableMap<Formula, Formula> substitutions;
        private final ImmutableMultimap<FunctionDeclaration<?>, UninterpretedFunctionApplication> ufs;

        public static Result empty(FormulaManager pFormulaManager) {
            BooleanFormula trueFormula = pFormulaManager.getBooleanFormulaManager().makeTrue();
            return new Result(trueFormula, trueFormula, (ImmutableMap<Formula, Formula>)ImmutableMap.of(), ImmutableMultimap.of());
        }

        Result(BooleanFormula pFormula, BooleanFormula pConstraints, ImmutableMap<Formula, Formula> pSubstitutions, ImmutableMultimap<FunctionDeclaration<?>, UninterpretedFunctionApplication> pUfs) {
            this.formula = (BooleanFormula)Preconditions.checkNotNull((Object)pFormula);
            this.constraints = (BooleanFormula)Preconditions.checkNotNull((Object)pConstraints);
            this.substitutions = (ImmutableMap)Preconditions.checkNotNull(pSubstitutions);
            this.ufs = (ImmutableMultimap)Preconditions.checkNotNull(pUfs);
        }

        public BooleanFormula getFormula() {
            return this.formula;
        }

        public BooleanFormula getConstraints() {
            return this.constraints;
        }

        public Map<Formula, Formula> getSubstitution() {
            return this.substitutions;
        }

        Multimap<FunctionDeclaration<?>, UninterpretedFunctionApplication> getUfs() {
            return this.ufs;
        }
    }
}

