/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class SolverFormulaWithAssumptionsTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    protected <T> InterpolatingProverEnvironment<T> newEnvironmentForTest() throws InvalidConfigurationException, SolverException, InterruptedException {
        try (InterpolatingProverEnvironment<?> env = this.context.newProverEnvironmentWithInterpolation();){
            env.isUnsatWithAssumptions((Collection<BooleanFormula>)ImmutableList.of());
        }
        catch (UnsupportedOperationException e) {
            TruthJUnit.assume().withFailureMessage("Solver " + (Object)((Object)this.solverToUse()) + " does not support assumption-solving").that((Throwable)e).isNull();
        }
        return this.context.newProverEnvironmentWithInterpolation();
    }

    @Test
    public <T> void basicAssumptionsTest() throws SolverException, InterruptedException, InvalidConfigurationException {
        this.requireInterpolation();
        NumeralFormula.IntegerFormula v1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("v1");
        NumeralFormula.IntegerFormula v2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("v2");
        BooleanFormula suffix1 = this.bmgr.makeVariable("suffix1");
        BooleanFormula suffix2 = this.bmgr.makeVariable("suffix2");
        BooleanFormula suffix3 = this.bmgr.makeVariable("suffix3");
        BooleanFormula term1 = this.bmgr.or(this.bmgr.and(this.imgr.equal(v1, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(BigDecimal.ONE)), this.bmgr.not(this.imgr.equal(v1, v2))), suffix1);
        BooleanFormula term2 = this.bmgr.or(this.imgr.equal(v2, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(BigDecimal.ONE)), suffix2);
        BooleanFormula term3 = this.bmgr.or(this.bmgr.not(this.imgr.equal(v1, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(BigDecimal.ONE))), suffix3);
        try (InterpolatingProverEnvironment<T> env = this.newEnvironmentForTest();){
            T firstPartForInterpolant = env.push(term1);
            env.push(term2);
            env.push(term3);
            Truth.assertThat((Boolean)env.isUnsatWithAssumptions((Collection<BooleanFormula>)ImmutableList.of((Object)this.bmgr.not(suffix1), (Object)this.bmgr.not(suffix2), (Object)suffix3))).isTrue();
            Truth.assertThat((String)env.getInterpolant(Collections.singletonList(firstPartForInterpolant)).toString()).doesNotContain((CharSequence)"suffix");
            Truth.assertThat((Boolean)env.isUnsatWithAssumptions((Collection<BooleanFormula>)ImmutableList.of((Object)this.bmgr.not(suffix1), (Object)this.bmgr.not(suffix3), (Object)suffix2))).isTrue();
            Truth.assertThat((String)env.getInterpolant(Collections.singletonList(firstPartForInterpolant)).toString()).doesNotContain((CharSequence)"suffix");
        }
    }

    @Test
    public <T> void assumptionsTest() throws SolverException, InterruptedException, InvalidConfigurationException {
        this.requireInterpolation();
        int n = 5;
        NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
        ArrayList<BooleanFormula> assignments = new ArrayList<BooleanFormula>();
        ArrayList<BooleanFormula> suffices = new ArrayList<BooleanFormula>();
        ArrayList<BooleanFormula> terms = new ArrayList<BooleanFormula>();
        for (int i = 0; i < n; ++i) {
            BooleanFormula a = this.imgr.equal(x, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(i));
            BooleanFormula suffix = this.bmgr.makeVariable("suffix" + i);
            assignments.add(a);
            suffices.add(suffix);
            terms.add(this.bmgr.or(a, suffix));
        }
        ArrayList<BooleanFormula> toCheckSat = new ArrayList<BooleanFormula>();
        ArrayList<BooleanFormula> toCheckUnsat = new ArrayList<BooleanFormula>();
        for (int i = 2; i < n; ++i) {
            try (InterpolatingProverEnvironment env = this.newEnvironmentForTest();){
                int j;
                ArrayList<T> ids = new ArrayList<T>();
                for (j = 0; j < i; ++j) {
                    ids.add(env.push((BooleanFormula)terms.get(j)));
                }
                Truth.assertThat((Boolean)env.isUnsatWithAssumptions(Lists.transform(suffices.subList(0, i + 1), this.bmgr::not))).isTrue();
                for (j = 0; j < i; ++j) {
                    BooleanFormula itp = env.getInterpolant(Collections.singletonList(ids.get(j)));
                    for (String var : this.mgr.extractVariables(itp).keySet()) {
                        Truth.assertThat((String)var).doesNotContain((CharSequence)"suffix");
                    }
                    BooleanFormula contra = itp;
                    for (int k = 0; k < i; ++k) {
                        if (k == j) continue;
                        contra = this.bmgr.and(contra, (BooleanFormula)assignments.get(k));
                    }
                    toCheckSat.add(this.bmgr.implication((BooleanFormula)assignments.get(j), itp));
                    toCheckUnsat.add(contra);
                }
            }
            for (BooleanFormula f : toCheckSat) {
                this.assertThatFormula(f).isSatisfiable();
            }
            for (BooleanFormula f : toCheckUnsat) {
                this.assertThatFormula(f).isUnsatisfiable();
            }
        }
    }
}

