/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class FormulaManagerTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void testEmptySubstitution() throws SolverException, InterruptedException {
        if (this.solverToUse().equals((Object)SolverContextFactory.Solvers.PRINCESS)) {
            this.requireFalse((Object)((Object)SolverContextFactory.Solvers.PRINCESS) + " fails.");
        }
        NumeralFormula.IntegerFormula variable1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable1");
        NumeralFormula.IntegerFormula variable2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable2");
        NumeralFormula.IntegerFormula variable3 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable3");
        NumeralFormula.IntegerFormula variable4 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable4");
        FunctionDeclaration<BooleanFormula> uf2Decl = this.fmgr.declareUF("uf", FormulaType.BooleanType, Lists.newArrayList((Object[])new FormulaType[]{FormulaType.IntegerType, FormulaType.IntegerType}));
        BooleanFormula f1 = this.fmgr.callUF(uf2Decl, Lists.newArrayList((Object[])new NumeralFormula.IntegerFormula[]{variable1, variable3}));
        BooleanFormula f2 = this.fmgr.callUF(uf2Decl, Lists.newArrayList((Object[])new NumeralFormula.IntegerFormula[]{variable2, variable4}));
        BooleanFormula input = this.bmgr.xor(f1, f2);
        BooleanFormula out = this.mgr.substitute(input, (Map<? extends Formula, ? extends Formula>)ImmutableMap.of());
        this.assertThatFormula(out).isEquivalentTo(input);
    }

    @Test
    public void testNoSubstitution() throws SolverException, InterruptedException {
        if (this.solverToUse().equals((Object)SolverContextFactory.Solvers.PRINCESS)) {
            this.requireFalse((Object)((Object)SolverContextFactory.Solvers.PRINCESS) + " fails.");
        }
        NumeralFormula.IntegerFormula variable1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable1");
        NumeralFormula.IntegerFormula variable2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable2");
        NumeralFormula.IntegerFormula variable3 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable3");
        NumeralFormula.IntegerFormula variable4 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable4");
        FunctionDeclaration<BooleanFormula> uf2Decl = this.fmgr.declareUF("uf", FormulaType.BooleanType, Lists.newArrayList((Object[])new FormulaType[]{FormulaType.IntegerType, FormulaType.IntegerType}));
        BooleanFormula f1 = this.fmgr.callUF(uf2Decl, Lists.newArrayList((Object[])new NumeralFormula.IntegerFormula[]{variable1, variable3}));
        BooleanFormula f2 = this.fmgr.callUF(uf2Decl, Lists.newArrayList((Object[])new NumeralFormula.IntegerFormula[]{variable2, variable4}));
        BooleanFormula input = this.bmgr.xor(f1, f2);
        ImmutableMap substitution = ImmutableMap.of((Object)this.bmgr.makeVariable("a"), (Object)this.bmgr.makeVariable("a1"), (Object)this.bmgr.makeVariable("b"), (Object)this.bmgr.makeVariable("b1"), (Object)this.bmgr.and(this.bmgr.makeVariable("c"), this.bmgr.makeVariable("d")), (Object)this.bmgr.makeVariable("e"));
        BooleanFormula out = this.mgr.substitute(input, (Map<? extends Formula, ? extends Formula>)substitution);
        this.assertThatFormula(out).isEquivalentTo(input);
    }

    @Test
    public void testSubstitution() throws SolverException, InterruptedException {
        BooleanFormula input = this.bmgr.or(this.bmgr.and(this.bmgr.makeVariable("a"), this.bmgr.makeVariable("b")), this.bmgr.and(this.bmgr.makeVariable("c"), this.bmgr.makeVariable("d")));
        BooleanFormula out = this.mgr.substitute(input, (Map<? extends Formula, ? extends Formula>)ImmutableMap.of((Object)this.bmgr.makeVariable("a"), (Object)this.bmgr.makeVariable("a1"), (Object)this.bmgr.makeVariable("b"), (Object)this.bmgr.makeVariable("b1"), (Object)this.bmgr.and(this.bmgr.makeVariable("c"), this.bmgr.makeVariable("d")), (Object)this.bmgr.makeVariable("e")));
        this.assertThatFormula(out).isEquivalentTo(this.bmgr.or(this.bmgr.and(this.bmgr.makeVariable("a1"), this.bmgr.makeVariable("b1")), this.bmgr.makeVariable("e")));
    }

    @Test
    public void testSubstitutionTwice() throws SolverException, InterruptedException {
        BooleanFormula input = this.bmgr.or(this.bmgr.and(this.bmgr.makeVariable("a"), this.bmgr.makeVariable("b")), this.bmgr.and(this.bmgr.makeVariable("c"), this.bmgr.makeVariable("d")));
        ImmutableMap substitution = ImmutableMap.of((Object)this.bmgr.makeVariable("a"), (Object)this.bmgr.makeVariable("a1"), (Object)this.bmgr.makeVariable("b"), (Object)this.bmgr.makeVariable("b1"), (Object)this.bmgr.and(this.bmgr.makeVariable("c"), this.bmgr.makeVariable("d")), (Object)this.bmgr.makeVariable("e"));
        BooleanFormula out = this.mgr.substitute(input, (Map<? extends Formula, ? extends Formula>)substitution);
        this.assertThatFormula(out).isEquivalentTo(this.bmgr.or(this.bmgr.and(this.bmgr.makeVariable("a1"), this.bmgr.makeVariable("b1")), this.bmgr.makeVariable("e")));
        BooleanFormula out2 = this.mgr.substitute(out, (Map<? extends Formula, ? extends Formula>)substitution);
        this.assertThatFormula(out2).isEquivalentTo(out);
    }

    @Test
    public void formulaEqualsAndHashCode() {
        FunctionDeclaration<NumeralFormula.IntegerFormula> f_b = this.fmgr.declareUF("f_b", FormulaType.IntegerType, FormulaType.IntegerType);
        new EqualsTester().addEqualityGroup(new Object[]{this.bmgr.makeBoolean(true)}).addEqualityGroup(new Object[]{this.bmgr.makeBoolean(false)}).addEqualityGroup(new Object[]{this.bmgr.makeVariable("bool_a")}).addEqualityGroup(new Object[]{this.imgr.makeVariable("int_a")}).addEqualityGroup(new Object[]{this.imgr.makeNumber(0.0), this.imgr.makeNumber(0L), this.imgr.makeNumber(BigInteger.ZERO), this.imgr.makeNumber(BigDecimal.ZERO), this.imgr.makeNumber("0")}).addEqualityGroup(new Object[]{this.imgr.makeNumber(1.0), this.imgr.makeNumber(1L), this.imgr.makeNumber(BigInteger.ONE), this.imgr.makeNumber(BigDecimal.ONE), this.imgr.makeNumber("1")}).addEqualityGroup(new Object[]{this.bmgr.makeVariable("bool_b"), this.bmgr.makeVariable("bool_b")}).addEqualityGroup(new Object[]{this.bmgr.and(this.bmgr.makeVariable("bool_a"), this.bmgr.makeVariable("bool_b")), this.bmgr.and(this.bmgr.makeVariable("bool_a"), this.bmgr.makeVariable("bool_b"))}).addEqualityGroup(new Object[]{this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_a")), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_a"))}).addEqualityGroup(new Object[]{this.fmgr.declareUF("f_a", FormulaType.IntegerType, FormulaType.IntegerType), this.fmgr.declareUF("f_a", FormulaType.IntegerType, FormulaType.IntegerType)}).addEqualityGroup(new Object[]{f_b}).addEqualityGroup(new Object[]{this.fmgr.callUF(f_b, (List<? extends Formula>)ImmutableList.of((Object)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L))))}).addEqualityGroup(new Object[]{this.fmgr.callUF(f_b, (List<? extends Formula>)ImmutableList.of((Object)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)))), this.fmgr.callUF(f_b, (List<? extends Formula>)ImmutableList.of((Object)((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L))))}).testEquals();
    }

    @Test
    public void variableNameExtractorTest() throws Exception {
        BooleanFormula constr = this.bmgr.or(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.subtract((NumeralFormula.IntegerFormula)this.imgr.add((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("z")), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L)), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y")), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("xx"), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("zz")));
        Truth.assertThat(this.mgr.extractVariables(constr).keySet()).containsExactly(new Object[]{"x", "y", "z", "xx", "zz"});
        Truth.assertThat(this.mgr.extractVariablesAndUFs(constr)).isEqualTo(this.mgr.extractVariables(constr));
    }

    @Test
    public void ufNameExtractorTest() throws Exception {
        BooleanFormula constraint = this.imgr.equal(this.fmgr.declareAndCallUF("uf1", FormulaType.IntegerType, (List<Formula>)ImmutableList.of(this.imgr.makeVariable("x"))), this.fmgr.declareAndCallUF("uf2", FormulaType.IntegerType, (List<Formula>)ImmutableList.of(this.imgr.makeVariable("y"))));
        Truth.assertThat(this.mgr.extractVariablesAndUFs(constraint).keySet()).containsExactly(new Object[]{"uf1", "uf2", "x", "y"});
        Truth.assertThat(this.mgr.extractVariables(constraint).keySet()).containsExactly(new Object[]{"x", "y"});
    }
}

