/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolEnvironment;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaCreator;

class SmtInterpolArrayFormulaManager
extends AbstractArrayFormulaManager<Term, Sort, SmtInterpolEnvironment, FunctionSymbol> {
    private final SmtInterpolEnvironment env;

    SmtInterpolArrayFormulaManager(SmtInterpolFormulaCreator pCreator) {
        super(pCreator);
        this.env = (SmtInterpolEnvironment)pCreator.getEnv();
    }

    @Override
    protected Term select(Term pArray, Term pIndex) {
        return this.env.term("select", pArray, pIndex);
    }

    @Override
    protected Term store(Term pArray, Term pIndex, Term pValue) {
        return this.env.term("store", pArray, pIndex, pValue);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> Term internalMakeArray(String pName, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        FormulaType.ArrayFormulaType<TI, TE> arrayFormulaType = FormulaType.getArrayType(pIndexType, pElementType);
        Sort smtInterpolArrayType = (Sort)this.toSolverType(arrayFormulaType);
        return (Term)this.getFormulaCreator().makeVariable(smtInterpolArrayType, pName);
    }

    @Override
    protected Term equivalence(Term pArray1, Term pArray2) {
        return this.env.term("=", pArray1, pArray2);
    }
}

