/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.princess;

import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.basicimpl.AbstractSolverContext;
import org.sosy_lab.java_smt.basicimpl.reusableStack.ReusableStackInterpolatingProver;
import org.sosy_lab.java_smt.basicimpl.reusableStack.ReusableStackTheoremProver;
import org.sosy_lab.java_smt.solvers.princess.PrincessArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessEnvironment;
import org.sosy_lab.java_smt.solvers.princess.PrincessFormulaCreator;
import org.sosy_lab.java_smt.solvers.princess.PrincessFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessIntegerFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessInterpolatingProver;
import org.sosy_lab.java_smt.solvers.princess.PrincessQuantifiedFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessTermType;
import org.sosy_lab.java_smt.solvers.princess.PrincessTheoremProver;
import org.sosy_lab.java_smt.solvers.princess.PrincessUFManager;

public final class PrincessSolverContext
extends AbstractSolverContext {
    private final PrincessFormulaManager manager;
    private final PrincessFormulaCreator creator;

    private PrincessSolverContext(PrincessFormulaManager manager, PrincessFormulaCreator creator) {
        super(manager);
        this.manager = manager;
        this.creator = creator;
    }

    public static SolverContext create(Configuration config, ShutdownNotifier pShutdownNotifier, @Nullable PathCounterTemplate pLogfileTemplate) throws InvalidConfigurationException {
        PrincessOptions options = new PrincessOptions(config);
        PrincessEnvironment env = new PrincessEnvironment(pLogfileTemplate, pShutdownNotifier, options);
        PrincessFormulaCreator creator = new PrincessFormulaCreator(env, PrincessTermType.Boolean, PrincessTermType.Integer);
        PrincessUFManager functionTheory = new PrincessUFManager(creator);
        PrincessBooleanFormulaManager booleanTheory = new PrincessBooleanFormulaManager(creator);
        PrincessIntegerFormulaManager integerTheory = new PrincessIntegerFormulaManager(creator);
        PrincessArrayFormulaManager arrayTheory = new PrincessArrayFormulaManager(creator);
        PrincessQuantifiedFormulaManager quantifierTheory = new PrincessQuantifiedFormulaManager(creator);
        PrincessFormulaManager manager = new PrincessFormulaManager(creator, functionTheory, booleanTheory, integerTheory, arrayTheory, quantifierTheory);
        return new PrincessSolverContext(manager, creator);
    }

    @Override
    protected ProverEnvironment newProverEnvironment0(Set<SolverContext.ProverOptions> options) {
        if (options.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE) || options.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE_OVER_ASSUMPTIONS)) {
            throw new UnsupportedOperationException("Princess does not support unsat core generation");
        }
        return new ReusableStackTheoremProver((PrincessTheoremProver)((PrincessEnvironment)this.creator.getEnv()).getNewProver(false, this.manager, this.creator));
    }

    @Override
    protected InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation0() {
        return new ReusableStackInterpolatingProver<Integer>((PrincessInterpolatingProver)((PrincessEnvironment)this.creator.getEnv()).getNewProver(true, this.manager, this.creator));
    }

    @Override
    public OptimizationProverEnvironment newOptimizationProverEnvironment() {
        throw new UnsupportedOperationException("Princess does not support optimization");
    }

    @Override
    public String getVersion() {
        return ((PrincessEnvironment)this.creator.getEnv()).getVersion();
    }

    @Override
    public SolverContextFactory.Solvers getSolverName() {
        return SolverContextFactory.Solvers.PRINCESS;
    }

    @Override
    public void close() {
    }

    @Override
    protected boolean supportsAssumptionSolving() {
        return false;
    }

    @Options(prefix="solver.princess")
    static class PrincessOptions {
        @Option(secure=true, description="The number of atoms a term has to have before it gets abbreviated if there are more identical terms.")
        private int minAtomsForAbbreviation = 100;
        @Option(secure=true, description="Princess needs to copy all symbols for each new prover. This flag allows to reuse old unused provers and avoid the overhead.")
        private boolean reuseProvers = true;

        PrincessOptions(Configuration config) throws InvalidConfigurationException {
            config.inject((Object)this);
        }

        public int getMinAtomsForAbbreviation() {
            return this.minAtomsForAbbreviation;
        }

        boolean reuseProvers() {
            return this.reuseProvers;
        }
    }
}

