/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.princess;

import ap.parser.IConstant;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IQuantified;
import ap.terfor.ConstantTerm;
import ap.terfor.conjunctions.Quantifier;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractQuantifiedFormulaManager;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.solvers.princess.PrincessEnvironment;
import org.sosy_lab.java_smt.solvers.princess.PrincessFunctionDeclaration;
import org.sosy_lab.java_smt.solvers.princess.PrincessTermType;
import scala.collection.Iterable;
import scala.collection.JavaConversions;

class PrincessQuantifiedFormulaManager
extends AbstractQuantifiedFormulaManager<IExpression, PrincessTermType, PrincessEnvironment, PrincessFunctionDeclaration> {
    private final PrincessEnvironment env = (PrincessEnvironment)this.getFormulaCreator().getEnv();

    PrincessQuantifiedFormulaManager(FormulaCreator<IExpression, PrincessTermType, PrincessEnvironment, PrincessFunctionDeclaration> pCreator) {
        super(pCreator);
    }

    @Override
    public IExpression mkQuantifier(QuantifiedFormulaManager.Quantifier q, List<IExpression> vars, IExpression body) {
        Quantifier.ALL$ pq;
        Preconditions.checkArgument((boolean)(body instanceof IFormula));
        Object object = pq = q == QuantifiedFormulaManager.Quantifier.FORALL ? Quantifier.ALL$.MODULE$ : Quantifier.EX$.MODULE$;
        if (vars.size() == 0) {
            return new IQuantified((Quantifier)pq, (IFormula)body);
        }
        return IExpression.quanConsts((Quantifier)pq, (Iterable)JavaConversions.iterableAsScalaIterable(this.toConstantTerm(vars)), (IFormula)((IFormula)body));
    }

    private List<ConstantTerm> toConstantTerm(List<IExpression> lst) {
        ArrayList<ConstantTerm> retVal = new ArrayList<ConstantTerm>(lst.size());
        for (IExpression f : lst) {
            retVal.add(((IConstant)f).c());
        }
        return retVal;
    }

    @Override
    protected IExpression eliminateQuantifiers(IExpression formula) throws SolverException, InterruptedException {
        Preconditions.checkArgument((boolean)(formula instanceof IFormula));
        return this.env.elimQuantifiers((IFormula)formula);
    }
}

