/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import java.math.BigInteger;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;

abstract class Mathsat5NumeralFormulaManager<ParamFormulaType extends NumeralFormula, ResultFormulaType extends NumeralFormula>
extends AbstractNumeralFormulaManager<Long, Long, Long, ParamFormulaType, ResultFormulaType, Long> {
    private final long mathsatEnv;

    Mathsat5NumeralFormulaManager(Mathsat5FormulaCreator pCreator) {
        super(pCreator);
        this.mathsatEnv = (Long)pCreator.getEnv();
    }

    @Override
    protected boolean isNumeral(Long val) {
        return Mathsat5NativeApi.msat_term_is_number(this.mathsatEnv, val);
    }

    @Override
    public Long makeNumberImpl(long pI) {
        return Mathsat5NativeApi.msat_make_number(this.mathsatEnv, Long.toString(pI));
    }

    @Override
    public Long makeNumberImpl(BigInteger pI) {
        return Mathsat5NativeApi.msat_make_number(this.mathsatEnv, pI.toString());
    }

    @Override
    public Long makeNumberImpl(String pI) {
        return Mathsat5NativeApi.msat_make_number(this.mathsatEnv, pI);
    }

    protected abstract long getNumeralType();

    @Override
    public Long makeVariableImpl(String var) {
        return (Long)this.getFormulaCreator().makeVariable(this.getNumeralType(), var);
    }

    @Override
    public Long negate(Long pNumber) {
        return Mathsat5NativeApi.msat_make_times(this.mathsatEnv, pNumber, Mathsat5NativeApi.msat_make_number(this.mathsatEnv, "-1"));
    }

    @Override
    public Long add(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_plus(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long subtract(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_plus(this.mathsatEnv, pNumber1, this.negate(pNumber2));
    }

    @Override
    public Long multiply(Long pNumber1, Long pNumber2) {
        if (this.isNumeral(pNumber1) || this.isNumeral(pNumber2)) {
            return Mathsat5NativeApi.msat_make_times(this.mathsatEnv, pNumber1, pNumber2);
        }
        return super.multiply(pNumber1, pNumber2);
    }

    @Override
    public Long equal(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_equal(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long greaterThan(Long pNumber1, Long pNumber2) {
        return this.makeNot(this.lessOrEquals(pNumber1, pNumber2));
    }

    @Override
    public Long greaterOrEquals(Long pNumber1, Long pNumber2) {
        return this.lessOrEquals(pNumber2, pNumber1);
    }

    private long makeNot(long n) {
        return Mathsat5NativeApi.msat_make_not(this.mathsatEnv, n);
    }

    @Override
    public Long lessThan(Long pNumber1, Long pNumber2) {
        return this.makeNot(this.lessOrEquals(pNumber2, pNumber1));
    }

    @Override
    public Long lessOrEquals(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_leq(this.mathsatEnv, pNumber1, pNumber2);
    }
}

