/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5AbstractProver;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5SolverContext;

class Mathsat5InterpolatingProver
extends Mathsat5AbstractProver<Integer>
implements InterpolatingProverEnvironment<Integer> {
    private static final ImmutableSet<String> ALLOWED_FAILURE_MESSAGES = ImmutableSet.of((Object)"impossible to build a suitable congruence graph!", (Object)"can't build ie-local interpolant", (Object)"splitting of AB-mixed terms not supported", (Object)"Hypothesis belongs neither to A nor to B", (Object)"FP<->BV combination unsupported by the current configuration", (Object)"cur_eq unknown to the classifier", (Object[])new String[]{"unknown constraint in the ItpMapper", "AB-mixed term not found in eq_itp map", "uncolored atom found in Array proof", "arr: proof splitting not supported"});

    Mathsat5InterpolatingProver(Mathsat5SolverContext pMgr, Mathsat5FormulaCreator creator) {
        super(pMgr, Mathsat5InterpolatingProver.createConfig(), creator);
    }

    private static Map<String, String> createConfig() {
        return ImmutableMap.builder().put((Object)"interpolation", (Object)"true").put((Object)"model_generation", (Object)"true").put((Object)"theory.bv.eager", (Object)"false").build();
    }

    @Override
    public Integer addConstraint(BooleanFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        int group = Mathsat5NativeApi.msat_create_itp_group(this.curEnv);
        Mathsat5NativeApi.msat_set_itp_group(this.curEnv, group);
        long t = this.creator.extractInfo(f);
        Mathsat5NativeApi.msat_assert_formula(this.curEnv, t);
        return group;
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Mathsat5NativeApi.msat_push_backtrack_point(this.curEnv);
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return !Mathsat5NativeApi.msat_check_sat_with_assumptions(this.curEnv, Mathsat5FormulaManager.getMsatTerm(pAssumptions));
    }

    @Override
    protected long getMsatModel() throws SolverException {
        try {
            return Mathsat5NativeApi.msat_get_model(this.curEnv);
        }
        catch (IllegalArgumentException e) {
            String msg = Strings.emptyToNull((String)e.getMessage());
            throw new SolverException("msat_get_model failed" + (msg != null ? " with \"" + msg + "\"" : "") + ", probably the actual problem is interpolation", e);
        }
    }

    @Override
    public BooleanFormula getInterpolant(List<Integer> formulasOfA) throws SolverException {
        long itp;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        int[] groupsOfA = new int[formulasOfA.size()];
        int i = 0;
        for (Integer f : formulasOfA) {
            groupsOfA[i++] = f;
        }
        try {
            itp = Mathsat5NativeApi.msat_get_interpolant(this.curEnv, groupsOfA);
        }
        catch (IllegalArgumentException e) {
            if (ALLOWED_FAILURE_MESSAGES.contains((Object)e.getMessage())) {
                throw new SolverException(e.getMessage(), e);
            }
            throw e;
        }
        return this.creator.encapsulateBoolean(itp);
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<Set<Integer>> partitionedFormulas) {
        throw new UnsupportedOperationException("directly receiving an inductive sequence of interpolants is not supported.Use another solver or another strategy for interpolants.");
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<Set<Integer>> partitionedFormulas, int[] startOfSubTree) {
        throw new UnsupportedOperationException("directly receiving tree interpolants is not supported.Use another solver or another strategy for interpolants.");
    }
}

