/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5Model;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5SolverContext;

abstract class Mathsat5AbstractProver<T2>
implements BasicProverEnvironment<T2> {
    protected final Mathsat5SolverContext context;
    protected final long curEnv;
    private final long curConfig;
    private final long terminationTest;
    protected final Mathsat5FormulaCreator creator;
    protected boolean closed = false;

    protected Mathsat5AbstractProver(Mathsat5SolverContext pContext, Map<String, String> pConfig, Mathsat5FormulaCreator creator) {
        this.context = pContext;
        this.creator = creator;
        this.curConfig = this.buildConfig(pConfig);
        this.curEnv = this.context.createEnvironment(this.curConfig);
        this.terminationTest = this.context.addTerminationTest(this.curEnv);
    }

    private long buildConfig(Map<String, String> pConfig) {
        long cfg = Mathsat5NativeApi.msat_create_config();
        for (Map.Entry<String, String> entry : pConfig.entrySet()) {
            Mathsat5NativeApi.msat_set_option_checked(cfg, entry.getKey(), entry.getValue());
        }
        return cfg;
    }

    @Override
    public boolean isUnsat() throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return !Mathsat5NativeApi.msat_check_sat(this.curEnv);
    }

    @Override
    public Model getModel() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return new Mathsat5Model(this.getMsatModel(), this.creator);
    }

    @Override
    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        try (Mathsat5Model model = new Mathsat5Model(this.getMsatModel(), this.creator);){
            ImmutableList<Model.ValueAssignment> immutableList = model.modelToList();
            return immutableList;
        }
    }

    protected long getMsatModel() throws SolverException {
        return Mathsat5NativeApi.msat_get_model(this.curEnv);
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Mathsat5NativeApi.msat_pop_backtrack_point(this.curEnv);
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Mathsat5NativeApi.msat_destroy_env(this.curEnv);
        Mathsat5NativeApi.msat_free_termination_test(this.terminationTest);
        Mathsat5NativeApi.msat_destroy_config(this.curConfig);
        this.closed = true;
    }
}

