/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.logging;

import com.google.common.base.Preconditions;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.logging.LoggingInterpolatingProverEnvironment;
import org.sosy_lab.java_smt.logging.LoggingOptimizationProverEnvironment;
import org.sosy_lab.java_smt.logging.LoggingProverEnvironment;

public final class LoggingSolverContext
implements SolverContext {
    private final LogManager logger;
    private final SolverContext delegate;

    public LoggingSolverContext(LogManager pLogger, SolverContext pDelegate) {
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.delegate = (SolverContext)Preconditions.checkNotNull((Object)pDelegate);
    }

    @Override
    public FormulaManager getFormulaManager() {
        return this.delegate.getFormulaManager();
    }

    @Override
    public ProverEnvironment newProverEnvironment(SolverContext.ProverOptions ... pOptions) {
        return new LoggingProverEnvironment(this.logger, this.delegate.newProverEnvironment(pOptions));
    }

    @Override
    public InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation() {
        return new LoggingInterpolatingProverEnvironment(this.logger, this.delegate.newProverEnvironmentWithInterpolation());
    }

    @Override
    public OptimizationProverEnvironment newOptimizationProverEnvironment() {
        return new LoggingOptimizationProverEnvironment(this.logger, this.delegate.newOptimizationProverEnvironment());
    }

    @Override
    public String getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public SolverContextFactory.Solvers getSolverName() {
        return this.delegate.getSolverName();
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

