/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.logging;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.logging.LoggingBasicProverEnvironment;

class LoggingProverEnvironment
extends LoggingBasicProverEnvironment<Void>
implements ProverEnvironment {
    private final ProverEnvironment wrapped;

    LoggingProverEnvironment(LogManager logger, ProverEnvironment pe) {
        super(pe, logger);
        this.wrapped = (ProverEnvironment)Preconditions.checkNotNull((Object)pe);
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        boolean result = this.wrapped.isUnsatWithAssumptions(assumptions);
        this.logger.log(Level.FINE, new Object[]{"unsat-check returned:", result});
        return result;
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        Optional<List<BooleanFormula>> result = this.wrapped.unsatCoreOverAssumptions(assumptions);
        this.logger.log(Level.FINE, new Object[]{"unsat-check returned:", !result.isPresent()});
        return result;
    }

    @Override
    public Model getModel() throws SolverException {
        Model m = this.wrapped.getModel();
        this.logger.log(Level.FINE, new Object[]{"model", m});
        return m;
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        List<BooleanFormula> unsatCore = this.wrapped.getUnsatCore();
        this.logger.log(Level.FINE, new Object[]{"unsat-core", unsatCore});
        return unsatCore;
    }

    @Override
    public <T> T allSat(ProverEnvironment.AllSatCallback<T> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        T result = this.wrapped.allSat(callback, important);
        this.logger.log(Level.FINE, new Object[]{"allsat-result:", result});
        return result;
    }
}

