/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.logging;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.logging.LoggingBasicProverEnvironment;

class LoggingInterpolatingProverEnvironment<T>
extends LoggingBasicProverEnvironment<T>
implements InterpolatingProverEnvironment<T> {
    private final InterpolatingProverEnvironment<T> wrapped;

    LoggingInterpolatingProverEnvironment(LogManager logger, InterpolatingProverEnvironment<T> ipe) {
        super(ipe, logger);
        this.wrapped = (InterpolatingProverEnvironment)Preconditions.checkNotNull(ipe);
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        this.logger.log(Level.FINE, new Object[]{"assumptions:", pAssumptions});
        boolean result = this.wrapped.isUnsatWithAssumptions(pAssumptions);
        this.logger.log(Level.FINE, new Object[]{"unsat-check returned:", result});
        return result;
    }

    @Override
    public BooleanFormula getInterpolant(List<T> formulasOfA) throws SolverException, InterruptedException {
        this.logger.log(Level.FINE, new Object[]{"formulasOfA:", formulasOfA});
        BooleanFormula bf = this.wrapped.getInterpolant(formulasOfA);
        this.logger.log(Level.FINE, new Object[]{"interpolant:", bf});
        return bf;
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<Set<T>> partitionedFormulas) throws SolverException, InterruptedException {
        this.logger.log(Level.FINE, new Object[]{"formulasOfA:", partitionedFormulas});
        List<BooleanFormula> bf = this.wrapped.getSeqInterpolants(partitionedFormulas);
        this.logger.log(Level.FINE, new Object[]{"interpolants:", bf});
        return bf;
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<Set<T>> partitionedFormulas, int[] startOfSubTree) throws SolverException, InterruptedException {
        this.logger.log(Level.FINE, new Object[]{"formulasOfA:", partitionedFormulas});
        this.logger.log(Level.FINE, new Object[]{"startOfSubTree:", startOfSubTree});
        List<BooleanFormula> bf = this.wrapped.getTreeInterpolants(partitionedFormulas, startOfSubTree);
        this.logger.log(Level.FINE, new Object[]{"interpolants:", bf});
        return bf;
    }
}

