/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl.tactics;

import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaTransformationVisitor;

public class NNFVisitor
extends BooleanFormulaTransformationVisitor {
    private final NNFInsideNotVisitor insideNotVisitor;
    private final BooleanFormulaManager bfmgr;

    public NNFVisitor(FormulaManager pFmgr) {
        super(pFmgr);
        this.bfmgr = pFmgr.getBooleanFormulaManager();
        this.insideNotVisitor = new NNFInsideNotVisitor(pFmgr);
    }

    @Override
    public BooleanFormula visitNot(BooleanFormula processedOperand) {
        return this.bfmgr.visit(processedOperand, this.insideNotVisitor);
    }

    @Override
    public BooleanFormula visitXor(BooleanFormula processedOperand1, BooleanFormula processedOperand2) {
        return this.bfmgr.visit(this.rewriteXor(processedOperand1, processedOperand2), this);
    }

    private BooleanFormula rewriteXor(BooleanFormula operand1, BooleanFormula operand2) {
        return this.bfmgr.or(this.bfmgr.and(operand1, this.bfmgr.not(operand2)), this.bfmgr.and(this.bfmgr.not(operand1), operand2));
    }

    @Override
    public BooleanFormula visitEquivalence(BooleanFormula processedOperand1, BooleanFormula processedOperand2) {
        return this.bfmgr.visit(this.rewriteEquivalence(processedOperand1, processedOperand2), this);
    }

    private BooleanFormula rewriteEquivalence(BooleanFormula pOperand1, BooleanFormula pOperand2) {
        return this.bfmgr.or(this.bfmgr.and(pOperand1, pOperand2), this.bfmgr.and(this.bfmgr.not(pOperand1), this.bfmgr.not(pOperand2)));
    }

    @Override
    public BooleanFormula visitImplication(BooleanFormula processedOperand1, BooleanFormula processedOperand2) {
        return this.bfmgr.visit(this.rewriteImplication(processedOperand1, processedOperand2), this);
    }

    private BooleanFormula rewriteImplication(BooleanFormula pOperand1, BooleanFormula pOperand2) {
        return this.bfmgr.or(this.bfmgr.not(pOperand1), pOperand2);
    }

    @Override
    public BooleanFormula visitIfThenElse(BooleanFormula processedCondition, BooleanFormula processedThenFormula, BooleanFormula processedElseFormula) {
        return this.bfmgr.visit(this.rewriteIfThenElse(processedCondition, processedThenFormula, processedElseFormula), this);
    }

    private BooleanFormula rewriteIfThenElse(BooleanFormula pCondition, BooleanFormula pThenFormula, BooleanFormula pElseFormula) {
        return this.bfmgr.or(this.bfmgr.and(pCondition, pThenFormula), this.bfmgr.and(this.bfmgr.not(pCondition), pElseFormula));
    }

    private class NNFInsideNotVisitor
    extends BooleanFormulaTransformationVisitor {
        protected NNFInsideNotVisitor(FormulaManager pFmgr) {
            super(pFmgr);
        }

        @Override
        public BooleanFormula visitConstant(boolean value) {
            return NNFVisitor.this.bfmgr.makeBoolean(value);
        }

        @Override
        public BooleanFormula visitAtom(BooleanFormula pAtom, FunctionDeclaration<BooleanFormula> decl) {
            return NNFVisitor.this.bfmgr.not(pAtom);
        }

        @Override
        public BooleanFormula visitNot(BooleanFormula processedOperand) {
            return NNFVisitor.this.bfmgr.visit(processedOperand, NNFVisitor.this);
        }

        @Override
        public BooleanFormula visitAnd(List<BooleanFormula> processedOperands) {
            ArrayList<BooleanFormula> newOperands = new ArrayList<BooleanFormula>();
            for (BooleanFormula f : processedOperands) {
                newOperands.add(NNFVisitor.this.bfmgr.visit(f, this));
            }
            return NNFVisitor.this.bfmgr.or(newOperands);
        }

        @Override
        public BooleanFormula visitOr(List<BooleanFormula> processedOperands) {
            ArrayList<BooleanFormula> newOperands = new ArrayList<BooleanFormula>();
            for (BooleanFormula f : processedOperands) {
                newOperands.add(NNFVisitor.this.bfmgr.visit(f, this));
            }
            return NNFVisitor.this.bfmgr.and(newOperands);
        }

        @Override
        public BooleanFormula visitXor(BooleanFormula processedOperand1, BooleanFormula processedOperand2) {
            return NNFVisitor.this.bfmgr.visit(NNFVisitor.this.rewriteXor(processedOperand1, processedOperand2), this);
        }

        @Override
        public BooleanFormula visitEquivalence(BooleanFormula processedOperand1, BooleanFormula processedOperand2) {
            return NNFVisitor.this.bfmgr.visit(NNFVisitor.this.rewriteEquivalence(processedOperand1, processedOperand2), this);
        }

        @Override
        public BooleanFormula visitImplication(BooleanFormula processedOperand1, BooleanFormula processedOperand2) {
            return NNFVisitor.this.bfmgr.visit(NNFVisitor.this.bfmgr.or(NNFVisitor.this.bfmgr.not(processedOperand1), processedOperand2), this);
        }

        @Override
        public BooleanFormula visitIfThenElse(BooleanFormula processedCondition, BooleanFormula processedThenFormula, BooleanFormula processedElseFormula) {
            return NNFVisitor.this.bfmgr.visit(NNFVisitor.this.rewriteIfThenElse(processedCondition, processedThenFormula, processedElseFormula), this);
        }
    }
}

