/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormulaManager;
import org.sosy_lab.java_smt.api.FloatingPointRoundingMode;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractBaseFormulaManager;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;

public abstract class AbstractFloatingPointFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl>
extends AbstractBaseFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl>
implements FloatingPointFormulaManager {
    private final Map<FloatingPointRoundingMode, TFormulaInfo> roundingModes = new HashMap<FloatingPointRoundingMode, TFormulaInfo>();

    protected AbstractFloatingPointFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv, TFuncDecl> pCreator) {
        super(pCreator);
    }

    protected abstract TFormulaInfo getDefaultRoundingMode();

    protected abstract TFormulaInfo getRoundingModeImpl(FloatingPointRoundingMode var1);

    private TFormulaInfo getRoundingMode(FloatingPointRoundingMode pFloatingPointRoundingMode) {
        TFormulaInfo out = this.roundingModes.get((Object)pFloatingPointRoundingMode);
        if (out == null) {
            out = this.getRoundingModeImpl(pFloatingPointRoundingMode);
            this.roundingModes.put(pFloatingPointRoundingMode, out);
        }
        return out;
    }

    protected FloatingPointFormula wrap(TFormulaInfo pTerm) {
        return this.getFormulaCreator().encapsulateFloatingPoint(pTerm);
    }

    @Override
    public FloatingPointFormula makeNumber(Rational n, FormulaType.FloatingPointType type) {
        return this.wrap(this.makeNumberImpl(n.toString(), type, this.getDefaultRoundingMode()));
    }

    @Override
    public FloatingPointFormula makeNumber(Rational n, FormulaType.FloatingPointType type, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        return this.wrap(this.makeNumberImpl(n.toString(), type, this.getRoundingMode(pFloatingPointRoundingMode)));
    }

    @Override
    public FloatingPointFormula makeNumber(double n, FormulaType.FloatingPointType type) {
        return this.wrap(this.makeNumberImpl(n, type, this.getDefaultRoundingMode()));
    }

    @Override
    public FloatingPointFormula makeNumber(double n, FormulaType.FloatingPointType type, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        return this.wrap(this.makeNumberImpl(n, type, this.getRoundingMode(pFloatingPointRoundingMode)));
    }

    protected abstract TFormulaInfo makeNumberImpl(double var1, FormulaType.FloatingPointType var3, TFormulaInfo var4);

    @Override
    public FloatingPointFormula makeNumber(BigDecimal n, FormulaType.FloatingPointType type) {
        return this.wrap(this.makeNumberImpl(n, type, this.getDefaultRoundingMode()));
    }

    @Override
    public FloatingPointFormula makeNumber(BigDecimal n, FormulaType.FloatingPointType type, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        return this.wrap(this.makeNumberImpl(n, type, this.getRoundingMode(pFloatingPointRoundingMode)));
    }

    protected abstract TFormulaInfo makeNumberImpl(BigDecimal var1, FormulaType.FloatingPointType var2, TFormulaInfo var3);

    @Override
    public FloatingPointFormula makeNumber(String n, FormulaType.FloatingPointType type) {
        return this.wrap(this.makeNumberImpl(n, type, this.getDefaultRoundingMode()));
    }

    @Override
    public FloatingPointFormula makeNumber(String n, FormulaType.FloatingPointType type, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        return this.wrap(this.makeNumberImpl(n, type, this.getRoundingMode(pFloatingPointRoundingMode)));
    }

    protected abstract TFormulaInfo makeNumberImpl(String var1, FormulaType.FloatingPointType var2, TFormulaInfo var3);

    @Override
    public FloatingPointFormula makeVariable(String pVar, FormulaType.FloatingPointType pType) {
        AbstractFloatingPointFormulaManager.checkVariableName(pVar);
        return this.wrap(this.makeVariableImpl(pVar, pType));
    }

    protected abstract TFormulaInfo makeVariableImpl(String var1, FormulaType.FloatingPointType var2);

    @Override
    public FloatingPointFormula makePlusInfinity(FormulaType.FloatingPointType pType) {
        return this.wrap(this.makePlusInfinityImpl(pType));
    }

    protected abstract TFormulaInfo makePlusInfinityImpl(FormulaType.FloatingPointType var1);

    @Override
    public FloatingPointFormula makeMinusInfinity(FormulaType.FloatingPointType pType) {
        return this.wrap(this.makeMinusInfinityImpl(pType));
    }

    protected abstract TFormulaInfo makeMinusInfinityImpl(FormulaType.FloatingPointType var1);

    @Override
    public FloatingPointFormula makeNaN(FormulaType.FloatingPointType pType) {
        return this.wrap(this.makeNaNImpl(pType));
    }

    protected abstract TFormulaInfo makeNaNImpl(FormulaType.FloatingPointType var1);

    @Override
    public <T extends Formula> T castTo(FloatingPointFormula pNumber, FormulaType<T> pTargetType) {
        return this.getFormulaCreator().encapsulate(pTargetType, this.castToImpl(this.extractInfo(pNumber), pTargetType, this.getDefaultRoundingMode()));
    }

    @Override
    public <T extends Formula> T castTo(FloatingPointFormula number, FormulaType<T> targetType, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        return this.getFormulaCreator().encapsulate(targetType, this.castToImpl(this.extractInfo(number), targetType, this.getRoundingMode(pFloatingPointRoundingMode)));
    }

    protected abstract TFormulaInfo castToImpl(TFormulaInfo var1, FormulaType<?> var2, TFormulaInfo var3);

    @Override
    public FloatingPointFormula castFrom(Formula pNumber, boolean pSigned, FormulaType.FloatingPointType pTargetType) {
        return this.wrap(this.castFromImpl(this.extractInfo(pNumber), pSigned, pTargetType, this.getDefaultRoundingMode()));
    }

    @Override
    public FloatingPointFormula castFrom(Formula number, boolean signed, FormulaType.FloatingPointType targetType, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        return this.wrap(this.castFromImpl(this.extractInfo(number), signed, targetType, this.getRoundingMode(pFloatingPointRoundingMode)));
    }

    protected abstract TFormulaInfo castFromImpl(TFormulaInfo var1, boolean var2, FormulaType.FloatingPointType var3, TFormulaInfo var4);

    @Override
    public FloatingPointFormula negate(FloatingPointFormula pNumber) {
        Object param1 = this.extractInfo(pNumber);
        return this.wrap(this.negate(param1));
    }

    protected abstract TFormulaInfo negate(TFormulaInfo var1);

    @Override
    public FloatingPointFormula add(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrap(this.add(param1, param2, this.getDefaultRoundingMode()));
    }

    @Override
    public FloatingPointFormula add(FloatingPointFormula number1, FloatingPointFormula number2, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        return this.wrap(this.add(this.extractInfo(number1), this.extractInfo(number2), this.getRoundingMode(pFloatingPointRoundingMode)));
    }

    protected abstract TFormulaInfo add(TFormulaInfo var1, TFormulaInfo var2, TFormulaInfo var3);

    @Override
    public FloatingPointFormula subtract(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrap(this.subtract(param1, param2, this.getDefaultRoundingMode()));
    }

    @Override
    public FloatingPointFormula subtract(FloatingPointFormula number1, FloatingPointFormula number2, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        Object param1 = this.extractInfo(number1);
        Object param2 = this.extractInfo(number2);
        return this.wrap(this.subtract(param1, param2, this.getRoundingMode(pFloatingPointRoundingMode)));
    }

    protected abstract TFormulaInfo subtract(TFormulaInfo var1, TFormulaInfo var2, TFormulaInfo var3);

    @Override
    public FloatingPointFormula divide(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrap(this.divide(param1, param2, this.getDefaultRoundingMode()));
    }

    @Override
    public FloatingPointFormula divide(FloatingPointFormula number1, FloatingPointFormula number2, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        Object param1 = this.extractInfo(number1);
        Object param2 = this.extractInfo(number2);
        return this.wrap(this.divide(param1, param2, this.getRoundingMode(pFloatingPointRoundingMode)));
    }

    protected abstract TFormulaInfo divide(TFormulaInfo var1, TFormulaInfo var2, TFormulaInfo var3);

    @Override
    public FloatingPointFormula multiply(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrap(this.multiply(param1, param2, this.getDefaultRoundingMode()));
    }

    @Override
    public FloatingPointFormula multiply(FloatingPointFormula number1, FloatingPointFormula number2, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        Object param1 = this.extractInfo(number1);
        Object param2 = this.extractInfo(number2);
        return this.wrap(this.multiply(param1, param2, this.getRoundingMode(pFloatingPointRoundingMode)));
    }

    protected abstract TFormulaInfo multiply(TFormulaInfo var1, TFormulaInfo var2, TFormulaInfo var3);

    @Override
    public BooleanFormula assignment(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrapBool(this.assignment(param1, param2));
    }

    protected abstract TFormulaInfo assignment(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula equalWithFPSemantics(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrapBool(this.equalWithFPSemantics(param1, param2));
    }

    protected abstract TFormulaInfo equalWithFPSemantics(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula greaterThan(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrapBool(this.greaterThan(param1, param2));
    }

    protected abstract TFormulaInfo greaterThan(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula greaterOrEquals(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrapBool(this.greaterOrEquals(param1, param2));
    }

    protected abstract TFormulaInfo greaterOrEquals(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula lessThan(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrapBool(this.lessThan(param1, param2));
    }

    protected abstract TFormulaInfo lessThan(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula lessOrEquals(FloatingPointFormula pNumber1, FloatingPointFormula pNumber2) {
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrapBool(this.lessOrEquals(param1, param2));
    }

    protected abstract TFormulaInfo lessOrEquals(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula isNaN(FloatingPointFormula pNumber) {
        return this.wrapBool(this.isNaN(this.extractInfo(pNumber)));
    }

    protected abstract TFormulaInfo isNaN(TFormulaInfo var1);

    @Override
    public BooleanFormula isInfinity(FloatingPointFormula pNumber) {
        return this.wrapBool(this.isInfinity(this.extractInfo(pNumber)));
    }

    protected abstract TFormulaInfo isInfinity(TFormulaInfo var1);

    @Override
    public BooleanFormula isZero(FloatingPointFormula pNumber) {
        return this.wrapBool(this.isZero(this.extractInfo(pNumber)));
    }

    protected abstract TFormulaInfo isZero(TFormulaInfo var1);

    @Override
    public BooleanFormula isSubnormal(FloatingPointFormula pNumber) {
        return this.wrapBool(this.isSubnormal(this.extractInfo(pNumber)));
    }

    protected abstract TFormulaInfo isSubnormal(TFormulaInfo var1);
}

