/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class ProverEnvironmentTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static SolverContextFactory.Solvers[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void assumptionsTest() throws Exception {
        BooleanFormula b = this.bmgr.makeVariable("b");
        BooleanFormula c = this.bmgr.makeVariable("c");
        try (ProverEnvironment pe = this.context.newProverEnvironment(new SolverContext.ProverOptions[0]);){
            pe.push();
            pe.addConstraint(this.bmgr.or(b, this.bmgr.makeBoolean(false)));
            pe.addConstraint(c);
            Truth.assertThat((Boolean)pe.isUnsat()).isFalse();
            Truth.assertThat((Boolean)pe.isUnsatWithAssumptions((Collection<BooleanFormula>)ImmutableList.of((Object)this.bmgr.not(b)))).isTrue();
            Truth.assertThat((Boolean)pe.isUnsatWithAssumptions((Collection<BooleanFormula>)ImmutableList.of((Object)b))).isFalse();
        }
    }

    @Test
    public void assumptionsWithModelTest() throws Exception {
        TruthJUnit.assume().withFailureMessage("MathSAT can't construct models for SAT check with assumptions").that((Comparable)((Object)this.solver)).isNotEqualTo((Object)SolverContextFactory.Solvers.MATHSAT5);
        BooleanFormula b = this.bmgr.makeVariable("b");
        BooleanFormula c = this.bmgr.makeVariable("c");
        try (ProverEnvironment pe = this.context.newProverEnvironment(new SolverContext.ProverOptions[0]);){
            pe.push();
            pe.addConstraint(this.bmgr.or(b, this.bmgr.makeBoolean(false)));
            pe.addConstraint(c);
            Truth.assertThat((Boolean)pe.isUnsat()).isFalse();
            Truth.assertThat((Boolean)pe.isUnsatWithAssumptions((Collection<BooleanFormula>)ImmutableList.of((Object)this.bmgr.not(b)))).isTrue();
            Truth.assertThat((Boolean)pe.isUnsatWithAssumptions((Collection<BooleanFormula>)ImmutableList.of((Object)b))).isFalse();
            try (Model m = pe.getModel();){
                Truth.assertThat((Boolean)m.evaluate(c)).isTrue();
            }
        }
    }

    @Test
    public void unsatCoreTest() throws Exception {
        TruthJUnit.assume().withFailureMessage("Princess does not support unsat core generation").that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        try (ProverEnvironment pe = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);){
            pe.push();
            pe.addConstraint(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
            pe.addConstraint(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L)));
            pe.addConstraint(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L)));
            this.assertThatEnvironment(pe).isUnsatisfiable();
            List<BooleanFormula> unsatCore = pe.getUnsatCore();
            Truth.assertThat(unsatCore).containsExactly(new Object[]{this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L)), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L))});
        }
    }

    @Test
    public void unsatCoreWithAssumptionsTest() throws Exception {
        TruthJUnit.assume().withFailureMessage("Princess and Mathsat5 do not support unsat core generation").that((Comparable)((Object)this.solverToUse())).isNoneOf((Object)SolverContextFactory.Solvers.PRINCESS, (Object)SolverContextFactory.Solvers.MATHSAT5, new Object[0]);
        try (ProverEnvironment pe = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_UNSAT_CORE_OVER_ASSUMPTIONS);){
            pe.push();
            pe.addConstraint(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L)));
            BooleanFormula selector = this.bmgr.makeVariable("b");
            pe.addConstraint(this.bmgr.or(selector, this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L))));
            Optional<List<BooleanFormula>> res = pe.unsatCoreOverAssumptions((Collection<BooleanFormula>)ImmutableList.of((Object)this.bmgr.not(selector)));
            this.assertThatOptional(res).isPresent();
            List<BooleanFormula> unsatCore = res.get();
            Truth.assertThat(unsatCore).containsExactly(new Object[]{this.bmgr.not(selector)});
        }
    }
}

