/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class ModelTest
extends SolverBasedTest0 {
    private static final List<SolverContextFactory.Solvers> SOLVERS_WITH_PARTIAL_MODEL = ImmutableList.of((Object)((Object)SolverContextFactory.Solvers.Z3), (Object)((Object)SolverContextFactory.Solvers.PRINCESS));
    @Parameterized.Parameter
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void testGetSmallIntegers() throws Exception {
        this.testModelGetters(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L)), (Formula)this.imgr.makeVariable("x"), BigInteger.valueOf(10L), "x");
    }

    @Test
    public void testGetNegativeIntegers() throws Exception {
        this.testModelGetters(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(-10L)), (Formula)this.imgr.makeVariable("x"), BigInteger.valueOf(-10L), "x");
    }

    @Test
    public void testGetLargeIntegers() throws Exception {
        BigInteger large = new BigInteger("1000000000000000000000000000000000000000");
        this.testModelGetters(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(large)), (Formula)this.imgr.makeVariable("x"), large, "x");
    }

    @Test
    public void testGetSmallIntegralRationals() throws Exception {
        this.requireRationals();
        assert (this.rmgr != null);
        this.testModelGetters(this.rmgr.equal(this.rmgr.makeVariable("x"), this.rmgr.makeNumber(1L)), (Formula)this.rmgr.makeVariable("x"), Rational.ONE, "x");
    }

    @Test
    public void testGetLargeIntegralRationals() throws Exception {
        this.requireRationals();
        assert (this.rmgr != null);
        BigInteger large = new BigInteger("1000000000000000000000000000000000000000");
        this.testModelGetters(this.rmgr.equal(this.rmgr.makeVariable("x"), this.rmgr.makeNumber(large)), (Formula)this.rmgr.makeVariable("x"), Rational.ofBigInteger((BigInteger)large), "x");
    }

    @Test
    public void testGetRationals() throws Exception {
        this.requireRationals();
        assert (this.rmgr != null);
        this.testModelGetters(this.rmgr.equal(this.rmgr.makeVariable("x"), this.rmgr.makeNumber(Rational.ofString((String)"1/3"))), (Formula)this.rmgr.makeVariable("x"), Rational.ofString((String)"1/3"), "x");
    }

    @Test
    public void testGetBooleans() throws Exception {
        this.testModelGetters(this.bmgr.makeVariable("x"), this.bmgr.makeBoolean(true), true, "x");
    }

    @Test
    public void testGetUFs() throws Exception {
        NumeralFormula.IntegerFormula x = this.fmgr.declareAndCallUF("UF", FormulaType.IntegerType, (List<Formula>)ImmutableList.of(this.imgr.makeVariable("arg")));
        this.testModelGetters(this.imgr.equal(x, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)), x, BigInteger.ONE, "UF");
    }

    @Test
    public void testGetMultipleUFs() throws Exception {
        NumeralFormula.IntegerFormula arg1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("arg1");
        NumeralFormula.IntegerFormula arg2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("arg2");
        FunctionDeclaration<NumeralFormula.IntegerFormula> declaration = this.fmgr.declareUF("UF", FormulaType.IntegerType, FormulaType.IntegerType);
        NumeralFormula.IntegerFormula app1 = this.fmgr.callUF(declaration, arg1);
        NumeralFormula.IntegerFormula app2 = this.fmgr.callUF(declaration, arg2);
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(this.imgr.equal(app1, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
            prover.push(this.imgr.equal(app2, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L)));
            prover.push(this.imgr.equal(arg1, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(3L)));
            prover.push(this.imgr.equal(arg2, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(4L)));
            this.assertThatEnvironment(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                Truth.assertThat((Comparable)m.evaluate(app1)).isEqualTo((Object)BigInteger.ONE);
                Truth.assertThat((Comparable)m.evaluate(app2)).isEqualTo((Object)BigInteger.valueOf(2L));
                Truth.assertThat((Iterable)m).containsExactly(new Object[]{new Model.ValueAssignment(arg1, "arg1", BigInteger.valueOf(3L), (Collection<?>)ImmutableList.of()), new Model.ValueAssignment(arg1, "arg2", BigInteger.valueOf(4L), (Collection<?>)ImmutableList.of()), new Model.ValueAssignment(this.fmgr.callUF(declaration, new Formula[]{this.imgr.makeNumber(3L)}), "UF", BigInteger.valueOf(1L), (Collection<?>)ImmutableList.of((Object)BigInteger.valueOf(3L))), new Model.ValueAssignment(this.fmgr.callUF(declaration, new Formula[]{this.imgr.makeNumber(4L)}), "UF", BigInteger.valueOf(2L), (Collection<?>)ImmutableList.of((Object)BigInteger.valueOf(4L)))});
            }
        }
    }

    @Test
    public void testQuantifiedUF() throws Exception {
        this.requireQuantifiers();
        NumeralFormula.IntegerFormula var = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("var");
        BooleanFormula varIsOne = this.imgr.equal(var, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L));
        NumeralFormula.IntegerFormula boundVar = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("boundVar");
        BooleanFormula boundVarIsZero = this.imgr.equal(boundVar, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L));
        String func = "func";
        NumeralFormula.IntegerFormula funcAtZero = this.fmgr.declareAndCallUF(func, FormulaType.IntegerType, new Formula[]{this.imgr.makeNumber(0L)});
        NumeralFormula.IntegerFormula funcAtBoundVar = this.fmgr.declareAndCallUF(func, FormulaType.IntegerType, boundVar);
        BooleanFormula body = this.bmgr.and(boundVarIsZero, this.imgr.equal(var, funcAtBoundVar));
        BooleanFormula f = this.bmgr.and(varIsOne, this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)boundVar), body));
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(f);
            this.assertThatEnvironment(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                for (Model.ValueAssignment valueAssignment : m) {
                }
                Truth.assertThat((Iterable)m).contains((Object)new Model.ValueAssignment(funcAtZero, func, BigInteger.ONE, (Collection<?>)ImmutableList.of((Object)BigInteger.ZERO)));
            }
        }
    }

    @Test
    public void testGetBitvectors() throws Exception {
        this.requireBitvectors();
        assert (this.bvmgr != null);
        this.testModelGetters(this.bvmgr.equal(this.bvmgr.makeVariable(1, "x"), this.bvmgr.makeBitvector(1, BigInteger.ONE)), this.bvmgr.makeVariable(1, "x"), BigInteger.ONE, "x");
    }

    @Test
    public void testGetModelAssignments() throws Exception {
        this.testModelIterator(this.bmgr.and(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"))));
    }

    @Test
    public void testEmptyStackModel() throws Exception {
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            this.assertThatEnvironment(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                Truth.assertThat((Comparable)m.evaluate((NumeralFormula.IntegerFormula)this.imgr.makeNumber(123L))).isEqualTo((Object)BigInteger.valueOf(123L));
                Truth.assertThat((Boolean)m.evaluate(this.bmgr.makeBoolean(true))).isEqualTo((Object)true);
                Truth.assertThat((Boolean)m.evaluate(this.bmgr.makeBoolean(false))).isEqualTo((Object)false);
                if (SOLVERS_WITH_PARTIAL_MODEL.contains((Object)this.solver)) {
                    Truth.assertThat((Comparable)m.evaluate((NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"))).isNull();
                } else {
                    Truth.assertThat((Comparable)m.evaluate((NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"))).isNotNull();
                }
            }
        }
    }

    @Test
    public void testNonExistantSymbol() throws Exception {
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(this.bmgr.makeBoolean(true));
            this.assertThatEnvironment(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                if (SOLVERS_WITH_PARTIAL_MODEL.contains((Object)this.solver)) {
                    Truth.assertThat((Comparable)m.evaluate((NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"))).isNull();
                } else {
                    Truth.assertThat((Comparable)m.evaluate((NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"))).isNotNull();
                }
            }
        }
    }

    @Test
    public void testPartialModels() throws Exception {
        TruthJUnit.assume().withFailureMessage("As of now, only Z3 and Princess support partial models").that((Comparable)((Object)this.solver)).isIn(SOLVERS_WITH_PARTIAL_MODEL);
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
            prover.push(this.imgr.equal(x, x));
            this.assertThatEnvironment(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                Truth.assertThat((Comparable)m.evaluate(x)).isEqualTo(null);
                Truth.assertThat((Iterable)m).isEmpty();
            }
        }
    }

    @Test
    public void testPartialModelsUF() throws Exception {
        TruthJUnit.assume().withFailureMessage("As of now, only Z3 and Princess support partial model evaluation").that((Comparable)((Object)this.solver)).isIn((Iterable)ImmutableList.of((Object)((Object)SolverContextFactory.Solvers.Z3), (Object)((Object)SolverContextFactory.Solvers.PRINCESS)));
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
            NumeralFormula.IntegerFormula f = this.fmgr.declareAndCallUF("f", FormulaType.IntegerType, x);
            prover.push(this.imgr.equal(x, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
            this.assertThatEnvironment(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                Truth.assertThat((Comparable)m.evaluate(f)).isEqualTo(null);
            }
        }
    }

    @Test
    public void testEvaluatingConstants() throws Exception {
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(this.bmgr.makeVariable("b"));
            Truth.assertThat((Boolean)prover.isUnsat()).isFalse();
            try (Model m = prover.getModel();){
                Truth.assertThat((Comparable)m.evaluate((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L))).isEqualTo((Object)BigInteger.ONE);
                Truth.assertThat((Boolean)m.evaluate(this.bmgr.makeBoolean(true))).isEqualTo((Object)true);
            }
        }
    }

    @Test
    public void testGetArrays() throws Exception {
        this.requireArrays();
        assert (this.amgr != null);
        ArrayFormula array = this.amgr.makeArray("array", FormulaType.IntegerType, FormulaType.IntegerType);
        ArrayFormula<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> updated = this.amgr.store(array, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L));
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(this.imgr.equal(this.amgr.select(updated, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
            this.assertThatEnvironment(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                for (Model.ValueAssignment valueAssignment : m) {
                }
                Truth.assertThat((Comparable)m.evaluate(this.amgr.select(updated, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)))).isEqualTo((Object)BigInteger.ONE);
            }
        }
    }

    @Test
    public void testGetArrays2() throws Exception {
        this.requireArrays();
        BooleanFormula f = this.mgr.parse("(declare-fun |pi@2| () Int)\n(declare-fun *unsigned_int@1 () (Array Int Int))\n(declare-fun |z2@2| () Int)\n(declare-fun |z1@2| () Int)\n(declare-fun |t@2| () Int)\n(declare-fun |__ADDRESS_OF_t| () Int)\n(declare-fun *char@1 () (Array Int Int))\n(assert    (and (= |t@2| 50)        (not (<= |__ADDRESS_OF_t| 0))        (= |z1@2| |__ADDRESS_OF_t|)        (= (select *char@1 |__ADDRESS_OF_t|) |t@2|)        (= |z2@2| |z1@2|)        (= |pi@2| |z2@2|)        (not (= (select *unsigned_int@1 |pi@2|) 50))))");
        this.testModelIterator(f);
    }

    @Test
    public void testGetArrays3() throws Exception {
        this.requireArrays();
        TruthJUnit.assume().withFailureMessage("As of now, only Princess does not support multi-dimensional arrays").that((Comparable)((Object)this.solver)).isNotSameAs((Object)SolverContextFactory.Solvers.PRINCESS);
        BooleanFormula f = this.mgr.parse("(declare-fun x () Int)\n(declare-fun arr () (Array Int (Array Int (Array Int Int))))\n(assert (and    (= (select (select (select arr 5) 3) 1) x)    (= x 123)))");
        this.testModelIterator(f);
        this.testModelGetters(f, (Formula)this.imgr.makeVariable("x"), BigInteger.valueOf(123L), "x");
        FormulaType.ArrayFormulaType arrType = FormulaType.ArrayFormulaType.getArrayType(FormulaType.IntegerType, FormulaType.ArrayFormulaType.getArrayType(FormulaType.IntegerType, FormulaType.ArrayFormulaType.getArrayType(FormulaType.IntegerType, FormulaType.IntegerType)));
        this.testModelGetters(f, (Formula)this.amgr.select((ArrayFormula)this.amgr.select((ArrayFormula)this.amgr.select(this.amgr.makeArray("arr", arrType), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(3L)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)), BigInteger.valueOf(123L), "arr", true);
    }

    @Test
    public void testGetArrays4() throws Exception {
        this.requireArrays();
        BooleanFormula f = this.mgr.parse("(declare-fun x () Int)\n(declare-fun arr () (Array Int Int))\n(assert (and    (= (select arr 5) x)    (= x 123)))");
        this.testModelIterator(f);
        this.testModelGetters(f, (Formula)this.imgr.makeVariable("x"), BigInteger.valueOf(123L), "x");
        this.testModelGetters(f, this.amgr.select(this.amgr.makeArray("arr", FormulaType.ArrayFormulaType.getArrayType(FormulaType.IntegerType, FormulaType.IntegerType)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L)), BigInteger.valueOf(123L), "arr", true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetArrays4invalid() throws Exception {
        this.requireArrays();
        BooleanFormula f = this.mgr.parse("(declare-fun x () Int)\n(declare-fun arr () (Array Int Int))\n(assert (and    (= (select arr 5) x)    (= x 123)))");
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(f);
            this.assertThatEnvironment(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                Object object = m.evaluate(this.amgr.makeArray("arr", FormulaType.ArrayFormulaType.getArrayType(FormulaType.IntegerType, FormulaType.IntegerType)));
            }
        }
    }

    @Test
    public void testGetArrays5() throws Exception {
        this.requireArrays();
        BooleanFormula f = this.mgr.parse("(declare-fun x () Int)\n(declare-fun arr () (Array Int Int))\n(assert (and    (= (select (store arr 6 x) 5) x)    (= x 123)))");
        this.testModelIterator(f);
        this.testModelGetters(f, (Formula)this.imgr.makeVariable("x"), BigInteger.valueOf(123L), "x");
        this.testModelGetters(f, this.amgr.select(this.amgr.makeArray("arr", FormulaType.ArrayFormulaType.getArrayType(FormulaType.IntegerType, FormulaType.IntegerType)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L)), BigInteger.valueOf(123L), "arr", true);
    }

    private void testModelIterator(BooleanFormula f) throws SolverException, InterruptedException {
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(f);
            this.assertThatEnvironment(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                for (Model.ValueAssignment valueAssignment : m) {
                }
                Truth.assertThat(prover.getModelAssignments()).containsExactlyElementsIn((Iterable)m).inOrder();
            }
        }
    }

    private void testModelGetters(BooleanFormula constraint, Formula variable, Object expectedValue, String varName) throws Exception {
        this.testModelGetters(constraint, variable, expectedValue, varName, false);
    }

    private void testModelGetters(BooleanFormula constraint, Formula variable, Object expectedValue, String varName, boolean isArray) throws Exception {
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(constraint);
            this.assertThatEnvironment(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                Truth.assertThat((Object)m.evaluate(variable)).isEqualTo(expectedValue);
                List relevantAssignments = prover.getModelAssignments().stream().filter(assignment -> assignment.getName().equals(varName)).collect(Collectors.toList());
                Truth.assertThat(relevantAssignments).isNotEmpty();
                if (isArray) {
                    List arrayAssignments = relevantAssignments.stream().filter(assignment -> expectedValue.equals(assignment.getValue())).collect(Collectors.toList());
                    Truth.assertThat(arrayAssignments).isNotEmpty();
                } else {
                    Truth.assertThat(relevantAssignments).hasSize(1);
                    Model.ValueAssignment assignment2 = (Model.ValueAssignment)Iterables.getOnlyElement(relevantAssignments);
                    Truth.assertThat((Object)assignment2.getValue()).isEqualTo(expectedValue);
                    Truth.assertThat((Object)m.evaluate(assignment2.getKey())).isEqualTo(expectedValue);
                }
            }
        }
    }

    @Test
    public void ufTest() throws SolverException, InterruptedException {
        this.requireQuantifiers();
        this.requireBitvectors();
        FormulaType.BitvectorType t32 = FormulaType.BitvectorType.getBitvectorTypeWithSize(32);
        FunctionDeclaration<BitvectorFormula> si1 = this.fmgr.declareUF("*signed_int@1", t32, t32);
        FunctionDeclaration<BitvectorFormula> si2 = this.fmgr.declareUF("*signed_int@2", t32, t32);
        BitvectorFormula ctr = this.bvmgr.makeVariable(t32, "*signed_int@1@counter");
        BitvectorFormula adr = this.bvmgr.makeVariable(t32, "__ADDRESS_OF_test");
        BitvectorFormula num0 = this.bvmgr.makeBitvector(32, 0L);
        BitvectorFormula num4 = this.bvmgr.makeBitvector(32, 4L);
        BitvectorFormula num10 = this.bvmgr.makeBitvector(32, 10L);
        BooleanFormula a11 = this.bmgr.implication(this.bmgr.and(this.bvmgr.lessOrEquals(adr, ctr, false), this.bvmgr.lessThan(ctr, this.bvmgr.add(adr, num10), false)), this.bvmgr.equal(this.fmgr.callUF(si2, ctr), num0));
        BooleanFormula a21 = this.bmgr.not(this.bmgr.and(this.bvmgr.lessOrEquals(adr, ctr, false), this.bvmgr.lessThan(ctr, this.bvmgr.add(adr, num10), false)));
        BooleanFormula body = this.bmgr.and(a11, this.bmgr.implication(a21, this.bvmgr.equal(this.fmgr.callUF(si2, ctr), this.fmgr.callUF(si1, ctr))));
        BooleanFormula a1 = this.qmgr.forall(ctr, body);
        BooleanFormula a2 = this.bvmgr.equal(this.fmgr.callUF(si1, this.bvmgr.add(adr, this.bvmgr.multiply(num4, num0))), num0);
        BooleanFormula f = this.bmgr.and(a1, this.bvmgr.lessThan(num0, adr, true), this.bmgr.not(a2));
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(f);
            Truth.assertThat((Boolean)prover.isUnsat()).isFalse();
            try (Model m = prover.getModel();){
                Truth.assertThat((Boolean)m.evaluate(this.bmgr.makeBoolean(true))).isTrue();
            }
        }
    }

    @Test
    public void quantifierTestShort() throws SolverException, InterruptedException {
        this.requireQuantifiers();
        NumeralFormula.IntegerFormula ctr = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
        BooleanFormula body = this.imgr.equal(ctr, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L));
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(this.qmgr.exists(ctr, body));
            Truth.assertThat((Boolean)prover.isUnsat()).isFalse();
            try (Model m = prover.getModel();){
                for (Model.ValueAssignment v : m) {
                    Truth.assertThat((Boolean)BigInteger.ZERO.equals(v.getValue())).isTrue();
                }
            }
            prover.pop();
            prover.push(body);
            Truth.assertThat((Boolean)prover.isUnsat()).isFalse();
            m = prover.getModel();
            var6_8 = null;
            try {
                Model.ValueAssignment v = m.iterator().next();
                Truth.assertThat((Boolean)"x".equals(v.getName())).isTrue();
                Truth.assertThat((Boolean)BigInteger.ZERO.equals(v.getValue())).isTrue();
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (m != null) {
                    if (var6_8 != null) {
                        try {
                            m.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        m.close();
                    }
                }
            }
        }
    }
}

