/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.rationals.ExtendedRational;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class FloatingPointFormulaManagerTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;
    private FormulaType.FloatingPointType singlePrecType;
    private FloatingPointFormula nan;
    private FloatingPointFormula posInf;
    private FloatingPointFormula negInf;
    private FloatingPointFormula zero;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Before
    public void init() {
        this.requireFloats();
        this.singlePrecType = FormulaType.getSinglePrecisionFloatingPointType();
        this.nan = this.fpmgr.makeNaN(this.singlePrecType);
        this.posInf = this.fpmgr.makePlusInfinity(this.singlePrecType);
        this.negInf = this.fpmgr.makeMinusInfinity(this.singlePrecType);
        this.zero = this.fpmgr.makeNumber(0.0, this.singlePrecType);
    }

    @Test
    public void floatingPointType() {
        FormulaType.FloatingPointType type = FormulaType.getFloatingPointType(23, 42);
        FloatingPointFormula var = this.fpmgr.makeVariable("x", type);
        FormulaType.FloatingPointType result = (FormulaType.FloatingPointType)this.mgr.getFormulaType(var);
        ((IntegerSubject)Truth.assertThat((Integer)result.getExponentSize()).named("exponent size")).isEqualTo((Object)type.getExponentSize());
        ((IntegerSubject)Truth.assertThat((Integer)result.getMantissaSize()).named("mantissa size")).isEqualTo((Object)type.getMantissaSize());
    }

    @Test
    public void nanEqualNanIsUnsat() throws Exception {
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(this.nan, this.nan)).isUnsatisfiable();
    }

    @Test
    public void nanAssignedNanIsTrue() throws Exception {
        this.assertThatFormula(this.fpmgr.assignment(this.nan, this.nan)).isTautological();
    }

    @Test
    public void infinityOrdering() throws Exception {
        BooleanFormula order1 = this.fpmgr.greaterThan(this.posInf, this.zero);
        BooleanFormula order2 = this.fpmgr.greaterThan(this.zero, this.negInf);
        BooleanFormula order3 = this.fpmgr.greaterThan(this.posInf, this.negInf);
        this.assertThatFormula(this.bmgr.and(order1, order2, order3)).isTautological();
    }

    @Test
    public void infinityVariableOrdering() throws Exception {
        FloatingPointFormula var = this.fpmgr.makeVariable("x", this.singlePrecType);
        BooleanFormula varIsNan = this.fpmgr.isNaN(var);
        BooleanFormula order1 = this.fpmgr.greaterOrEquals(this.posInf, var);
        BooleanFormula order2 = this.fpmgr.lessOrEquals(this.negInf, var);
        this.assertThatFormula(this.bmgr.or(varIsNan, this.bmgr.and(order1, order2))).isTautological();
    }

    @Test
    public void specialValueFunctions() throws Exception {
        this.assertThatFormula(this.fpmgr.isInfinity(this.posInf)).isTautological();
        this.assertThatFormula(this.fpmgr.isInfinity(this.negInf)).isTautological();
        this.assertThatFormula(this.fpmgr.isNaN(this.nan)).isTautological();
        this.assertThatFormula(this.fpmgr.isZero(this.zero)).isTautological();
        this.assertThatFormula(this.fpmgr.isZero(this.fpmgr.makeNumber(-0.0, this.singlePrecType))).isTautological();
        FloatingPointFormula minPosNormalValue = this.fpmgr.makeNumber(1.1754943508222875E-38, this.singlePrecType);
        this.assertThatFormula(this.fpmgr.isSubnormal(minPosNormalValue)).isUnsatisfiable();
        this.assertThatFormula(this.fpmgr.isZero(minPosNormalValue)).isUnsatisfiable();
    }

    @Test
    public void specialDoubles() throws Exception {
        this.assertThatFormula(this.fpmgr.assignment(this.fpmgr.makeNumber(Double.NaN, this.singlePrecType), this.nan)).isTautological();
        this.assertThatFormula(this.fpmgr.assignment(this.fpmgr.makeNumber(Double.POSITIVE_INFINITY, this.singlePrecType), this.posInf)).isTautological();
        this.assertThatFormula(this.fpmgr.assignment(this.fpmgr.makeNumber(Double.NEGATIVE_INFINITY, this.singlePrecType), this.negInf)).isTautological();
    }

    private void checkEqualityOfNumberConstantsFor(double value, FormulaType.FloatingPointType type) throws Exception {
        FloatingPointFormula doubleNumber = this.fpmgr.makeNumber(value, type);
        FloatingPointFormula stringNumber = this.fpmgr.makeNumber(Double.toString(value), type);
        FloatingPointFormula bigDecimalNumber = this.fpmgr.makeNumber(new BigDecimal(value), type);
        FloatingPointFormula rationalNumber = this.fpmgr.makeNumber(Rational.ofBigDecimal((BigDecimal)new BigDecimal(value)), type);
        BooleanFormula eq1 = this.fpmgr.equalWithFPSemantics(doubleNumber, stringNumber);
        BooleanFormula eq2 = this.fpmgr.equalWithFPSemantics(doubleNumber, bigDecimalNumber);
        BooleanFormula eq3 = this.fpmgr.equalWithFPSemantics(doubleNumber, rationalNumber);
        this.assertThatFormula(this.bmgr.and(eq1, eq2, eq3)).isTautological();
    }

    @Test
    public void numberConstants() throws Exception {
        FormulaType.FloatingPointType doublePrecType = FormulaType.getDoublePrecisionFloatingPointType();
        this.checkEqualityOfNumberConstantsFor(1.0, this.singlePrecType);
        this.checkEqualityOfNumberConstantsFor(-5.877471754111438E-39, this.singlePrecType);
        this.checkEqualityOfNumberConstantsFor(-5.877471754111438E-39, doublePrecType);
        this.checkEqualityOfNumberConstantsFor(3.4028234663852886E38, this.singlePrecType);
        this.checkEqualityOfNumberConstantsFor(3.4028234663852886E38, doublePrecType);
    }

    @Test
    public void cast() throws Exception {
        FormulaType.FloatingPointType doublePrecType = FormulaType.getDoublePrecisionFloatingPointType();
        FloatingPointFormula doublePrecNumber = this.fpmgr.makeNumber(1.5, doublePrecType);
        FloatingPointFormula singlePrecNumber = this.fpmgr.makeNumber(1.5, this.singlePrecType);
        FloatingPointFormula narrowedNumber = this.fpmgr.castTo(doublePrecNumber, this.singlePrecType);
        FloatingPointFormula widenedNumber = this.fpmgr.castTo(singlePrecNumber, doublePrecType);
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(narrowedNumber, singlePrecNumber)).isTautological();
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(widenedNumber, doublePrecNumber)).isTautological();
        FloatingPointFormula doublePrecSmallNumber = this.fpmgr.makeNumber(5.877471754111438E-39, doublePrecType);
        FloatingPointFormula singlePrecSmallNumber = this.fpmgr.makeNumber(5.877471754111438E-39, this.singlePrecType);
        FloatingPointFormula widenedSmallNumber = this.fpmgr.castTo(singlePrecSmallNumber, doublePrecType);
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(widenedSmallNumber, doublePrecSmallNumber)).isTautological();
    }

    @Test
    public void bvToFpOne() throws Exception {
        this.requireBitvectors();
        BitvectorFormula bvOne = this.bvmgr.makeBitvector(32, 1L);
        FloatingPointFormula fpOne = this.fpmgr.makeNumber(1.0, this.singlePrecType);
        FloatingPointFormula signedBvToFpOne = this.fpmgr.castFrom(bvOne, true, this.singlePrecType);
        FloatingPointFormula unsignedBvToFpOne = this.fpmgr.castFrom(bvOne, false, this.singlePrecType);
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(fpOne, signedBvToFpOne)).isTautological();
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(fpOne, unsignedBvToFpOne)).isTautological();
    }

    @Test
    public void bvToFpMinusOne() throws Exception {
        this.requireBitvectors();
        BitvectorFormula bvOne = this.bvmgr.makeBitvector(32, -1L);
        FloatingPointFormula fpOne = this.fpmgr.makeNumber(-1.0, this.singlePrecType);
        FloatingPointFormula fpMinInt = this.fpmgr.makeNumber(Math.pow(2.0, 32.0) - 1.0, this.singlePrecType);
        FloatingPointFormula unsignedBvToFpOne = this.fpmgr.castFrom(bvOne, false, this.singlePrecType);
        FloatingPointFormula signedBvToFpOne = this.fpmgr.castFrom(bvOne, true, this.singlePrecType);
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(fpOne, signedBvToFpOne)).isTautological();
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(fpMinInt, unsignedBvToFpOne)).isTautological();
    }

    @Test
    public void fpToBvOne() throws Exception {
        this.requireBitvectors();
        BitvectorFormula bvOne = this.bvmgr.makeBitvector(32, 1L);
        FloatingPointFormula fpOne = this.fpmgr.makeNumber(1.0, this.singlePrecType);
        BitvectorFormula fpToBvOne = this.fpmgr.castTo(fpOne, FormulaType.getBitvectorTypeWithSize(32));
        this.assertThatFormula(this.bvmgr.equal(bvOne, fpToBvOne)).isTautological();
    }

    @Test
    public void fpToBvMinusOne() throws Exception {
        this.requireBitvectors();
        BitvectorFormula bvOne = this.bvmgr.makeBitvector(32, -1L);
        FloatingPointFormula fpOne = this.fpmgr.makeNumber(-1.0, this.singlePrecType);
        BitvectorFormula fpToBvOne = this.fpmgr.castTo(fpOne, FormulaType.getBitvectorTypeWithSize(32));
        this.assertThatFormula(this.bvmgr.equal(bvOne, fpToBvOne)).isTautological();
    }

    @Test
    public void rationalToFpOne() throws Exception {
        this.requireRationals();
        Object ratOne = this.rmgr.makeNumber(1L);
        FloatingPointFormula fpOne = this.fpmgr.makeNumber(1.0, this.singlePrecType);
        FloatingPointFormula ratToFpOne = this.fpmgr.castFrom((Formula)ratOne, true, this.singlePrecType);
        FloatingPointFormula unsignedRatToFpOne = this.fpmgr.castFrom((Formula)ratOne, false, this.singlePrecType);
        Truth.assertThat((Object)unsignedRatToFpOne).isEqualTo((Object)ratToFpOne);
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(fpOne, ratToFpOne)).isSatisfiable();
    }

    @Test
    public void rationalToFpMinusOne() throws Exception {
        this.requireBitvectors();
        Object ratOne = this.rmgr.makeNumber(-1L);
        FloatingPointFormula fpOne = this.fpmgr.makeNumber(-1.0, this.singlePrecType);
        FloatingPointFormula ratToFpOne = this.fpmgr.castFrom((Formula)ratOne, true, this.singlePrecType);
        FloatingPointFormula unsignedRatToFpOne = this.fpmgr.castFrom((Formula)ratOne, false, this.singlePrecType);
        Truth.assertThat((Object)unsignedRatToFpOne).isEqualTo((Object)ratToFpOne);
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(fpOne, ratToFpOne)).isSatisfiable();
    }

    @Test
    public void fpToRationalOne() throws Exception {
        this.requireRationals();
        Object ratOne = this.rmgr.makeNumber(1L);
        FloatingPointFormula fpOne = this.fpmgr.makeNumber(1.0, this.singlePrecType);
        NumeralFormula fpToRatOne = this.fpmgr.castTo(fpOne, FormulaType.RationalType);
        this.assertThatFormula(this.rmgr.equal(ratOne, fpToRatOne)).isSatisfiable();
    }

    @Test
    public void fpToRationalMinusOne() throws Exception {
        this.requireRationals();
        Object ratOne = this.rmgr.makeNumber(-1L);
        FloatingPointFormula fpOne = this.fpmgr.makeNumber(-1.0, this.singlePrecType);
        NumeralFormula fpToRatOne = this.fpmgr.castTo(fpOne, FormulaType.RationalType);
        this.assertThatFormula(this.rmgr.equal(ratOne, fpToRatOne)).isSatisfiable();
    }

    @Test
    public void fpTraversal() throws Exception {
        Truth.assertThat(this.mgr.extractVariables(this.zero)).isEmpty();
        Truth.assertThat(this.mgr.extractVariablesAndUFs(this.zero)).isEmpty();
        FloatingPointFormula one = this.fpmgr.makeNumber(1.0, this.singlePrecType);
        Truth.assertThat(this.mgr.extractVariables(one)).isEmpty();
        Truth.assertThat(this.mgr.extractVariablesAndUFs(one)).isEmpty();
        Truth.assertThat(this.mgr.extractVariables(this.posInf)).isEmpty();
        Truth.assertThat(this.mgr.extractVariablesAndUFs(this.posInf)).isEmpty();
        Truth.assertThat(this.mgr.extractVariables(this.nan)).isEmpty();
        Truth.assertThat(this.mgr.extractVariablesAndUFs(this.nan)).isEmpty();
        FloatingPointFormula var = this.fpmgr.makeVariable("x", this.singlePrecType);
        Truth.assertThat(this.mgr.extractVariables(var)).containsExactly((Object)"x", (Object)var, new Object[0]);
        Truth.assertThat(this.mgr.extractVariablesAndUFs(var)).containsExactly((Object)"x", (Object)var, new Object[0]);
    }

    @Test
    public void fpTraversalWithRoundingMode() throws Exception {
        FloatingPointFormula two = this.fpmgr.makeNumber(2.0, this.singlePrecType);
        FloatingPointFormula var = this.fpmgr.makeVariable("x", this.singlePrecType);
        FloatingPointFormula mult = this.fpmgr.multiply(two, var);
        Truth.assertThat(this.mgr.extractVariables(mult)).containsExactly((Object)"x", (Object)var, new Object[0]);
        Truth.assertThat(this.mgr.extractVariablesAndUFs(mult)).containsExactly((Object)"x", (Object)var, new Object[0]);
    }

    @Test
    public void fpModelValue() throws Exception {
        FloatingPointFormula zeroVar = this.fpmgr.makeVariable("zero", this.singlePrecType);
        BooleanFormula zeroEq = this.fpmgr.assignment(zeroVar, this.zero);
        FloatingPointFormula oneVar = this.fpmgr.makeVariable("one", this.singlePrecType);
        BooleanFormula oneEq = this.fpmgr.assignment(oneVar, this.fpmgr.makeNumber(1.0, this.singlePrecType));
        FloatingPointFormula nanVar = this.fpmgr.makeVariable("nan", this.singlePrecType);
        BooleanFormula nanEq = this.fpmgr.assignment(nanVar, this.nan);
        FloatingPointFormula posInfVar = this.fpmgr.makeVariable("posInf", this.singlePrecType);
        BooleanFormula posInfEq = this.fpmgr.assignment(posInfVar, this.posInf);
        FloatingPointFormula negInfVar = this.fpmgr.makeVariable("negInf", this.singlePrecType);
        BooleanFormula negInfEq = this.fpmgr.assignment(negInfVar, this.negInf);
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(zeroEq);
            prover.push(oneEq);
            prover.push(nanEq);
            prover.push(posInfEq);
            prover.push(negInfEq);
            this.assertThatEnvironment(prover).isSatisfiable();
            try (Model model = prover.getModel();){
                Object zeroValue = model.evaluate(zeroVar);
                Model.ValueAssignment zeroAssignment = new Model.ValueAssignment(zeroVar, "zero", zeroValue, (Collection<?>)ImmutableList.of());
                Truth.assertThat((Object)zeroValue).isAnyOf((Object)ExtendedRational.ZERO, (Object)Rational.ZERO, new Object[]{BigDecimal.ZERO, 0.0, Float.valueOf(0.0f)});
                Object oneValue = model.evaluate(oneVar);
                Model.ValueAssignment oneAssignment = new Model.ValueAssignment(oneVar, "one", oneValue, (Collection<?>)ImmutableList.of());
                Truth.assertThat((Object)oneValue).isAnyOf((Object)new ExtendedRational(Rational.ONE), (Object)Rational.ONE, new Object[]{BigDecimal.ONE, 1.0, Float.valueOf(1.0f)});
                Object nanValue = model.evaluate(nanVar);
                Model.ValueAssignment nanAssignment = new Model.ValueAssignment(nanVar, "nan", nanValue, (Collection<?>)ImmutableList.of());
                Truth.assertThat((Object)nanValue).isAnyOf((Object)ExtendedRational.NaN, (Object)Double.NaN, new Object[]{Float.valueOf(Float.NaN)});
                Object posInfValue = model.evaluate(posInfVar);
                Model.ValueAssignment posInfAssignment = new Model.ValueAssignment(posInfVar, "posInf", posInfValue, (Collection<?>)ImmutableList.of());
                Truth.assertThat((Object)posInfValue).isAnyOf((Object)ExtendedRational.INFTY, (Object)Double.POSITIVE_INFINITY, new Object[]{Float.valueOf(Float.POSITIVE_INFINITY)});
                Object negInfValue = model.evaluate(negInfVar);
                Model.ValueAssignment negInfAssignment = new Model.ValueAssignment(negInfVar, "negInf", negInfValue, (Collection<?>)ImmutableList.of());
                Truth.assertThat((Object)negInfValue).isAnyOf((Object)ExtendedRational.NEG_INFTY, (Object)Double.NEGATIVE_INFINITY, new Object[]{Float.valueOf(Float.NEGATIVE_INFINITY)});
                Truth.assertThat((Iterable)model).containsExactly(new Object[]{zeroAssignment, oneAssignment, nanAssignment, posInfAssignment, negInfAssignment});
            }
        }
    }

    @Test
    public void fpInterpolation() throws Exception {
        TruthJUnit.assume().withFailureMessage("MathSAT5 does not support floating-point interpolation").that((Comparable)((Object)this.solver)).isNotEqualTo((Object)SolverContextFactory.Solvers.MATHSAT5);
        FloatingPointFormula var = this.fpmgr.makeVariable("x", this.singlePrecType);
        BooleanFormula f1 = this.fpmgr.equalWithFPSemantics(var, this.zero);
        BooleanFormula f2 = this.bmgr.not(this.fpmgr.isZero(var));
        try (InterpolatingProverEnvironment<?> prover = this.context.newProverEnvironmentWithInterpolation();){
            Object itpGroup1 = prover.push(f1);
            prover.push(f2);
            this.assertThatEnvironment(prover).isUnsatisfiable();
            BooleanFormula itp = prover.getInterpolant((List<?>)ImmutableList.of(itpGroup1));
            this.assertThatFormula(f1).implies(itp);
            this.assertThatFormula(this.bmgr.and(itp, f2)).isUnsatisfiable();
        }
    }
}

