/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolEnvironment;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaCreator;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolNumeralFormulaManager;

class SmtInterpolIntegerFormulaManager
extends SmtInterpolNumeralFormulaManager<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula>
implements IntegerFormulaManager {
    SmtInterpolIntegerFormulaManager(SmtInterpolFormulaCreator pCreator) {
        super(pCreator);
    }

    @Override
    protected Term makeNumberImpl(long i) {
        return ((SmtInterpolEnvironment)this.getFormulaCreator().getEnv()).numeral(BigInteger.valueOf(i));
    }

    @Override
    protected Term makeNumberImpl(BigInteger pI) {
        return ((SmtInterpolEnvironment)this.getFormulaCreator().getEnv()).numeral(pI);
    }

    @Override
    protected Term makeNumberImpl(String pI) {
        return ((SmtInterpolEnvironment)this.getFormulaCreator().getEnv()).numeral(pI);
    }

    @Override
    protected Term makeNumberImpl(double pNumber) {
        return this.makeNumberImpl((long)pNumber);
    }

    @Override
    protected Term makeNumberImpl(BigDecimal pNumber) {
        return (Term)this.decimalAsInteger(pNumber);
    }

    @Override
    protected Term makeVariableImpl(String varName) {
        Sort t = (Sort)this.getFormulaCreator().getIntegerType();
        return (Term)this.getFormulaCreator().makeVariable(t, varName);
    }

    @Override
    public Term divide(Term pNumber1, Term pNumber2) {
        if (this.isNumeral(pNumber2)) {
            Sort intSort = pNumber1.getTheory().getNumericSort();
            assert (intSort.equals(pNumber1.getSort()) && intSort.equals(pNumber2.getSort()));
            return ((SmtInterpolEnvironment)this.getFormulaCreator().getEnv()).term("div", pNumber1, pNumber2);
        }
        return super.divide(pNumber1, pNumber2);
    }

    @Override
    protected Term modulo(Term pNumber1, Term pNumber2) {
        if (this.isNumeral(pNumber2)) {
            Sort intSort = pNumber1.getTheory().getNumericSort();
            assert (intSort.equals(pNumber1.getSort()) && intSort.equals(pNumber2.getSort()));
            return ((SmtInterpolEnvironment)this.getFormulaCreator().getEnv()).term("mod", pNumber1, pNumber2);
        }
        return super.modulo(pNumber1, pNumber2);
    }

    @Override
    protected Term modularCongruence(Term pNumber1, Term pNumber2, long pModulo) {
        Sort intSort = pNumber1.getTheory().getNumericSort();
        assert (intSort.equals(pNumber1.getSort()) && intSort.equals(pNumber2.getSort()));
        Term n = this.env.numeral(BigInteger.valueOf(pModulo));
        Term x = this.subtract(pNumber1, pNumber2);
        return this.env.term("=", x, this.env.term("*", n, this.env.term("div", x, n)));
    }
}

