/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolEnvironment;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolModel;

abstract class SmtInterpolBasicProver<T, AF>
implements BasicProverEnvironment<T> {
    private boolean closed = false;
    private final SmtInterpolEnvironment env;
    private final FormulaCreator<Term, Sort, SmtInterpolEnvironment, FunctionSymbol> creator;
    protected final Deque<List<AF>> assertedFormulas = new ArrayDeque<List<AF>>();
    private static final String PREFIX = "term_";
    private static final UniqueIdGenerator termIdGenerator = new UniqueIdGenerator();

    SmtInterpolBasicProver(SmtInterpolFormulaManager pMgr) {
        this.env = pMgr.createEnvironment();
        this.creator = pMgr.getFormulaCreator();
    }

    protected boolean isClosed() {
        return this.closed;
    }

    @Override
    public final void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.assertedFormulas.push(new ArrayList());
        this.env.push(1);
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.assertedFormulas.pop();
        this.env.pop(1);
    }

    @Override
    public boolean isUnsat() throws InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return !this.env.checkSat();
    }

    @Override
    public SmtInterpolModel getModel() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return new SmtInterpolModel(this.env.getModel(), this.creator, this.getAssertedTerms());
    }

    @Override
    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        try (SmtInterpolModel model = this.getModel();){
            ImmutableList<Model.ValueAssignment> immutableList = model.modelToList();
            return immutableList;
        }
    }

    protected static String generateTermName() {
        return PREFIX + termIdGenerator.getFreshId();
    }

    protected abstract Collection<Term> getAssertedTerms();

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.assertedFormulas.clear();
        this.env.pop(this.env.getStackDepth());
        this.closed = true;
    }

    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException("Assumption-solving is not supported.");
    }
}

