/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.princess;

import ap.parser.BooleanCompactifier;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.PartialEvaluator;
import com.google.common.collect.Iterables;
import org.sosy_lab.common.Appender;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessEnvironment;
import org.sosy_lab.java_smt.solvers.princess.PrincessFormulaCreator;
import org.sosy_lab.java_smt.solvers.princess.PrincessFunctionDeclaration;
import org.sosy_lab.java_smt.solvers.princess.PrincessIntegerFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessQuantifiedFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessTermType;
import org.sosy_lab.java_smt.solvers.princess.PrincessUFManager;

final class PrincessFormulaManager
extends AbstractFormulaManager<IExpression, PrincessTermType, PrincessEnvironment, PrincessFunctionDeclaration> {
    private final PrincessFormulaCreator creator;

    PrincessFormulaManager(PrincessFormulaCreator pCreator, PrincessUFManager pFunctionManager, PrincessBooleanFormulaManager pBooleanManager, PrincessIntegerFormulaManager pIntegerManager, PrincessArrayFormulaManager pArrayManager, PrincessQuantifiedFormulaManager pQuantifierManager) {
        super(pCreator, pFunctionManager, pBooleanManager, pIntegerManager, null, null, null, pQuantifierManager, pArrayManager);
        this.creator = pCreator;
    }

    BooleanFormula encapsulateBooleanFormula(IExpression t) {
        return this.getFormulaCreator().encapsulateBoolean(t);
    }

    @Override
    public BooleanFormula parse(String pS) throws IllegalArgumentException {
        return this.encapsulateBooleanFormula((IExpression)Iterables.getOnlyElement(((PrincessEnvironment)this.getEnvironment()).parseStringToTerms(pS, this.creator)));
    }

    @Override
    public Appender dumpFormula(IExpression formula) {
        assert (this.getFormulaCreator().getFormulaType(formula) == FormulaType.BooleanType) : "Only BooleanFormulas may be dumped";
        return ((PrincessEnvironment)this.getEnvironment()).dumpFormula((IFormula)formula, this.creator);
    }

    @Override
    protected IExpression simplify(IExpression f) {
        if (f instanceof IFormula) {
            f = BooleanCompactifier.apply((IFormula)((IFormula)f));
        }
        return PartialEvaluator.apply((IExpression)f);
    }
}

